/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.CharacterReferenceGenerator;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HexCharacterReferenceGenerator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import ro.sync.exml.editor.xmleditor.prettyprint.k;
import ro.sync.exml.xmlrefactory.b;
import ro.sync.exml.xmlrefactory.f.f;
import ro.sync.util.Equaler;
import ro.sync.xml.XmlUtil;

public class XMLEmitter
extends Emitter {
    private List<AttributeOrNSInfo> currentElementAttrList = new ArrayList<AttributeOrNSInfo>();
    private String currentElementStartTagInfo = null;
    f currentAttributeDecl = null;
    protected boolean started = false;
    protected boolean startedElement = false;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected NodeName elementCode;
    protected int indentForNextAttribute = -1;
    protected boolean undeclareNamespaces = false;
    protected Stack<String> elementStack = new Stack();
    private boolean indenting = false;
    private String indentChars = "\n                                                          ";
    private boolean requireWellFormed = false;
    protected CharacterReferenceGenerator characterReferenceGenerator = HexCharacterReferenceGenerator.THE_INSTANCE;
    private boolean preserveAttributesOrder;
    static boolean[] specialInText;
    static boolean[] specialInAtt;

    public void setCharacterReferenceGenerator(CharacterReferenceGenerator characterReferenceGenerator) {
        this.characterReferenceGenerator = characterReferenceGenerator;
    }

    public void setEscapeNonAscii(Boolean bl) {
    }

    public void open() throws XPathException {
    }

    public void startDocument(int n2) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        String string;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        if ((string = this.outputProperties.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = string.equalsIgnoreCase("yes");
        }
        this.writeDeclaration();
        if (this.outputProperties != null && this.outputProperties.getProperty("oxy_unescape_writer") != null) {
            String string2 = this.outputProperties.getProperty("oxy_unescape_writer_header");
            if (string2 != null) {
                try {
                    this.writer.write(string2);
                }
                catch (IOException iOException) {
                    throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
                }
            }
            this.writer = new k(this.writer);
        }
        if (this.outputProperties.getProperty("processAttributeValues") != null) {
            this.preserveAttributesOrder = true;
        }
    }

    public void writeDeclaration() throws XPathException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String string;
            String string2;
            String string3;
            this.indenting = "yes".equals(this.outputProperties.getProperty("indent"));
            String string4 = this.outputProperties.getProperty("byte-order-mark");
            String string5 = this.outputProperties.getProperty("encoding");
            if (string5 == null || string5.equalsIgnoreCase("utf8")) {
                string5 = "UTF-8";
            }
            if ("yes".equals(string4) && ("UTF-8".equalsIgnoreCase(string5) || "UTF-16LE".equalsIgnoreCase(string5) || "UTF-16BE".equalsIgnoreCase(string5))) {
                this.writer.write(65279);
            }
            if ((string3 = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                string3 = "no";
            }
            if ((string2 = this.outputProperties.getProperty("version")) == null) {
                string2 = this.getConfiguration().getXMLVersion() == 10 ? "1.0" : "1.1";
            } else {
                if (!string2.equals("1.0") && !string2.equals("1.1")) {
                    XPathException xPathException = new XPathException("XML version must be 1.0 or 1.1");
                    xPathException.setErrorCode("SESU0013");
                    throw xPathException;
                }
                if (!string2.equals("1.0") && string3.equals("yes") && this.outputProperties.getProperty("doctype-system") != null) {
                    XPathException xPathException = new XPathException("Values of 'version', 'omit-xml-declaration', and 'doctype-system' conflict");
                    xPathException.setErrorCode("SEPM0009");
                    throw xPathException;
                }
            }
            String string6 = this.outputProperties.getProperty("undeclare-prefixes");
            if ("yes".equals(string6)) {
                this.undeclareNamespaces = true;
            }
            if (string2.equals("1.0") && this.undeclareNamespaces) {
                XPathException xPathException = new XPathException("Cannot undeclare namespaces with XML version 1.0");
                xPathException.setErrorCode("SEPM0010");
                throw xPathException;
            }
            String string7 = this.outputProperties.getProperty("standalone");
            if ("omit".equals(string7)) {
                string7 = null;
            }
            if (string7 != null) {
                this.requireWellFormed = true;
                if (string3.equals("yes")) {
                    XPathException xPathException = new XPathException("Values of 'standalone' and 'omit-xml-declaration' conflict");
                    xPathException.setErrorCode("SEPM0009");
                    throw xPathException;
                }
            }
            if ((string = this.outputProperties.getProperty("doctype-system")) != null && !"".equals(string)) {
                this.requireWellFormed = true;
            }
            if (string3.equals("no")) {
                this.writer.write("<?xml version=\"" + string2 + "\" " + "encoding=\"" + string5 + '\"' + (string7 != null ? " standalone=\"" + string7 + '\"' : "") + "?>");
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    protected void writeDocType(NodeName nodeName, String string, String string2, String string3) throws XPathException {
        try {
            if (this.declarationIsWritten && !this.indenting) {
                this.writer.write("\n");
            }
            this.writer.write("<!DOCTYPE " + string + '\n');
            String string4 = null;
            if (string2 != null) {
                string4 = string2.contains("\"") ? "'" + string2 + "'" : '\"' + string2 + '\"';
            }
            if (string2 != null && string3 == null) {
                this.writer.write("  SYSTEM " + string4 + ">\n");
            } else if (string2 == null && string3 != null) {
                this.writer.write("  PUBLIC \"" + string3 + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + string3 + "\" " + string4 + ">\n");
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    public void close() throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
        super.close();
    }

    public void startElement(NodeName nodeName, SchemaType schemaType, int n2, int n3) throws XPathException {
        int n4;
        this.currentElementStartTagInfo = null;
        if (!this.started) {
            this.openDocument();
        } else if (this.requireWellFormed && this.elementStack.isEmpty() && this.startedElement) {
            XPathException xPathException = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains more than one top-level element");
            xPathException.setErrorCode("SEPM0004");
            throw xPathException;
        }
        this.startedElement = true;
        String string = nodeName.getDisplayName();
        if (!this.allCharactersEncodable && (n4 = this.testCharacters(string)) != 0) {
            XPathException xPathException = new XPathException("Element name contains a character (decimal + " + n4 + ") not available in the selected encoding");
            xPathException.setErrorCode("SERE0008");
            throw xPathException;
        }
        this.elementStack.push(string);
        this.elementCode = nodeName;
        try {
            if (!this.started) {
                String string2 = this.outputProperties.getProperty("doctype-system");
                String string3 = this.outputProperties.getProperty("doctype-public");
                if ("".equals(string2)) {
                    string2 = null;
                }
                if ("".equals(string3)) {
                    string3 = null;
                }
                if (string2 != null) {
                    this.requireWellFormed = true;
                    this.writeDocType(nodeName, string, string2, string3);
                } else if (this.writeDocTypeWithNullSystemId()) {
                    this.writeDocType(nodeName, string, string2, string3);
                }
                this.started = true;
            }
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write(60);
            this.writer.write(string);
            this.openStartTag = true;
            this.indentForNextAttribute = -1;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    protected boolean writeDocTypeWithNullSystemId() {
        return false;
    }

    public void namespace(NamespaceBinding namespaceBinding, int n2) throws XPathException {
        String string = this.getAttributeIndentString();
        if (this.preserveAttributesOrder) {
            if (!b.h(namespaceBinding.getPrefix(), namespaceBinding.getURI())) {
                this.currentElementAttrList.add(new NamespaceInfo(namespaceBinding, n2, string));
            }
        } else {
            this.namespaceInternal(namespaceBinding, n2, string);
        }
    }

    private void namespaceInternal(NamespaceBinding namespaceBinding, int n2, String string) throws XPathException {
        try {
            String string2 = namespaceBinding.getPrefix();
            String string3 = namespaceBinding.getURI();
            String string4 = string;
            if (string2.length() == 0) {
                this.writer.write(string4);
                this.writeAttribute(this.elementCode, "xmlns", string3, 0);
            } else if (!string2.equals("xml")) {
                int n3 = this.testCharacters(string2);
                if (n3 != 0) {
                    XPathException xPathException = new XPathException("Namespace prefix contains a character (decimal + " + n3 + ") not available in the selected encoding");
                    xPathException.setErrorCode("SERE0008");
                    throw xPathException;
                }
                if (this.undeclareNamespaces || string3.length() != 0) {
                    this.writer.write(string4);
                    this.writeAttribute(this.elementCode, "xmlns:" + string2, string3, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    public void setIndentForNextAttribute(int n2) {
        this.indentForNextAttribute = n2;
    }

    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2, int n3) throws XPathException {
        int n4;
        String string = nodeName.getDisplayName();
        if (!this.allCharactersEncodable && (n4 = this.testCharacters(string)) != 0) {
            XPathException xPathException = new XPathException("Attribute name contains a character (decimal + " + n4 + ") not available in the selected encoding");
            xPathException.setErrorCode("SERE0008");
            throw xPathException;
        }
        if (this.preserveAttributesOrder) {
            this.currentElementAttrList.add(new AttributeInfo(nodeName, simpleType, charSequence, n2, n3, this.getAttributeIndentString()));
        } else {
            this.attributeInternal(nodeName, simpleType, charSequence, n2, n3, this.getAttributeIndentString());
        }
    }

    private void attributeInternal(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2, int n3, String string) throws XPathException {
        try {
            this.writer.write(string);
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
        String string2 = nodeName.getDisplayName();
        this.writeAttribute(this.elementCode, string2, charSequence, n3);
    }

    private void flushAttributes() throws XPathException {
        if (!this.currentElementAttrList.isEmpty()) {
            ArrayList<AttributeOrNSInfo> arrayList = new ArrayList<AttributeOrNSInfo>();
            ArrayList<AttributeOrNSInfo> arrayList2 = new ArrayList<AttributeOrNSInfo>();
            List<String> list = null;
            for (AttributeOrNSInfo attributeOrNSInfo : this.currentElementAttrList) {
                if (attributeOrNSInfo.isAdditionalAttribute()) {
                    if (b.o(attributeOrNSInfo.getDisplayName())) {
                        this.currentElementStartTagInfo = attributeOrNSInfo.getValue();
                        continue;
                    }
                    if (b.f(attributeOrNSInfo.getDisplayName())) {
                        list = b.w(attributeOrNSInfo.getValue());
                        continue;
                    }
                    arrayList2.add(attributeOrNSInfo);
                    continue;
                }
                arrayList.add(attributeOrNSInfo);
            }
            if (list != null) {
                Collections.sort(arrayList, new AttributesOrderComparator(list));
            }
            for (AttributeOrNSInfo attributeOrNSInfo : arrayList) {
                if (attributeOrNSInfo instanceof AttributeInfo) {
                    this.processAttribute(arrayList2, (AttributeInfo)attributeOrNSInfo);
                    continue;
                }
                this.processNamespace(arrayList2, (NamespaceInfo)attributeOrNSInfo);
            }
            this.currentElementAttrList.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processAttribute(List<AttributeOrNSInfo> list, AttributeInfo attributeInfo) throws XPathException {
        void var10_14;
        String string;
        String string2 = attributeInfo.getDisplayName();
        String string3 = b.d(string2);
        String string4 = b.r(string2);
        String string5 = b.u(string2);
        String string6 = null;
        String string7 = null;
        this.currentAttributeDecl = null;
        for (AttributeOrNSInfo object2 : list) {
            string = XmlUtil.getLocalName(object2.getDisplayName());
            String string8 = object2.getValue();
            if (Equaler.verifyEquals(string3, string)) {
                string6 = string8;
                continue;
            }
            if (Equaler.verifyEquals(string4, string)) {
                string7 = string8;
                continue;
            }
            if (!Equaler.verifyEquals(string5, string)) continue;
            this.currentAttributeDecl = b.i(string, string8);
        }
        boolean bl = false;
        String string9 = ((Object)attributeInfo.value).toString();
        if (string6 != null && Equaler.verifyEquals(string6, ((Object)attributeInfo.value).toString()) && string7 != null) {
            String string10 = string7;
            bl = true;
        }
        string = attributeInfo.indentString;
        if (this.currentAttributeDecl != null) {
            string = this.currentAttributeDecl.b();
        }
        this.attributeInternal(attributeInfo.nameCode, attributeInfo.typeCode, (CharSequence)var10_14, attributeInfo.locationId, bl ? 4 : attributeInfo.properties, string);
    }

    private void processNamespace(List<AttributeOrNSInfo> list, NamespaceInfo namespaceInfo) throws XPathException {
        String string = namespaceInfo.getDisplayName();
        String string2 = b.u(string);
        this.currentAttributeDecl = null;
        for (AttributeOrNSInfo attributeOrNSInfo : list) {
            String string3 = XmlUtil.getLocalName(attributeOrNSInfo.getDisplayName());
            String string4 = attributeOrNSInfo.getValue();
            if (!Equaler.verifyEquals(string2, string3)) continue;
            this.currentAttributeDecl = b.i(string3, string4);
        }
        Object object = namespaceInfo.indentString;
        if (this.currentAttributeDecl != null) {
            object = this.currentAttributeDecl.b();
        }
        this.namespaceInternal(namespaceInfo.namespaceBinding, namespaceInfo.properties, (String)object);
    }

    protected String getAttributeIndentString() {
        if (this.indentForNextAttribute < 0) {
            return " ";
        }
        int n2 = this.indentForNextAttribute;
        while (n2 >= this.indentChars.length()) {
            this.indentChars = this.indentChars + "                     ";
        }
        return this.indentChars.substring(0, n2);
    }

    public void startContent() throws XPathException {
    }

    public void closeStartTag() throws XPathException {
        try {
            if (this.preserveAttributesOrder) {
                this.flushAttributes();
            }
            if (this.openStartTag) {
                String string;
                if (this.preserveAttributesOrder && this.currentElementStartTagInfo != null && (string = b.t(this.currentElementStartTagInfo)) != null) {
                    this.writer.write(string);
                }
                this.writer.write(62);
                this.openStartTag = false;
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    protected String emptyElementTagCloser(String string, NodeName nodeName) {
        return "/>";
    }

    protected void writeAttribute(NodeName nodeName, String string, CharSequence charSequence, int n2) throws XPathException {
        try {
            String string2 = "";
            String string3 = "";
            int n3 = 34;
            if (this.currentAttributeDecl != null) {
                if (this.currentAttributeDecl.h() != null) {
                    string2 = this.currentAttributeDecl.h();
                }
                if (this.currentAttributeDecl.j() != null) {
                    string3 = this.currentAttributeDecl.j();
                }
                if (!this.currentAttributeDecl.i()) {
                    n3 = 39;
                }
            }
            String string4 = ((Object)charSequence).toString();
            this.writer.write(string);
            if ((n2 & 4) != 0) {
                this.writer.write(string2);
                this.writer.write(61);
                this.writer.write(string3);
                this.writer.write(n3);
                this.writer.write(string4);
                this.writer.write(n3);
            } else if ((n2 & 0x100) != 0) {
                this.writer.write(string2);
                this.writer.write(61);
                this.writer.write(string3);
                int n4 = n3;
                if (string4.indexOf(34) >= 0 || string4.indexOf(39) >= 0) {
                    n4 = string4.indexOf(34) >= 0 && string4.indexOf(39) < 0 ? 39 : 34;
                }
                this.writer.write(n4);
                this.writeEscape(charSequence, true);
                this.writer.write(n4);
            } else {
                this.writer.write(string2);
                this.writer.write("=");
                this.writer.write(string3);
                this.writer.write(n3);
                this.writeEscape(charSequence, true);
                this.writer.write(n3);
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    protected int testCharacters(CharSequence charSequence) throws XPathException {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 <= '\u007f') continue;
            if (UTF16CharacterSet.isHighSurrogate((int)c2)) {
                int n2;
                if (this.characterSet.inCharset(n2 = UTF16CharacterSet.combinePair((char)c2, (char)charSequence.charAt(++i2)))) continue;
                return n2;
            }
            if (this.characterSet.inCharset((int)c2)) continue;
            return c2;
        }
        return 0;
    }

    public void endElement() throws XPathException {
        block13: {
            String string = this.elementStack.pop();
            try {
                String string2;
                if (this.openStartTag) {
                    if (this.preserveAttributesOrder) {
                        this.flushAttributes();
                        if (this.currentElementStartTagInfo != null) {
                            boolean bl;
                            string2 = b.t(this.currentElementStartTagInfo);
                            if (string2 != null) {
                                this.writer.write(string2);
                            }
                            if (bl = b.x(this.currentElementStartTagInfo)) {
                                this.writer.write(this.emptyElementTagCloser(string, this.elementCode));
                            } else {
                                this.writer.write("></");
                                this.writer.write(string);
                                this.writer.write(62);
                            }
                        } else {
                            this.writer.write(this.emptyElementTagCloser(string, this.elementCode));
                        }
                    } else {
                        this.writer.write(this.emptyElementTagCloser(string, this.elementCode));
                    }
                    this.openStartTag = false;
                } else {
                    this.writer.write("</");
                    this.writer.write(string);
                    this.writer.write(62);
                }
                if (!this.preserveAttributesOrder || !this.elementStack.isEmpty() || (string2 = this.outputProperties.getProperty("TEXT_AFTER_ROOT")) == null) break block13;
                try {
                    this.writer.write(string2);
                }
                catch (IOException iOException) {
                    throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
                }
            }
            catch (IOException iOException) {
                throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
            }
        }
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        if (this.requireWellFormed && this.elementStack.isEmpty() && !Whitespace.isWhite((CharSequence)charSequence)) {
            XPathException xPathException = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
            xPathException.setErrorCode("SEPM0004");
            throw xPathException;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            if ((n3 & 4) != 0) {
                this.writeCharSequence(charSequence);
            } else if ((n3 & 1) == 0) {
                this.writeEscape(charSequence, false);
            } else if (this.testCharacters(charSequence) == 0) {
                if ((n3 & 0x100) == 0) {
                    this.writeCharSequence(charSequence);
                } else {
                    int n4 = charSequence.length();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        char c2 = charSequence.charAt(i2);
                        if (c2 == '\u0000') continue;
                        this.writer.write(c2);
                    }
                }
            } else {
                int n5 = charSequence.length();
                for (int i3 = 0; i3 < n5; ++i3) {
                    char[] cArray;
                    char c3 = charSequence.charAt(i3);
                    if (c3 == '\u0000') continue;
                    if (c3 > '\u007f' && UTF16CharacterSet.isHighSurrogate((int)c3)) {
                        int n6;
                        if (!this.characterSet.inCharset(n6 = UTF16CharacterSet.combinePair((char)c3, (char)(cArray = new char[]{c3, charSequence.charAt(++i3)})[1]))) {
                            this.writeEscape((CharSequence)new CharSlice(cArray), false);
                            continue;
                        }
                        this.writeCharSequence((CharSequence)new CharSlice(cArray));
                        continue;
                    }
                    cArray = new char[]{c3};
                    if (!this.characterSet.inCharset((int)c3)) {
                        this.writeEscape((CharSequence)new CharSlice(cArray), false);
                        continue;
                    }
                    this.writeCharSequence((CharSequence)new CharSlice(cArray));
                }
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    public void writeCharSequence(CharSequence charSequence) throws IOException {
        if (charSequence instanceof String) {
            this.writer.write((String)charSequence);
        } else if (charSequence instanceof CharSlice) {
            ((CharSlice)charSequence).write(this.writer);
        } else if (charSequence instanceof FastStringBuffer) {
            ((FastStringBuffer)charSequence).write(this.writer);
        } else if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).write(this.writer);
        } else {
            this.writer.write(((Object)charSequence).toString());
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        int n4;
        if (!this.started) {
            this.openDocument();
        }
        if ((n4 = this.testCharacters(string)) != 0) {
            XPathException xPathException = new XPathException("Character in processing instruction name cannot be represented in the selected encoding (code " + n4 + ')');
            xPathException.setErrorCode("SERE0008");
            throw xPathException;
        }
        n4 = this.testCharacters(charSequence);
        if (n4 != 0) {
            XPathException xPathException = new XPathException("Character in processing instruction data cannot be represented in the selected encoding (code " + n4 + ')');
            xPathException.setErrorCode("SERE0008");
            throw xPathException;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<?" + string + (charSequence.length() > 0 ? ' ' + ((Object)charSequence).toString() : "") + "?>");
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    protected void writeEscape(CharSequence charSequence, boolean bl) throws IOException, XPathException {
        boolean[] blArray;
        int n2 = 0;
        boolean bl2 = false;
        boolean[] blArray2 = blArray = bl ? specialInAtt : specialInText;
        if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).writeEscape(blArray, this.writer);
            return;
        }
        int n3 = charSequence.length();
        while (n2 < n3) {
            int n4;
            char c2;
            int n5 = n2;
            while (n5 < n3) {
                c2 = charSequence.charAt(n5);
                if (c2 < '\u007f') {
                    if (blArray[c2]) break;
                    ++n5;
                    continue;
                }
                if (c2 < '\u00a0' || c2 == '\u2028' || UTF16CharacterSet.isHighSurrogate((int)c2) || !this.characterSet.inCharset((int)c2)) break;
                ++n5;
            }
            if (n5 >= n3) {
                if (n2 == 0) {
                    this.writeCharSequence(charSequence);
                } else {
                    this.writeCharSequence(charSequence.subSequence(n2, n5));
                }
                return;
            }
            if (n5 > n2) {
                this.writeCharSequence(charSequence.subSequence(n2, n5));
            }
            if ((c2 = charSequence.charAt(n5)) == '\u0000') {
                bl2 = !bl2;
            } else if (bl2) {
                if (c2 > '\u007f') {
                    if (UTF16CharacterSet.isHighSurrogate((int)c2)) {
                        n4 = UTF16CharacterSet.combinePair((char)c2, (char)charSequence.charAt(n5 + 1));
                        if (!this.characterSet.inCharset(n4)) {
                            XPathException xPathException = new XPathException("Character x" + Integer.toHexString(n4) + " is not available in the chosen encoding");
                            xPathException.setErrorCode("SERE0008");
                            throw xPathException;
                        }
                    } else if (!this.characterSet.inCharset((int)c2)) {
                        XPathException xPathException = new XPathException("Character " + c2 + " (x" + Integer.toHexString(c2) + ") is not available in the chosen encoding");
                        xPathException.setErrorCode("SERE0008");
                        throw xPathException;
                    }
                }
                this.writer.write(c2);
            } else if (c2 < '\u007f') {
                if (c2 == '<') {
                    this.writer.write("&lt;");
                } else if (c2 == '>') {
                    if (this.preserveAttributesOrder) {
                        this.writer.write(">");
                    } else {
                        this.writer.write("&gt;");
                    }
                } else if (c2 == '&') {
                    this.writer.write("&amp;");
                } else if (c2 == '\"') {
                    this.writer.write("&#34;");
                } else if (c2 == '\n') {
                    this.writer.write("&#xA;");
                } else if (c2 == '\r') {
                    this.writer.write("&#xD;");
                } else if (c2 == '\t') {
                    this.writer.write("&#x9;");
                } else {
                    this.characterReferenceGenerator.outputCharacterReference((int)c2, this.writer);
                }
            } else if (c2 < '\u00a0' || c2 == '\u2028') {
                this.characterReferenceGenerator.outputCharacterReference((int)c2, this.writer);
            } else if (UTF16CharacterSet.isHighSurrogate((int)c2)) {
                int n6;
                if (this.characterSet.inCharset(n6 = UTF16CharacterSet.combinePair((char)c2, (char)(n4 = (int)charSequence.charAt(++n5))))) {
                    this.writer.write(c2);
                    this.writer.write(n4);
                } else {
                    this.characterReferenceGenerator.outputCharacterReference(n6, this.writer);
                }
            } else {
                this.characterReferenceGenerator.outputCharacterReference((int)c2, this.writer);
            }
            n2 = ++n5;
        }
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        int n4;
        if (!this.started) {
            this.openDocument();
        }
        if ((n4 = this.testCharacters(charSequence)) != 0) {
            XPathException xPathException = new XPathException("Character in comment cannot be represented in the selected encoding (code " + n4 + ')');
            xPathException.setErrorCode("SERE0008");
            throw xPathException;
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<!--");
            this.writer.write(((Object)charSequence).toString());
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), (Throwable)iOException);
        }
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    static {
        int n2;
        specialInText = new boolean[128];
        for (n2 = 0; n2 <= 31; ++n2) {
            XMLEmitter.specialInText[n2] = true;
        }
        for (n2 = 32; n2 <= 127; ++n2) {
            XMLEmitter.specialInText[n2] = false;
        }
        XMLEmitter.specialInText[10] = false;
        XMLEmitter.specialInText[9] = false;
        XMLEmitter.specialInText[13] = true;
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        for (n2 = 0; n2 <= 31; ++n2) {
            XMLEmitter.specialInAtt[n2] = true;
        }
        for (n2 = 32; n2 <= 127; ++n2) {
            XMLEmitter.specialInAtt[n2] = false;
        }
        XMLEmitter.specialInAtt[0] = true;
        XMLEmitter.specialInAtt[13] = true;
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[9] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
    }

    private class AttributeInfo
    implements AttributeOrNSInfo {
        private final NodeName nameCode;
        private final SimpleType typeCode;
        private final CharSequence value;
        private final int locationId;
        private final int properties;
        private boolean additionalAttribute;
        private String indentString;

        public AttributeInfo(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2, int n3, String string) {
            this.nameCode = nodeName;
            this.typeCode = simpleType;
            this.value = charSequence;
            this.locationId = n2;
            this.properties = n3;
            this.indentString = string;
            this.additionalAttribute = b.e(nodeName.getLocalPart());
        }

        @Override
        public boolean isAdditionalAttribute() {
            return this.additionalAttribute;
        }

        @Override
        public String getDisplayName() {
            return this.nameCode.getDisplayName();
        }

        @Override
        public String getValue() {
            return String.valueOf(this.value);
        }
    }

    private static interface AttributeOrNSInfo {
        public boolean isAdditionalAttribute();

        public String getDisplayName();

        public String getValue();
    }

    private static class NamespaceInfo
    implements AttributeOrNSInfo {
        private NamespaceBinding namespaceBinding;
        private int properties;
        private String indentString;

        public NamespaceInfo(NamespaceBinding namespaceBinding, int n2, String string) {
            this.namespaceBinding = namespaceBinding;
            this.properties = n2;
            this.indentString = string;
        }

        @Override
        public boolean isAdditionalAttribute() {
            return false;
        }

        @Override
        public String getDisplayName() {
            String string = this.namespaceBinding.getPrefix();
            if (string == null || string.isEmpty()) {
                return "xmlns";
            }
            return "xmlns:" + string;
        }

        @Override
        public String getValue() {
            return this.namespaceBinding.getURI();
        }
    }

    private static class AttributesOrderComparator
    implements Comparator<AttributeOrNSInfo> {
        private List<String> orderedAttributes;

        public AttributesOrderComparator(List<String> list) {
            this.orderedAttributes = list;
        }

        @Override
        public int compare(AttributeOrNSInfo attributeOrNSInfo, AttributeOrNSInfo attributeOrNSInfo2) {
            int n2 = 0;
            if (attributeOrNSInfo != attributeOrNSInfo2) {
                if (attributeOrNSInfo == null) {
                    n2 = -1;
                } else if (attributeOrNSInfo2 == null) {
                    n2 = 1;
                } else {
                    String string = attributeOrNSInfo.getDisplayName();
                    String string2 = attributeOrNSInfo2.getDisplayName();
                    int n3 = this.orderedAttributes.indexOf(string);
                    int n4 = this.orderedAttributes.indexOf(string2);
                    n2 = n3 < 0 && n4 < 0 ? 0 : (n3 < 0 ? 1 : (n4 < 0 ? -1 : n3 - n4));
                }
            }
            return n2;
        }
    }
}

