/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListenerProxy;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class XsltTransformer
implements Destination {
    private Processor processor;
    private Controller controller;
    private GlobalParameterSet parameters;
    private Source initialSource;
    private Destination destination;
    private Builder sourceTreeBuilder;
    boolean baseOutputUriWasSet = false;

    protected XsltTransformer(Processor processor, Controller controller, GlobalParameterSet globalParameterSet) {
        this.processor = processor;
        this.controller = controller;
        this.parameters = new GlobalParameterSet(globalParameterSet);
    }

    public void setInitialTemplate(QName qName) throws SaxonApiException {
        try {
            this.controller.setInitialTemplate(qName == null ? null : qName.getStructuredQName());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    public QName getInitialTemplate() {
        StructuredQName structuredQName = this.controller.getInitialTemplate();
        return structuredQName == null ? null : new QName(structuredQName);
    }

    public void setInitialMode(QName qName) throws IllegalArgumentException {
        try {
            this.controller.setInitialMode(qName == null ? null : qName.getStructuredQName());
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException);
        }
    }

    public QName getInitialMode() {
        StructuredQName structuredQName = this.controller.getInitialModeName();
        if (structuredQName == null) {
            return null;
        }
        return new QName(structuredQName);
    }

    public void setSchemaValidationMode(ValidationMode validationMode) {
        if (validationMode != null) {
            this.controller.setSchemaValidationMode(validationMode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get((int)this.controller.getSchemaValidationMode());
    }

    public void setSource(Source source) throws SaxonApiException {
        if (source instanceof NodeInfo) {
            this.setInitialContextNode(new XdmNode((NodeInfo)source));
        } else if (source instanceof DOMSource) {
            if (((DOMSource)source).getNode() == null) {
                DocumentImpl documentImpl = new DocumentImpl();
                documentImpl.setConfiguration(this.controller.getConfiguration());
                this.setInitialContextNode(new XdmNode((NodeInfo)documentImpl));
            } else {
                this.setInitialContextNode(this.processor.newDocumentBuilder().wrap((Object)source));
            }
        } else {
            this.initialSource = source;
        }
    }

    public void setInitialContextNode(XdmNode xdmNode) {
        this.initialSource = xdmNode == null ? null : xdmNode.getUnderlyingNode();
    }

    public XdmNode getInitialContextNode() {
        if (this.initialSource instanceof NodeInfo) {
            return (XdmNode)XdmValue.wrap((Sequence)((NodeInfo)this.initialSource));
        }
        return null;
    }

    public void setParameter(QName qName, XdmValue xdmValue) {
        this.parameters.put(qName.getStructuredQName(), xdmValue == null ? null : xdmValue.getUnderlyingValue());
    }

    public void clearParameters() {
        this.parameters = new GlobalParameterSet();
    }

    public XdmValue getParameter(QName qName) {
        Sequence sequence = this.parameters.get(qName.getStructuredQName());
        return sequence == null ? null : XdmValue.wrap((Sequence)sequence);
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
        if (destination instanceof Serializer) {
            Properties properties = this.controller.getExecutable().getDefaultOutputProperties();
            String string = properties.getProperty("{http://saxon.sf.net/}next-in-chain");
            if (string != null && !string.isEmpty()) {
                try {
                    String string2 = properties.getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
                    Source source = this.getURIResolver().resolve(string, string2);
                    XsltTransformer xsltTransformer = this.processor.newXsltCompiler().compile(source).load();
                    xsltTransformer.setBaseOutputURI(this.getBaseOutputURI());
                    xsltTransformer.setDestination(destination);
                    this.setDestination(xsltTransformer);
                }
                catch (Exception exception) {
                    final Exception exception2 = exception;
                    this.setDestination(new Destination(){

                        public Receiver getReceiver(Configuration configuration) throws SaxonApiException {
                            throw new SaxonApiException("Failed to configure next-in-chain stylesheet", (Throwable)exception2);
                        }

                        public void close() throws SaxonApiException {
                        }
                    });
                }
            } else {
                Serializer serializer = (Serializer)destination;
                serializer.setDefaultOutputProperties(properties);
                serializer.setCharacterMap(this.controller.getExecutable().getCharacterMapIndex());
            }
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setBaseOutputURI(String string) {
        this.controller.setBaseOutputURI(string);
        this.baseOutputUriWasSet = string != null;
    }

    public String getBaseOutputURI() {
        return this.controller.getBaseOutputURI();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.controller.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.controller.getURIResolver();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.controller.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        return this.controller.getErrorListener();
    }

    public void setMessageListener(MessageListener messageListener) {
        this.controller.setMessageEmitter((Receiver)new MessageListenerProxy(messageListener, this.controller.makePipelineConfiguration()));
    }

    public MessageListener getMessageListener() {
        Receiver receiver = this.controller.getMessageEmitter();
        if (receiver instanceof MessageListenerProxy) {
            return ((MessageListenerProxy)receiver).getMessageListener();
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.controller.setTraceListener(traceListener);
    }

    public TraceListener getTraceListener() {
        return this.controller.getTraceListener();
    }

    public void setTraceFunctionDestination(Logger logger) {
        this.controller.setTraceFunctionDestination(logger);
    }

    public Logger getTraceFunctionDestination() {
        return this.controller.getTraceFunctionDestination();
    }

    public void transform() throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        if (this.baseOutputUriWasSet && this.destination instanceof XdmDestination && ((XdmDestination)this.destination).getBaseURI() == null && this.controller.getBaseOutputURI() != null) {
            try {
                ((XdmDestination)this.destination).setBaseURI(new URI(this.controller.getBaseOutputURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        try {
            Receiver receiver = this.getDestinationReceiver();
            this.controller.initializeController(this.parameters);
            this.controller.transform(this.initialSource, receiver);
            this.destination.close();
        }
        catch (XPathException xPathException) {
            if (!xPathException.hasBeenReported()) {
                try {
                    this.getErrorListener().error((TransformerException)((Object)xPathException));
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    private Receiver getDestinationReceiver() throws SaxonApiException {
        if (this.destination instanceof Serializer) {
            Serializer serializer = (Serializer)this.destination;
            Object object = serializer.getOutputDestination();
            if (!this.baseOutputUriWasSet && object instanceof File) {
                this.controller.setBaseOutputURI(((File)object).toURI().toString());
            }
            PipelineConfiguration pipelineConfiguration = this.controller.makePipelineConfiguration();
            Receiver receiver = ((Serializer)this.destination).getReceiver(pipelineConfiguration);
            pipelineConfiguration.setLocationProvider((LocationProvider)this.controller.getExecutable().getLocationMap());
            return new ReconfigurableSerializer(receiver, serializer.getOutputProperties(), serializer.getResult());
        }
        Receiver receiver = this.destination.getReceiver(this.controller.getConfiguration());
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        pipelineConfiguration.setController(this.controller);
        pipelineConfiguration.setLocationProvider((LocationProvider)this.controller.getExecutable().getLocationMap());
        return receiver;
    }

    public Receiver getReceiver(Configuration configuration) throws SaxonApiException {
        if (this.destination == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        try {
            this.controller.initializeController(this.parameters);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
        if (this.controller.getInitialMode().isDeclaredStreamable()) {
            try {
                return this.controller.getStreamingReceiver(this.controller.getInitialMode(), this.getDestinationReceiver());
            }
            catch (TransformerException transformerException) {
                throw new SaxonApiException((Throwable)transformerException);
            }
        }
        this.sourceTreeBuilder = this.controller.makeBuilder();
        if (this.sourceTreeBuilder instanceof TinyBuilder) {
            ((TinyBuilder)this.sourceTreeBuilder).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
        }
        Stripper stripper = this.controller.makeStripper((Receiver)this.sourceTreeBuilder);
        if (this.controller.getExecutable().stripsInputTypeAnnotations()) {
            stripper = this.controller.getConfiguration().getAnnotationStripper((Receiver)stripper);
        }
        return stripper;
    }

    public void close() throws SaxonApiException {
        if (this.sourceTreeBuilder != null) {
            NodeInfo nodeInfo = this.sourceTreeBuilder.getCurrentRoot();
            this.sourceTreeBuilder = null;
            if (nodeInfo != null) {
                Receiver receiver = this.getDestinationReceiver();
                try {
                    this.controller.transformDocument(nodeInfo, receiver);
                }
                catch (TransformerException transformerException) {
                    throw new SaxonApiException((Throwable)transformerException);
                }
            }
            this.destination.close();
        }
    }

    public Controller getUnderlyingController() {
        return this.controller;
    }
}

