/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trans.XPathException;

public class Serializer
implements Destination {
    private Processor processor;
    private Map<StructuredQName, String> properties = new HashMap<StructuredQName, String>(10);
    private StreamResult result = new StreamResult();
    private Properties defaultOutputProperties = null;
    private CharacterMapIndex characterMap = null;
    private boolean mustClose = false;
    private static Map<String, Property> standardProperties = new HashMap<String, Property>();

    private static void z(Property property) {
        standardProperties.put(property.name, property);
    }

    @Deprecated
    public Serializer() {
    }

    @Deprecated
    public Serializer(OutputStream outputStream) {
        this.setOutputStream(outputStream);
    }

    @Deprecated
    public Serializer(Writer writer) {
        this.setOutputWriter(writer);
    }

    @Deprecated
    public Serializer(File file) {
        this.setOutputFile(file);
    }

    protected Serializer(Processor processor) {
        this.setProcessor(processor);
    }

    public void setProcessor(Processor processor) {
        if (processor == null) {
            throw new NullPointerException();
        }
        this.processor = processor;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    protected void setCharacterMap(CharacterMapIndex characterMapIndex) {
        this.characterMap = characterMapIndex;
    }

    public void setOutputProperty(Property property, String string) {
        try {
            string = SaxonOutputKeys.checkOutputProperty((String)property.toString(), (String)string, null, (boolean)true);
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
        if (string == null) {
            this.properties.remove(property.getQName().getStructuredQName());
        } else {
            this.properties.put(property.getQName().getStructuredQName(), string);
        }
    }

    public String getOutputProperty(Property property) {
        return this.properties.get(property.getQName().getStructuredQName());
    }

    public void setOutputProperty(QName qName, String string) {
        String string2 = qName.getNamespaceURI();
        if (string2.isEmpty() || string2.equals("http://saxon.sf.net/")) {
            try {
                string = SaxonOutputKeys.checkOutputProperty((String)qName.getClarkName(), (String)string, null, (boolean)true);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException(xPathException.getMessage());
            }
            if (string2.equals("http://saxon.sf.net/") && qName.getLocalName().equals("next-in-chain")) {
                return;
            }
        }
        if (string == null) {
            this.properties.remove(qName.getStructuredQName());
        } else {
            this.properties.put(qName.getStructuredQName(), string);
        }
    }

    public String getOutputProperty(QName qName) {
        return this.properties.get(qName.getStructuredQName());
    }

    public void setOutputWriter(Writer writer) {
        this.result.setOutputStream(null);
        this.result.setSystemId((String)null);
        this.result.setWriter(writer);
        this.mustClose = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.result.setWriter(null);
        this.result.setSystemId((String)null);
        this.result.setOutputStream(outputStream);
        this.mustClose = false;
    }

    public void setOutputFile(File file) {
        this.result.setOutputStream(null);
        this.result.setWriter(null);
        this.result.setSystemId(file);
        this.mustClose = true;
    }

    public void serializeNode(XdmNode xdmNode) throws SaxonApiException {
        StreamResult streamResult = this.result;
        if (streamResult.getOutputStream() == null && streamResult.getWriter() == null && streamResult.getSystemId() == null) {
            throw new IllegalStateException("Either an outputStream, or a Writer, or a File must be supplied");
        }
        this.serializeNodeToResult(xdmNode, streamResult);
    }

    public void serializeXdmValue(XdmValue xdmValue) throws SaxonApiException {
        if (xdmValue instanceof XdmNode) {
            this.serializeNode((XdmNode)xdmValue);
        } else {
            if (this.processor == null) {
                throw new IllegalStateException("The Serializer is not associated with any s9api Processor");
            }
            try {
                QueryResult.serializeSequence((SequenceIterator)xdmValue.getUnderlyingValue().iterate(), (Configuration)this.processor.getUnderlyingConfiguration(), (Result)this.result, (Properties)this.getOutputProperties());
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException((Throwable)xPathException);
            }
        }
    }

    public String serializeNodeToString(XdmNode xdmNode) throws SaxonApiException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        this.serializeNodeToResult(xdmNode, streamResult);
        return stringWriter.toString();
    }

    private void serializeNodeToResult(XdmNode xdmNode, Result result) throws SaxonApiException {
        try {
            QueryResult.serialize((NodeInfo)xdmNode.getUnderlyingNode(), (Result)result, (Properties)this.getOutputProperties());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    public StreamWriterToReceiver getXMLStreamWriter() throws SaxonApiException {
        if (this.processor == null) {
            throw new IllegalStateException("This method is available only if a Processor has been set");
        }
        Receiver receiver = this.getReceiver(this.processor.getUnderlyingConfiguration());
        receiver = new NamespaceReducer(receiver);
        return new StreamWriterToReceiver(receiver);
    }

    public Object getOutputDestination() {
        if (this.result.getOutputStream() != null) {
            return this.result.getOutputStream();
        }
        if (this.result.getWriter() != null) {
            return this.result.getWriter();
        }
        String string = this.result.getSystemId();
        if (string != null) {
            try {
                return new File(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }

    public Receiver getReceiver(Configuration configuration) throws SaxonApiException {
        try {
            SerializerFactory serializerFactory = configuration.getSerializerFactory();
            PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
            Properties properties = this.getOutputProperties();
            Receiver receiver = serializerFactory.getReceiver((Result)this.result, pipelineConfiguration, properties, this.characterMap);
            if (receiver.getSystemId() == null) {
                receiver.setSystemId(this.result.getSystemId());
            }
            return receiver;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    public Receiver getReceiver(PipelineConfiguration pipelineConfiguration) throws SaxonApiException {
        try {
            Configuration configuration = pipelineConfiguration.getConfiguration();
            SerializerFactory serializerFactory = configuration.getSerializerFactory();
            Properties properties = this.getOutputProperties();
            Receiver receiver = serializerFactory.getReceiver((Result)this.result, pipelineConfiguration, properties, this.characterMap);
            if (receiver.getSystemId() == null) {
                receiver.setSystemId(this.result.getSystemId());
            }
            return receiver;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    protected Receiver getReceiver(Executable executable) throws SaxonApiException {
        try {
            Configuration configuration = executable.getConfiguration();
            SerializerFactory serializerFactory = configuration.getSerializerFactory();
            PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
            pipelineConfiguration.setSerializing(true);
            pipelineConfiguration.setHostLanguage(executable.getHostLanguage());
            Properties properties = executable.getDefaultOutputProperties();
            for (Map.Entry<StructuredQName, String> entry : this.properties.entrySet()) {
                StructuredQName structuredQName = entry.getKey();
                ResultDocument.setSerializationProperty(properties, structuredQName.getURI(), structuredQName.getLocalPart(), entry.getValue(), null, true, configuration);
            }
            Receiver receiver = serializerFactory.getReceiver((Result)this.result, pipelineConfiguration, properties, executable.getCharacterMapIndex());
            if (receiver.getSystemId() == null) {
                receiver.setSystemId(this.result.getSystemId());
            }
            return receiver;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    protected Properties getOutputProperties() {
        Properties properties = this.defaultOutputProperties == null ? new Properties() : new Properties(this.defaultOutputProperties);
        for (StructuredQName structuredQName : this.properties.keySet()) {
            String string = this.properties.get(structuredQName);
            properties.setProperty(structuredQName.getClarkName(), string);
        }
        return properties;
    }

    protected Result getResult() {
        return this.result;
    }

    public void close() throws SaxonApiException {
        if (this.mustClose) {
            Writer writer;
            OutputStream outputStream = this.result.getOutputStream();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new SaxonApiException("Failed while closing output file", (Throwable)iOException);
                }
            }
            if ((writer = this.result.getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    throw new SaxonApiException("Failed while closing output file", (Throwable)iOException);
                }
            }
        }
    }

    public static Property getProperty(QName qName) {
        String string = qName.getClarkName();
        Property property = standardProperties.get(string);
        if (property != null) {
            return property;
        }
        throw new IllegalArgumentException("Unknown serialization property " + string);
    }

    static {
        Serializer.z(Property.METHOD);
        Serializer.z(Property.VERSION);
        Serializer.z(Property.ENCODING);
        Serializer.z(Property.OMIT_XML_DECLARATION);
        Serializer.z(Property.STANDALONE);
        Serializer.z(Property.DOCTYPE_PUBLIC);
        Serializer.z(Property.DOCTYPE_SYSTEM);
        Serializer.z(Property.CDATA_SECTION_ELEMENTS);
        Serializer.z(Property.INDENT);
        Serializer.z(Property.MEDIA_TYPE);
        Serializer.z(Property.USE_CHARACTER_MAPS);
        Serializer.z(Property.INCLUDE_CONTENT_TYPE);
        Serializer.z(Property.UNDECLARE_PREFIXES);
        Serializer.z(Property.ESCAPE_URI_ATTRIBUTES);
        Serializer.z(Property.BYTE_ORDER_MARK);
        Serializer.z(Property.NORMALIZATION_FORM);
        Serializer.z(Property.ITEM_SEPARATOR);
        Serializer.z(Property.SAXON_INDENT_SPACES);
        Serializer.z(Property.SAXON_ATTRIBUTE_ORDER);
        Serializer.z(Property.SAXON_CHARACTER_REPRESENTATION);
        Serializer.z(Property.SAXON_DOUBLE_SPACE);
        Serializer.z(Property.SAXON_IMPLICIT_RESULT_DOCUMENT);
        Serializer.z(Property.SAXON_LINE_LENGTH);
        Serializer.z(Property.SAXON_RECOGNIZE_BINARY);
        Serializer.z(Property.SAXON_REQUIRE_WELL_FORMED);
        Serializer.z(Property.SAXON_STYLESHEET_VERSION);
        Serializer.z(Property.SAXON_SUPPLY_SOURCE_LOCATOR);
        Serializer.z(Property.SAXON_SUPPRESS_INDENTATION);
        Serializer.z(Property.SAXON_WRAP);
    }

    public static enum Property {
        METHOD("method"),
        VERSION("version"),
        ENCODING("encoding"),
        OMIT_XML_DECLARATION("omit-xml-declaration"),
        STANDALONE("standalone"),
        DOCTYPE_PUBLIC("doctype-public"),
        DOCTYPE_SYSTEM("doctype-system"),
        CDATA_SECTION_ELEMENTS("cdata-section-elements"),
        INDENT("indent"),
        MEDIA_TYPE("media-type"),
        USE_CHARACTER_MAPS("use-character-maps"),
        INCLUDE_CONTENT_TYPE("include-content-type"),
        UNDECLARE_PREFIXES("undeclare-prefixes"),
        ESCAPE_URI_ATTRIBUTES("escape-uri-attributes"),
        BYTE_ORDER_MARK("byte-order-mark"),
        NORMALIZATION_FORM("normalization-form"),
        ITEM_SEPARATOR("item-separator"),
        HTML_VERSION("html-version"),
        SAXON_INDENT_SPACES("{http://saxon.sf.net/}indent-spaces"),
        SAXON_LINE_LENGTH("{http://saxon.sf.net/}line-length"),
        SAXON_ATTRIBUTE_ORDER("{http://saxon.sf.net/}attribute-order"),
        SAXON_SUPPRESS_INDENTATION("suppress-indentation"),
        SAXON_DOUBLE_SPACE("{http://saxon.sf.net/}double-space"),
        SAXON_STYLESHEET_VERSION("{http://saxon.sf.net/}stylesheet-version"),
        SAXON_CHARACTER_REPRESENTATION("{http://saxon.sf.net/}character-representation"),
        SAXON_RECOGNIZE_BINARY("{http://saxon.sf.net/}recognize-binary"),
        SAXON_REQUIRE_WELL_FORMED("{http://saxon.sf.net/}require-well-formed"),
        SAXON_WRAP("{http://saxon.sf.net/}wrap-result-sequence"),
        SAXON_IMPLICIT_RESULT_DOCUMENT("{http://saxon.sf.net/}implicit-result-document"),
        SAXON_SUPPLY_SOURCE_LOCATOR("{http://saxon.sf.net/}supply-source-locator");

        private String name;

        private Property(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public QName getQName() {
            return QName.fromClarkName((String)this.name);
        }

        public static Property get(String string) {
            for (Property property : Property.values()) {
                if (!property.name.equals(string)) continue;
                return property;
            }
            return null;
        }
    }
}

