/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import javax.xml.namespace.QName;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class StructuredQName
implements IdentityComparable {
    private char[] content;
    private int localNameStart;
    private int prefixStart;

    public StructuredQName(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = string3.length();
        this.localNameStart = n3;
        this.prefixStart = n3 + n4;
        this.content = new char[n3 + n4 + n2];
        string2.getChars(0, n3, this.content, 0);
        string3.getChars(0, n4, this.content, n3);
        string.getChars(0, n2, this.content, n3 + n4);
    }

    public static StructuredQName fromClarkName(String string) {
        String string2;
        String string3;
        if (string.startsWith("Q{")) {
            string = string.substring(1);
        }
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            string3 = string.substring(1, n2);
            if (n2 == string.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            string2 = string.substring(n2 + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return new StructuredQName("", string3, string2);
    }

    public static StructuredQName fromLexicalQName(CharSequence charSequence, boolean bl, boolean bl2, NamespaceResolver namespaceResolver) throws XPathException {
        charSequence = Whitespace.trimWhitespace((CharSequence)charSequence);
        if (bl2 && charSequence.length() >= 4 && charSequence.charAt(0) == 'Q' && charSequence.charAt(1) == '{') {
            String string = ((Object)charSequence).toString();
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new XPathException("Invalid EQName: closing brace not found");
            }
            if (n2 == string.length() - 1) {
                throw new XPathException("Invalid EQName: local part is missing");
            }
            String string2 = string.substring(2, n2);
            String string3 = string.substring(n2 + 1);
            if (!NameChecker.isValidNCName((CharSequence)string3)) {
                throw new XPathException("Invalid EQName: local part is not a valid NCName");
            }
            return new StructuredQName("", string2, string3);
        }
        try {
            String[] stringArray = NameChecker.getQNameParts((CharSequence)charSequence);
            String string = namespaceResolver.getURIForPrefix(stringArray[0], bl);
            if (string == null) {
                XPathException xPathException = new XPathException("Namespace prefix '" + stringArray[0] + "' has not been declared");
                xPathException.setErrorCode("FONS0004");
                throw xPathException;
            }
            return new StructuredQName(stringArray[0], string, stringArray[1]);
        }
        catch (QNameException qNameException) {
            XPathException xPathException = new XPathException(qNameException.getMessage());
            xPathException.setErrorCode("FOCA0002");
            throw xPathException;
        }
    }

    public static StructuredQName fromEQName(CharSequence charSequence) {
        if ((charSequence = Whitespace.trimWhitespace((CharSequence)charSequence)).length() >= 4 && charSequence.charAt(0) == 'Q' && charSequence.charAt(1) == '{') {
            String string = ((Object)charSequence).toString();
            int n2 = string.indexOf(125);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid EQName: closing brace not found");
            }
            if (n2 == string.length() - 1) {
                throw new IllegalArgumentException("Invalid EQName: local part is missing");
            }
            String string2 = string.substring(2, n2);
            String string3 = string.substring(n2 + 1);
            return new StructuredQName("", string2, string3);
        }
        return new StructuredQName("", "", ((Object)charSequence).toString());
    }

    public String getPrefix() {
        return new String(this.content, this.prefixStart, this.content.length - this.prefixStart);
    }

    public String getURI() {
        if (this.localNameStart == 0) {
            return "";
        }
        return new String(this.content, 0, this.localNameStart);
    }

    public boolean hasURI(String string) {
        if (this.localNameStart != string.length()) {
            return false;
        }
        for (int i2 = this.localNameStart - 1; i2 >= 0; --i2) {
            if (this.content[i2] == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public String getLocalPart() {
        return new String(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
    }

    public String getDisplayName() {
        if (this.prefixStart == this.content.length) {
            return this.getLocalPart();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.content.length - this.localNameStart + 1);
        fastStringBuffer.append(this.content, this.prefixStart, this.content.length - this.prefixStart);
        fastStringBuffer.append(':');
        fastStringBuffer.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return fastStringBuffer.toString();
    }

    public StructuredQName getStructuredQName() {
        return this;
    }

    public String getClarkName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.content.length - this.prefixStart + 2);
        if (this.localNameStart > 0) {
            fastStringBuffer.append('{');
            fastStringBuffer.append(this.content, 0, this.localNameStart);
            fastStringBuffer.append('}');
        }
        fastStringBuffer.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return fastStringBuffer.toString();
    }

    public String getEQName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.content.length - this.prefixStart + 2);
        fastStringBuffer.append("Q{");
        if (this.localNameStart > 0) {
            fastStringBuffer.append(this.content, 0, this.localNameStart);
        }
        fastStringBuffer.append('}');
        fastStringBuffer.append(this.content, this.localNameStart, this.prefixStart - this.localNameStart);
        return fastStringBuffer.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StructuredQName) {
            StructuredQName structuredQName = (StructuredQName)object;
            if (this.localNameStart != structuredQName.localNameStart || this.prefixStart != structuredQName.prefixStart) {
                return false;
            }
            for (int i2 = this.prefixStart - 1; i2 >= 0; --i2) {
                if (this.content[i2] == structuredQName.content[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n2 = -2147180533;
        n2 ^= this.prefixStart;
        n2 ^= this.localNameStart;
        for (int i2 = this.prefixStart - 1; i2 >= 0; --i2) {
            n2 ^= this.content[i2] << (i2 & 0x1F);
        }
        return n2;
    }

    public static int computeHashCode(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        int n3 = -2147180533;
        int n4 = charSequence2.length();
        int n5 = charSequence.length();
        int n6 = n4 + n5;
        n3 ^= n6;
        n3 ^= n5;
        for (n2 = 0; n2 < n5; ++n2) {
            n3 ^= charSequence.charAt(n2) << (n2 & 0x1F);
        }
        n2 = 0;
        int n7 = n5;
        while (n2 < n4) {
            n3 ^= charSequence2.charAt(n2) << (n7 & 0x1F);
            ++n2;
            ++n7;
        }
        return n3;
    }

    public boolean isInSameNamespace(NodeName nodeName) {
        if (this == nodeName) {
            return true;
        }
        if (nodeName instanceof StructuredQName) {
            StructuredQName structuredQName = (StructuredQName)nodeName;
            if (this.localNameStart != structuredQName.localNameStart) {
                return false;
            }
            for (int i2 = this.localNameStart - 1; i2 >= 0; --i2) {
                if (this.content[i2] == structuredQName.content[i2]) continue;
                return false;
            }
            return true;
        }
        return this.getURI().equals(nodeName.getURI());
    }

    public QName toJaxpQName() {
        return new QName(this.getURI(), this.getLocalPart(), this.getPrefix());
    }

    public NamespaceBinding getNamespaceBinding() {
        return NamespaceBinding.makeNamespaceBinding((CharSequence)new CharSlice(this.content, this.prefixStart, this.content.length - this.prefixStart), (CharSequence)new CharSlice(this.content, 0, this.localNameStart));
    }

    public boolean hasFingerprint() {
        return false;
    }

    public int getFingerprint() {
        return -1;
    }

    public int getNameCode() {
        return -1;
    }

    public boolean isIdentical(IdentityComparable identityComparable) {
        return this.equals(identityComparable) && ((StructuredQName)identityComparable).getPrefix().equals(this.getPrefix());
    }

    public int identityHashCode() {
        return this.hashCode() ^ this.getPrefix().hashCode();
    }
}

