/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.jaxp.IdentityTransformer;
import net.sf.saxon.jaxp.IdentityTransformerHandler;
import net.sf.saxon.jaxp.TemplatesHandlerImpl;
import net.sf.saxon.jaxp.TemplatesImpl;
import net.sf.saxon.jaxp.TransformerImpl;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLFilter;
import ro.sync.xml.transformer.b.c;

public class SaxonTransformerFactory
extends SAXTransformerFactory {
    private Processor processor;
    private static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public SaxonTransformerFactory() {
        this.processor = new Processor(true);
    }

    public SaxonTransformerFactory(Configuration configuration) {
        this.processor = new Processor(configuration);
    }

    public void setConfiguration(Configuration configuration) {
        try {
            c.b().b(configuration, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.processor.setConfigurationProperty("http://saxon.sf.net/feature/configuration", (Object)configuration);
    }

    public Configuration getConfiguration() {
        return this.processor.getUnderlyingConfiguration();
    }

    @Override
    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    @Override
    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this.processor.getUnderlyingConfiguration());
    }

    @Override
    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        try {
            XsltCompiler xsltCompiler = this.processor.newXsltCompiler();
            XsltExecutable xsltExecutable = xsltCompiler.compile(source);
            return new TemplatesImpl(xsltExecutable);
        }
        catch (SaxonApiException saxonApiException) {
            throw new TransformerConfigurationException(saxonApiException);
        }
    }

    public Templates newTemplates(Source source, CompilerInfo compilerInfo) throws TransformerConfigurationException {
        try {
            XsltCompiler xsltCompiler = this.processor.newXsltCompiler();
            xsltCompiler.getUnderlyingCompilerInfo().copyFrom(compilerInfo);
            return new TemplatesImpl(xsltCompiler.compile(source));
        }
        catch (SaxonApiException saxonApiException) {
            throw new TransformerConfigurationException(saxonApiException);
        }
    }

    @Override
    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        try {
            XsltCompiler xsltCompiler = this.processor.newXsltCompiler();
            return xsltCompiler.getAssociatedStylesheet(source, string, string2, string3);
        }
        catch (SaxonApiException saxonApiException) {
            throw new TransformerConfigurationException(saxonApiException);
        }
    }

    @Override
    public void setURIResolver(URIResolver uRIResolver) {
        this.getConfiguration().setURIResolver(uRIResolver);
    }

    @Override
    public URIResolver getURIResolver() {
        return this.getConfiguration().getURIResolver();
    }

    @Override
    public boolean getFeature(String string) {
        if (string.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (string.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        if (string.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions");
        }
        try {
            Object object = this.getConfiguration().getConfigurationProperty(string);
            return object instanceof Boolean && (Boolean)object != false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (string.equals("http://saxon.sf.net/feature/configuration-file")) {
            ConfigurationReader configurationReader = new ConfigurationReader();
            try {
                this.setConfiguration(configurationReader.makeConfiguration((Source)new StreamSource(new File((String)object))));
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException(xPathException);
            }
        } else {
            this.processor.setConfigurationProperty(string, object);
        }
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        return this.getConfiguration().getConfigurationProperty(string);
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.getConfiguration().setErrorListener(errorListener);
    }

    @Override
    public ErrorListener getErrorListener() {
        return this.getConfiguration().getErrorListener();
    }

    @Override
    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newTransformerHandler(templates);
    }

    @Override
    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
        return transformerImpl.newTransformerHandler();
    }

    @Override
    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer identityTransformer = new IdentityTransformer(this.getConfiguration());
        return new IdentityTransformerHandler(identityTransformer);
    }

    @Override
    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this.processor);
    }

    @Override
    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    @Override
    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof TemplatesImpl)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        TransformerImpl transformerImpl = (TransformerImpl)templates.newTransformer();
        return transformerImpl.newXMLFilter();
    }

    @Override
    public void setFeature(String string, boolean bl) throws TransformerConfigurationException {
        if (string.equals(FEATURE_SECURE_PROCESSING)) {
            this.getConfiguration().setBooleanProperty("http://saxon.sf.net/feature/allow-external-functions", !bl);
        } else {
            try {
                this.getConfiguration().setBooleanProperty(string, bl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TransformerConfigurationException("Unsupported TransformerFactory feature: " + string);
            }
        }
    }
}

