/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.functions.Abs;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.Adjust;
import net.sf.saxon.functions.AnalyzeStringFn;
import net.sf.saxon.functions.AvailableEnvironmentVariables;
import net.sf.saxon.functions.Average;
import net.sf.saxon.functions.BaseURI;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.Ceiling;
import net.sf.saxon.functions.CodepointEqual;
import net.sf.saxon.functions.CodepointsToString;
import net.sf.saxon.functions.Collection;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentDateTime;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.CurrentGroupingKey;
import net.sf.saxon.functions.Data;
import net.sf.saxon.functions.DateTimeConstructor;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.DefaultCollation;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocAvailable;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.DocumentUriFn;
import net.sf.saxon.functions.ElementAvailable;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.EndsWith;
import net.sf.saxon.functions.EnvironmentVariable;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.False;
import net.sf.saxon.functions.Floor;
import net.sf.saxon.functions.FormatDate;
import net.sf.saxon.functions.FormatInteger;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.functions.FunctionAvailable;
import net.sf.saxon.functions.GenerateId;
import net.sf.saxon.functions.HasChildren;
import net.sf.saxon.functions.HeadFn;
import net.sf.saxon.functions.Id;
import net.sf.saxon.functions.Idref;
import net.sf.saxon.functions.InScopePrefixes;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.Innermost;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.Lang;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.LocalNameFn;
import net.sf.saxon.functions.LowerCase;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.Max;
import net.sf.saxon.functions.Min;
import net.sf.saxon.functions.NameFn;
import net.sf.saxon.functions.NamespaceForPrefix;
import net.sf.saxon.functions.NamespaceUriFn;
import net.sf.saxon.functions.Nilled;
import net.sf.saxon.functions.NodeNameFn;
import net.sf.saxon.functions.NormalizeSpace_0;
import net.sf.saxon.functions.NormalizeSpace_1;
import net.sf.saxon.functions.NormalizeUnicode;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.Outermost;
import net.sf.saxon.functions.ParseXml;
import net.sf.saxon.functions.ParseXmlFragment;
import net.sf.saxon.functions.Path;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.Put;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root;
import net.sf.saxon.functions.Round;
import net.sf.saxon.functions.RoundHalfToEven;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.StartsWith;
import net.sf.saxon.functions.StaticBaseURI;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.StringToCodepoints;
import net.sf.saxon.functions.Subsequence;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.functions.SubstringAfter;
import net.sf.saxon.functions.SubstringBefore;
import net.sf.saxon.functions.Sum;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.TailFn;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.True;
import net.sf.saxon.functions.TypeAvailable;
import net.sf.saxon.functions.Unordered;
import net.sf.saxon.functions.UnparsedEntity;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.functions.UnparsedTextAvailable;
import net.sf.saxon.functions.UnparsedTextLines;
import net.sf.saxon.functions.UpperCase;
import net.sf.saxon.functions.UriCollection;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public abstract class StandardFunction {
    public static Sequence EMPTY = EmptySequence.getInstance();
    public static final int CORE = 1;
    public static final int XSLT = 2;
    public static final int USE_WHEN = 4;
    public static final int XQUPDATE = 8;
    public static final int XPATH30 = 16;
    public static final int INTERNAL = 32;
    public static final int XSLT30 = 64;
    public static final int ONE = 16384;
    public static final int OPT = 24576;
    public static final int STAR = 57344;
    public static final int PLUS = 49152;
    public static final int INS = 0x1000000;
    public static final int ABS = 0x2000000;
    public static final int TRA = 0x4000000;
    public static final int NAV = 0x8000000;
    private static HashMap<String, Entry> functionTable = new HashMap(200);
    public static final int AS_ARG0 = 1;
    public static final int AS_PRIM_ARG0 = 2;
    public static final int FOCUS = 4;
    public static final int BASE = 8;
    public static final int NS = 16;
    public static final int DCOLL = 32;
    public static final int IMP_CX_I = 64;
    public static final int IMP_CX_D = 128;
    public static final int DEPENDS_ON_STATIC_CONTEXT = 56;

    private StandardFunction() {
    }

    public static Entry register(String string, Class clazz, int n2, int n3, int n4, ItemType itemType, int n5, int n6, int n7) {
        Entry entry = StandardFunction.makeEntry(string, clazz, n2, n3, n4, itemType, n5, n6, n7);
        functionTable.put(string, entry);
        return entry;
    }

    public static Entry makeEntry(String string, Class clazz, int n2, int n3, int n4, ItemType itemType, int n5, int n6, int n7) {
        Entry entry = new Entry();
        int n8 = string.indexOf(35);
        entry.name = n8 < 0 ? string : string.substring(0, n8);
        entry.implementationClass = clazz;
        entry.opcode = n2;
        entry.minArguments = n3;
        entry.maxArguments = n4;
        entry.itemType = itemType;
        entry.cardinality = n5;
        entry.applicability = n6;
        entry.properties = n7;
        if (n4 > 100) {
            entry.argumentTypes = new SequenceType[1];
            entry.resultIfEmpty = new AtomicValue[1];
            entry.usage = new OperandUsage[1];
        } else {
            entry.argumentTypes = new SequenceType[n4];
            entry.resultIfEmpty = new Sequence[n4];
            entry.usage = new OperandUsage[n4];
        }
        return entry;
    }

    public static Entry getFunction(String string, int n2) {
        if (n2 == -1) {
            for (int i2 = 0; i2 < 10; ++i2) {
                Entry entry = StandardFunction.getFunction(string, i2);
                if (entry == null) continue;
                return entry;
            }
            return null;
        }
        Entry entry = functionTable.get(string + '#' + n2);
        if (entry != null) {
            return entry;
        }
        entry = functionTable.get(string);
        if (entry != null && entry.minArguments <= n2 && entry.maxArguments >= n2) {
            return entry;
        }
        return null;
    }

    static {
        try {
            StandardFunction.register("abs", Abs.class, 0, 1, 1, (ItemType)BuiltInAtomicType.NUMERIC, 24576, 1, 2).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, EMPTY);
            StandardFunction.register("adjust-date-to-timezone", Adjust.class, 0, 1, 2, (ItemType)BuiltInAtomicType.DATE, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
            StandardFunction.register("adjust-dateTime-to-timezone", Adjust.class, 0, 1, 2, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
            StandardFunction.register("adjust-time-to-timezone", Adjust.class, 0, 1, 2, (ItemType)BuiltInAtomicType.TIME, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.TIME, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
            StandardFunction.register("analyze-string", AnalyzeStringFn.class, 0, 2, 3, (ItemType)NodeKindTest.ELEMENT, 16384, 16, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("available-environment-variables", AvailableEnvironmentVariables.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 57344, 20, 0);
            StandardFunction.register("avg", Average.class, 0, 1, 1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
            StandardFunction.register("base-uri", BaseURI.class, 0, 0, 1, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 72).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
            StandardFunction.register("boolean", BooleanFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, null);
            StandardFunction.register("ceiling", Ceiling.class, 0, 1, 1, (ItemType)BuiltInAtomicType.NUMERIC, 24576, 1, 2).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, EMPTY);
            StandardFunction.register("codepoint-equal", CodepointEqual.class, 0, 2, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY);
            StandardFunction.register("codepoints-to-string", CodepointsToString.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.INTEGER, 57344, null);
            StandardFunction.register("collection", Collection.class, 0, 0, 1, Type.NODE_TYPE, 57344, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("compare#2", Compare.class, 0, 2, 2, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 32).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY);
            StandardFunction.register("compare#3", Compare.class, 0, 3, 3, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("concat", Concat.class, 0, 2, Integer.MAX_VALUE, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, null);
            StandardFunction.register("contains#2", Contains.class, 0, 2, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.TRUE);
            StandardFunction.register("contains#3", Contains.class, 0, 3, 3, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.TRUE).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("count", Count.class, 0, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, (Sequence)Int64Value.ZERO);
            StandardFunction.register("current", Current.class, 0, 0, 0, Type.ITEM_TYPE, 16384, 2, 0);
            StandardFunction.register("current-date", CurrentDateTime.class, 0, 0, 0, (ItemType)BuiltInAtomicType.DATE, 16384, 1, 0);
            StandardFunction.register("current-dateTime", CurrentDateTime.class, 0, 0, 0, (ItemType)BuiltInAtomicType.DATE_TIME, 16384, 1, 0);
            StandardFunction.register("current-time", CurrentDateTime.class, 0, 0, 0, (ItemType)BuiltInAtomicType.TIME, 16384, 1, 0);
            StandardFunction.register("current-group", CurrentGroup.class, 0, 0, 0, Type.ITEM_TYPE, 57344, 2, 0);
            StandardFunction.register("current-grouping-key", CurrentGroupingKey.class, 0, 0, 0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, 2, 0);
            StandardFunction.register("data#0", Data.class, 0, 0, 0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, 16, 4);
            StandardFunction.register("data#1", Data.class, 0, 1, 1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, 1, 0).arg(0, Type.ITEM_TYPE, 0x200E000, EMPTY);
            StandardFunction.register("dateTime", DateTimeConstructor.class, 0, 2, 2, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.TIME, 24576, EMPTY);
            StandardFunction.register("day-from-date", AccessorFn.class, 197129, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, EMPTY);
            StandardFunction.register("day-from-dateTime", AccessorFn.class, 197127, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("days-from-duration", AccessorFn.class, 197126, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DURATION, 24576, EMPTY);
            StandardFunction.register("deep-equal#2", DeepEqual.class, 0, 2, 3, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, Type.ITEM_TYPE, 0x200E000, null).arg(1, Type.ITEM_TYPE, 0x200E000, null);
            StandardFunction.register("deep-equal#3", DeepEqual.class, 0, 2, 3, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, Type.ITEM_TYPE, 57344, null).arg(1, Type.ITEM_TYPE, 57344, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("default-collation", DefaultCollation.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 32);
            StandardFunction.register("distinct-values#1", DistinctValues.class, 0, 1, 2, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, 1, 32).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
            StandardFunction.register("distinct-values#2", DistinctValues.class, 0, 1, 2, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, 1, 8).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("doc", Doc.class, 0, 1, 1, (ItemType)NodeKindTest.DOCUMENT, 24576, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY);
            StandardFunction.register("doc-available", DocAvailable.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.FALSE);
            StandardFunction.register("document", DocumentFn.class, 0, 1, 2, Type.NODE_TYPE, 57344, 2, 8).arg(0, Type.ITEM_TYPE, 57344, null).arg(1, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("document-uri#0", DocumentUriFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 16, 68);
            StandardFunction.register("document-uri#1", DocumentUriFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
            StandardFunction.register("empty", Empty.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, (Sequence)BooleanValue.TRUE);
            StandardFunction.register("ends-with#2", EndsWith.class, 0, 2, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.TRUE);
            StandardFunction.register("ends-with#3", EndsWith.class, 0, 3, 3, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.TRUE).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("environment-variable", EnvironmentVariable.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 24576, 20, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("element-available", ElementAvailable.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 6, 16).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("element-with-id#1", Id.class, 1, 1, 1, (ItemType)NodeKindTest.ELEMENT, 57344, 1, 132).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, EMPTY);
            StandardFunction.register("element-with-id#2", Id.class, 1, 2, 2, (ItemType)NodeKindTest.ELEMENT, 57344, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, EMPTY).arg(1, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("encode-for-uri", EscapeURI.class, 1, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("escape-html-uri", EscapeURI.class, 3, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("error", Error.class, 0, 0, 3, Type.ITEM_TYPE, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.QNAME, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, Type.ITEM_TYPE, 57344, null);
            StandardFunction.register("exactly-one", TreatFn.class, 16384, 1, 1, Type.ITEM_TYPE, 16384, 1, 1).arg(0, Type.ITEM_TYPE, 0x4004000, null);
            StandardFunction.register("false", False.class, 0, 0, 0, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0);
            StandardFunction.register("exists", Exists.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, (Sequence)BooleanValue.FALSE);
            StandardFunction.register("floor", Floor.class, 0, 1, 1, (ItemType)BuiltInAtomicType.NUMERIC, 24576, 1, 2).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, EMPTY);
            StandardFunction.register("format-date", FormatDate.class, 521, 2, 5, (ItemType)BuiltInAtomicType.STRING, 24576, 18, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(3, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(4, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("format-dateTime", FormatDate.class, 519, 2, 5, (ItemType)BuiltInAtomicType.STRING, 24576, 18, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(3, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(4, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("format-integer", FormatInteger.class, 0, 2, 3, (ItemType)AnyItemType.getInstance(), 16384, 16, 0).arg(0, (ItemType)BuiltInAtomicType.INTEGER, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("format-number#2", FormatNumber.class, 0, 2, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 18, 0).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("format-number#3", FormatNumber.class, 0, 3, 3, (ItemType)BuiltInAtomicType.STRING, 16384, 18, 16).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("format-time", FormatDate.class, 520, 2, 5, (ItemType)BuiltInAtomicType.STRING, 24576, 18, 0).arg(0, (ItemType)BuiltInAtomicType.TIME, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(3, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(4, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("function-available", FunctionAvailable.class, 0, 1, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 6, 16).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(1, (ItemType)BuiltInAtomicType.INTEGER, 16384, null);
            StandardFunction.register("generate-id#0", GenerateId.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 16384, 18, 68);
            StandardFunction.register("generate-id#1", GenerateId.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 18, 0).arg(0, Type.NODE_TYPE, 0x1006000, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("has-children#0", HasChildren.class, 0, 0, 0, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 16, 64);
            StandardFunction.register("has-children#1", HasChildren.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 24576, 16, 0).arg(0, (ItemType)AnyNodeTest.getInstance(), 0x2006000, null);
            StandardFunction.register("head", HeadFn.class, 0, 1, 1, (ItemType)AnyItemType.getInstance(), 24576, 16, 0).arg(0, (ItemType)AnyItemType.getInstance(), 0x400E000, null);
            StandardFunction.register("hours-from-dateTime", AccessorFn.class, 262663, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("hours-from-duration", AccessorFn.class, 262662, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DURATION, 24576, EMPTY);
            StandardFunction.register("hours-from-time", AccessorFn.class, 262664, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.TIME, 24576, EMPTY);
            StandardFunction.register("id#1", Id.class, 0, 1, 1, (ItemType)NodeKindTest.ELEMENT, 57344, 1, 132).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, EMPTY);
            StandardFunction.register("id#2", Id.class, 0, 2, 2, (ItemType)NodeKindTest.ELEMENT, 57344, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, EMPTY).arg(1, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("idref#1", Idref.class, 0, 1, 1, Type.NODE_TYPE, 57344, 1, 132).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, EMPTY);
            StandardFunction.register("idref#2", Idref.class, 0, 2, 2, Type.NODE_TYPE, 57344, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, EMPTY).arg(1, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("implicit-timezone", CurrentDateTime.class, 0, 0, 0, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 16384, 1, 0);
            StandardFunction.register("in-scope-prefixes", InScopePrefixes.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 57344, 1, 0).arg(0, (ItemType)NodeKindTest.ELEMENT, 0x1004000, null);
            StandardFunction.register("index-of#2", IndexOf.class, 0, 2, 2, (ItemType)BuiltInAtomicType.INTEGER, 57344, 1, 32).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 16384, null);
            StandardFunction.register("index-of#3", IndexOf.class, 0, 3, 3, (ItemType)BuiltInAtomicType.INTEGER, 57344, 1, 8).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("innermost", Innermost.class, 0, 1, 1, (ItemType)AnyNodeTest.getInstance(), 57344, 16, 0).arg(0, (ItemType)AnyNodeTest.getInstance(), 0x800E000, null);
            StandardFunction.register("insert-before", InsertBefore.class, 0, 3, 3, Type.ITEM_TYPE, 57344, 1, 0).arg(0, Type.ITEM_TYPE, 0x400E000, null).arg(1, (ItemType)BuiltInAtomicType.INTEGER, 16384, null).arg(2, Type.ITEM_TYPE, 0x400E000, null);
            StandardFunction.register("iri-to-uri", EscapeURI.class, 2, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("key#2", KeyFn.class, 0, 2, 2, Type.NODE_TYPE, 57344, 2, 148).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
            StandardFunction.register("key#3", KeyFn.class, 0, 3, 3, Type.NODE_TYPE, 57344, 2, 16).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(2, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("lang#1", Lang.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 4).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("lang#2", Lang.class, 0, 2, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, Type.NODE_TYPE, 0x1004000, null);
            StandardFunction.register("last", Last.class, 0, 0, 0, (ItemType)BuiltInAtomicType.INTEGER, 16384, 1, 4);
            StandardFunction.register("local-name#0", LocalNameFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 68);
            StandardFunction.register("local-name#1", LocalNameFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("local-name-from-QName", AccessorFn.class, 524818, 1, 1, (ItemType)BuiltInAtomicType.NCNAME, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.QNAME, 24576, EMPTY);
            StandardFunction.register("lower-case", LowerCase.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("matches", Matches.class, 0, 2, 3, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("max#1", Max.class, 3, 1, 1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 32).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
            StandardFunction.register("max#2", Max.class, 3, 2, 2, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 8).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("min#1", Min.class, 2, 1, 1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 32).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
            StandardFunction.register("min#2", Min.class, 2, 2, 2, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 8).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("minutes-from-dateTime", AccessorFn.class, 328199, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("minutes-from-duration", AccessorFn.class, 328198, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DURATION, 24576, EMPTY);
            StandardFunction.register("minutes-from-time", AccessorFn.class, 328200, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.TIME, 24576, EMPTY);
            StandardFunction.register("month-from-date", AccessorFn.class, 131593, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, EMPTY);
            StandardFunction.register("month-from-dateTime", AccessorFn.class, 131591, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("months-from-duration", AccessorFn.class, 131590, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DURATION, 24576, EMPTY);
            StandardFunction.register("name#0", NameFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 68);
            StandardFunction.register("name#1", NameFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("namespace-uri#0", NamespaceUriFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.ANY_URI, 16384, 1, 68);
            StandardFunction.register("namespace-uri#1", NamespaceUriFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.ANY_URI, 16384, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("namespace-uri-for-prefix", NamespaceForPrefix.class, 0, 2, 2, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)NodeKindTest.ELEMENT, 0x1004000, null);
            StandardFunction.register("namespace-uri-from-QName", AccessorFn.class, 590354, 1, 1, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.QNAME, 24576, EMPTY);
            StandardFunction.register("nilled#0", Nilled.class, 0, 0, 0, (ItemType)BuiltInAtomicType.BOOLEAN, 24576, 16, 68);
            StandardFunction.register("nilled#1", Nilled.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
            StandardFunction.register("node-name#0", NodeNameFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.QNAME, 24576, 16, 68);
            StandardFunction.register("node-name#1", NodeNameFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.QNAME, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
            StandardFunction.register("not", NotFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, (Sequence)BooleanValue.TRUE);
            StandardFunction.register("normalize-space#0", NormalizeSpace_0.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 4);
            StandardFunction.register("normalize-space#1", NormalizeSpace_1.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("normalize-unicode", NormalizeUnicode.class, 0, 1, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("number#0", NumberFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.DOUBLE, 16384, 1, 68);
            StandardFunction.register("number#1", NumberFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.DOUBLE, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, (Sequence)DoubleValue.NaN);
            StandardFunction.register("one-or-more", TreatFn.class, 49152, 1, 1, Type.ITEM_TYPE, 49152, 1, 1).arg(0, Type.ITEM_TYPE, 0x400C000, null);
            StandardFunction.register("outermost", Outermost.class, 0, 1, 1, (ItemType)AnyNodeTest.getInstance(), 57344, 16, 0).arg(0, (ItemType)AnyNodeTest.getInstance(), 0x400E000, null);
            StandardFunction.register("parse-xml", ParseXml.class, 0, 1, 1, (ItemType)NodeKindTest.DOCUMENT, 16384, 16, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("parse-xml-fragment", ParseXmlFragment.class, 0, 1, 1, (ItemType)NodeKindTest.DOCUMENT, 16384, 16, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("path", Path.class, 0, 0, 1, (ItemType)BuiltInAtomicType.STRING, 24576, 16, 64).arg(0, (ItemType)AnyNodeTest.getInstance(), 0x1006000, null);
            StandardFunction.register("position", Position.class, 0, 0, 0, (ItemType)BuiltInAtomicType.INTEGER, 16384, 1, 4);
            StandardFunction.register("prefix-from-QName", AccessorFn.class, 655890, 1, 1, (ItemType)BuiltInAtomicType.NCNAME, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.QNAME, 24576, EMPTY);
            StandardFunction.register("put", Put.class, 0, 2, 2, (ItemType)AnyItemType.getInstance(), 24576, 8, 0).arg(0, Type.NODE_TYPE, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("QName", QNameFn.class, 0, 2, 2, (ItemType)BuiltInAtomicType.QNAME, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("regex-group", RegexGroup.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 2, 0).arg(0, (ItemType)BuiltInAtomicType.INTEGER, 16384, null);
            StandardFunction.register("remove", Remove.class, 0, 2, 2, Type.ITEM_TYPE, 57344, 1, 1).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY).arg(1, (ItemType)BuiltInAtomicType.INTEGER, 16384, null);
            StandardFunction.register("replace", Replace.class, 0, 3, 4, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(3, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("resolve-QName", ResolveQName.class, 0, 2, 2, (ItemType)BuiltInAtomicType.QNAME, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, (ItemType)NodeKindTest.ELEMENT, 0x1004000, null);
            StandardFunction.register("resolve-uri#1", ResolveURI.class, 0, 1, 1, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("resolve-uri#2", ResolveURI.class, 0, 2, 2, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("reverse", Reverse.class, 0, 1, 1, Type.ITEM_TYPE, 57344, 1, 0).arg(0, Type.ITEM_TYPE, 0x800E000, EMPTY);
            StandardFunction.register("root#0", Root.class, 0, 0, 0, Type.NODE_TYPE, 24576, 1, 68);
            StandardFunction.register("root#1", Root.class, 0, 1, 1, Type.NODE_TYPE, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x8006000, EMPTY);
            StandardFunction.register("round#1", Round.class, 0, 1, 1, (ItemType)BuiltInAtomicType.NUMERIC, 24576, 1, 2).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, EMPTY);
            StandardFunction.register("round#2", Round.class, 0, 2, 2, (ItemType)BuiltInAtomicType.NUMERIC, 24576, 16, 2).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.INTEGER, 16384, null);
            StandardFunction.register("round-half-to-even", RoundHalfToEven.class, 0, 1, 2, (ItemType)BuiltInAtomicType.NUMERIC, 24576, 1, 2).arg(0, (ItemType)BuiltInAtomicType.NUMERIC, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.INTEGER, 16384, null);
            StandardFunction.register("seconds-from-dateTime", AccessorFn.class, 393735, 1, 1, (ItemType)BuiltInAtomicType.DECIMAL, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("seconds-from-duration", AccessorFn.class, 393734, 1, 1, (ItemType)BuiltInAtomicType.DECIMAL, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DURATION, 24576, EMPTY);
            StandardFunction.register("seconds-from-time", AccessorFn.class, 393736, 1, 1, (ItemType)BuiltInAtomicType.DECIMAL, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.TIME, 24576, EMPTY);
            StandardFunction.register("serialize", Serialize.class, 0, 1, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 16, 0).arg(0, (ItemType)AnyItemType.getInstance(), 57344, null).arg(1, (ItemType)NodeKindTest.ELEMENT, 57344, null);
            StandardFunction.register("starts-with#2", StartsWith.class, 0, 2, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.TRUE);
            StandardFunction.register("starts-with#3", StartsWith.class, 0, 3, 3, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)BooleanValue.TRUE).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("static-base-uri", StaticBaseURI.class, 0, 0, 0, (ItemType)BuiltInAtomicType.ANY_URI, 24576, 1, 8);
            StandardFunction.register("string#0", StringFn.class, 0, 0, 0, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 68);
            StandardFunction.register("string#1", StringFn.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x2006000, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("string-length#0", StringLength.class, 0, 0, 0, (ItemType)BuiltInAtomicType.INTEGER, 16384, 1, 4);
            StandardFunction.register("string-length#1", StringLength.class, 0, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("string-join#1", StringJoin.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 16, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("string-join#2", StringJoin.class, 0, 2, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 57344, (Sequence)StringValue.EMPTY_STRING).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("string-to-codepoints", StringToCodepoints.class, 0, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 57344, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY);
            StandardFunction.register("subsequence", Subsequence.class, 0, 2, 3, Type.ITEM_TYPE, 57344, 1, 1).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY).arg(1, (ItemType)BuiltInAtomicType.NUMERIC, 16384, null).arg(2, (ItemType)BuiltInAtomicType.NUMERIC, 16384, null);
            StandardFunction.register("substring", Substring.class, 0, 2, 3, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING).arg(1, (ItemType)BuiltInAtomicType.NUMERIC, 16384, null).arg(2, (ItemType)BuiltInAtomicType.NUMERIC, 16384, null);
            StandardFunction.register("substring-after#2", SubstringAfter.class, 0, 2, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 32).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("substring-after#3", SubstringAfter.class, 0, 3, 3, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("substring-before#2", SubstringBefore.class, 0, 2, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 32).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("substring-before#3", SubstringBefore.class, 0, 3, 3, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("sum", Sum.class, 0, 1, 2, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 57344, null).arg(1, (ItemType)BuiltInAtomicType.ANY_ATOMIC, 24576, null);
            StandardFunction.register("system-property", SystemProperty.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 6, 16).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("tail", TailFn.class, 0, 1, 1, (ItemType)AnyItemType.getInstance(), 57344, 16, 0).arg(0, (ItemType)AnyItemType.getInstance(), 0x400E000, null);
            StandardFunction.register("timezone-from-date", AccessorFn.class, 459273, 1, 1, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, EMPTY);
            StandardFunction.register("timezone-from-dateTime", AccessorFn.class, 459271, 1, 1, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("timezone-from-time", AccessorFn.class, 459272, 1, 1, (ItemType)BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.TIME, 24576, EMPTY);
            StandardFunction.register("trace", Trace.class, 0, 2, 2, Type.ITEM_TYPE, 57344, 1, 1).arg(0, Type.ITEM_TYPE, 0x400E000, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("translate", Translate.class, 0, 3, 3, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("true", True.class, 0, 0, 0, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 1, 0);
            StandardFunction.register("tokenize", Tokenize.class, 0, 2, 3, (ItemType)BuiltInAtomicType.STRING, 57344, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(2, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("type-available", TypeAvailable.class, 0, 1, 1, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 6, 16).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("unordered", Unordered.class, 0, 1, 1, Type.ITEM_TYPE, 57344, 1, 1).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY);
            StandardFunction.register("upper-case", UpperCase.class, 0, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, (Sequence)StringValue.EMPTY_STRING);
            StandardFunction.register("unparsed-entity-uri#1", UnparsedEntity.class, UnparsedEntity.URI, 1, 1, (ItemType)BuiltInAtomicType.ANY_URI, 16384, 2, 132).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("unparsed-entity-uri#2", UnparsedEntity.class, UnparsedEntity.URI, 2, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 2, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(1, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("unparsed-entity-public-id#1", UnparsedEntity.class, UnparsedEntity.PUBLIC_ID, 1, 1, (ItemType)BuiltInAtomicType.STRING, 16384, 2, 132).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("unparsed-entity-public-id#2", UnparsedEntity.class, UnparsedEntity.PUBLIC_ID, 2, 2, (ItemType)BuiltInAtomicType.STRING, 16384, 2, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(1, Type.NODE_TYPE, 16384, null);
            StandardFunction.register("unparsed-text", UnparsedText.class, 0, 1, 2, (ItemType)BuiltInAtomicType.STRING, 24576, 18, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("unparsed-text-available", UnparsedTextAvailable.class, 0, 1, 2, (ItemType)BuiltInAtomicType.BOOLEAN, 16384, 18, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 16384, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("unparsed-text-lines", UnparsedTextLines.class, 0, 1, 2, (ItemType)BuiltInAtomicType.STRING, 57344, 16, 8).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null).arg(1, (ItemType)BuiltInAtomicType.STRING, 16384, null);
            StandardFunction.register("uri-collection", UriCollection.class, 0, 0, 1, (ItemType)BuiltInAtomicType.ANY_URI, 57344, 16, 0).arg(0, (ItemType)BuiltInAtomicType.STRING, 24576, null);
            StandardFunction.register("year-from-date", AccessorFn.class, 66057, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE, 24576, EMPTY);
            StandardFunction.register("year-from-dateTime", AccessorFn.class, 66055, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
            StandardFunction.register("years-from-duration", AccessorFn.class, 66054, 1, 1, (ItemType)BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, (ItemType)BuiltInAtomicType.DURATION, 24576, EMPTY);
            StandardFunction.register("zero-or-one", TreatFn.class, 24576, 1, 1, Type.ITEM_TYPE, 24576, 1, 1).arg(0, Type.ITEM_TYPE, 0x4006000, null);
        }
        catch (Throwable throwable) {
            System.err.println("STANDARD FUNCTION BROKEN..............................");
            throwable.printStackTrace();
        }
    }

    public static class Entry
    implements Serializable {
        public String name;
        public Class implementationClass;
        public int opcode;
        public int minArguments;
        public int maxArguments;
        public ItemType itemType;
        public int cardinality;
        public int applicability;
        public OperandUsage[] usage;
        public SequenceType[] argumentTypes;
        public Sequence[] resultIfEmpty;
        public int properties;

        public Entry arg(int n2, ItemType itemType, int n3, Sequence sequence) {
            int n4 = n3 & 0xE000;
            OperandUsage operandUsage = OperandUsage.NAVIGATION;
            if ((n3 & 0x2000000) != 0) {
                operandUsage = OperandUsage.ABSORPTION;
            } else if ((n3 & 0x4000000) != 0) {
                operandUsage = OperandUsage.TRANSMISSION;
            } else if ((n3 & 0x1000000) != 0) {
                operandUsage = OperandUsage.INSPECTION;
            } else if (itemType instanceof AtomicType) {
                operandUsage = OperandUsage.ABSORPTION;
            }
            try {
                this.argumentTypes[n2] = SequenceType.makeSequenceType((ItemType)itemType, (int)n4);
                this.resultIfEmpty[n2] = sequence;
                this.usage[n2] = operandUsage;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("Internal Saxon error: Can't set argument " + n2 + " of " + this.name);
            }
            return this;
        }
    }
}

