/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.TraceExpressionCompiler;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class TraceExpression
extends Instruction
implements InstructionInfo {
    private StructuredQName objectName;
    private int constructType;
    private NamespaceResolver namespaceResolver = null;
    private HashMap<String, Object> properties = new HashMap(10);
    Expression child;

    public TraceExpression(Expression expression) {
        this.child = expression;
        this.adoptChildExpression(expression);
        this.setProperty("expression", expression);
    }

    public void setConstructType(int n2) {
        this.constructType = n2;
    }

    @Override
    public int getConstructType() {
        return this.constructType;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setObjectName(StructuredQName structuredQName) {
        this.objectName = structuredQName;
    }

    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Iterator<String> getProperties() {
        return this.properties.keySet().iterator();
    }

    public InstructionInfo getInstructionInfo() {
        return this;
    }

    public Expression copy() {
        TraceExpression traceExpression = new TraceExpression(this.child.copy());
        traceExpression.objectName = this.objectName;
        traceExpression.namespaceResolver = this.namespaceResolver;
        traceExpression.constructType = this.constructType;
        return traceExpression;
    }

    public boolean isUpdatingExpression() {
        return this.child.isUpdatingExpression();
    }

    public boolean isVacuousExpression() {
        return this.child.isVacuousExpression();
    }

    public void checkForUpdatingSubexpressions() throws XPathException {
        this.child.checkForUpdatingSubexpressions();
    }

    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) throws XPathException {
        this.child = expressionVisitor.typeCheck(this.child, contextItemStaticInfo);
        this.adoptChildExpression(this.child);
        return this;
    }

    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) throws XPathException {
        this.child = expressionVisitor.optimize(this.child, contextItemStaticInfo);
        this.adoptChildExpression(this.child);
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return this.child.getImplementationMethod();
    }

    @Override
    public Expression promote(PromotionOffer promotionOffer, Expression expression) throws XPathException {
        Expression expression2 = this.child.promote(promotionOffer, expression);
        if (expression2 != this.child) {
            this.child = expression2;
            this.adoptChildExpression(this.child);
            return this;
        }
        return this;
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        TraceListener traceListener = controller.getTraceListener();
        if (controller.isTracing()) {
            assert (traceListener != null);
            traceListener.enter(this.getInstructionInfo(), xPathContext);
        }
        this.child.process(xPathContext);
        if (controller.isTracing()) {
            assert (traceListener != null);
            traceListener.leave(this.getInstructionInfo());
        }
        return null;
    }

    @Override
    public ItemType getItemType() {
        return this.child.getItemType();
    }

    public int getCardinality() {
        return this.child.getCardinality();
    }

    public int getDependencies() {
        return this.child.getDependencies();
    }

    @Override
    public final boolean createsNewNodes() {
        return (this.child.getSpecialProperties() & 0x400000) == 0;
    }

    public int computeDependencies() {
        return this.child.computeDependencies();
    }

    @Override
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        Item item = this.child.evaluateItem(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return item;
    }

    @Override
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        SequenceIterator sequenceIterator = this.child.iterate(xPathContext);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return sequenceIterator;
    }

    public Iterable<Operand> operands() {
        return this.operandList(new Operand[]{new Operand(this.child, OperandRole.SAME_FOCUS_ACTION)});
    }

    public boolean replaceOperand(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.child == expression) {
            this.child = expression2;
            bl = true;
        }
        return bl;
    }

    public Expression getChildExpression() {
        return this.child;
    }

    @Override
    public int getInstructionNameCode() {
        if (this.child instanceof Instruction) {
            return ((Instruction)this.child).getInstructionNameCode();
        }
        return -1;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        this.child.explain(expressionPresenter);
    }

    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        this.child.evaluatePendingUpdates(xPathContext, pendingUpdateList);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new TraceExpressionCompiler();
    }

    @Override
    public int getColumnNumber() {
        Object object = this.getProperty("col");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return super.getColumnNumber();
    }
}

