/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.TemplateInversion;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ComponentBody;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import ro.sync.exml.editor.xmleditor.transform.b.f;
import ro.sync.xml.transformer.jb;

public class Template
extends ComponentBody
implements RuleTarget {
    private Pattern matchPattern;
    private StructuredQName templateName;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private boolean declaredStreamable;
    private StructuredQName[] modeNames;
    private List<Rule> references = new ArrayList<Rule>();
    private boolean initialized = false;
    private f stopHandler;
    private TemplateInversion inversion;

    public Template() {
        this.setHostLanguage(50);
    }

    public void setTemplateName(StructuredQName structuredQName) {
        this.templateName = structuredQName;
    }

    public void setMatchPattern(Pattern pattern) {
        if (this.matchPattern != pattern) {
            for (Rule rule : this.references) {
                rule.setPattern(pattern);
            }
        }
        this.matchPattern = pattern;
    }

    public int getComponentKind() {
        return 200;
    }

    public SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public void setBody(Expression expression) {
        super.setBody(expression);
        this.bodyIsTailCallReturner = expression instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.templateName;
    }

    public void allocateAllBindingSlots(StylesheetPackage stylesheetPackage) {
        super.allocateAllBindingSlots(stylesheetPackage);
        if (this.matchPattern != null) {
            Template.allocateBindingSlotsRecursive((StylesheetPackage)stylesheetPackage, (ComponentBody)this, (Expression)new PatternSponsor(this.matchPattern));
        }
    }

    public StructuredQName getObjectName() {
        return this.templateName;
    }

    public void setHasRequiredParams(boolean bl) {
        this.hasRequiredParams = bl;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    public void setModeNames(StructuredQName[] structuredQNameArray) {
        this.modeNames = structuredQNameArray;
    }

    public StructuredQName[] getModeNames() {
        return this.modeNames;
    }

    public void regiaterRule(Rule rule) {
        this.references.add(rule);
    }

    public void setDeclaredStreamable(boolean bl) {
        this.declaredStreamable = bl;
    }

    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    public List<LocalParam> getLocalParams() {
        ArrayList<LocalParam> arrayList = new ArrayList<LocalParam>();
        Template.gatherLocalParams(this.getInterpretedBody(), arrayList);
        return arrayList;
    }

    private static void gatherLocalParams(Expression expression, List<LocalParam> list) {
        if (expression instanceof LocalParamSetter) {
            list.add(((LocalParamSetter)expression).getBinding());
        } else {
            for (Operand operand : expression.operands()) {
                Template.gatherLocalParams(operand.getExpression(), list);
            }
        }
    }

    public LocalParam getLocalParam(StructuredQName structuredQName) {
        for (Operand operand : this.body.operands()) {
            LocalParam localParam;
            Expression expression = operand.getExpression();
            if (expression instanceof LocalParamSetter && ((LocalParamSetter)expression).getBinding().getVariableQName().equals(structuredQName)) {
                return ((LocalParamSetter)expression).getBinding();
            }
            if (!ExpressionTool.containsLocalParam((Expression)expression) || (localParam = Template.getLocalParam(expression, structuredQName)) == null) continue;
            return localParam;
        }
        return null;
    }

    private static LocalParam getLocalParam(Expression expression, StructuredQName structuredQName) {
        for (Operand operand : expression.operands()) {
            Expression expression2 = operand.getExpression();
            if (expression2 instanceof LocalParamSetter && ((LocalParamSetter)expression2).getBinding().getVariableQName().equals(structuredQName)) {
                return ((LocalParamSetter)expression2).getBinding();
            }
            if (!ExpressionTool.containsLocalParam((Expression)expression2)) continue;
            return Template.getLocalParam(expression2, structuredQName);
        }
        return null;
    }

    public void apply(XPathContextMajor xPathContextMajor) throws XPathException {
        for (TailCall tailCall = this.applyLeavingTail(xPathContextMajor); tailCall != null; tailCall = tailCall.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContextMajor xPathContextMajor) throws XPathException {
        try {
            this.checkStop(xPathContextMajor.getConfiguration());
            if (this.bodyIsTailCallReturner) {
                return ((TailCallReturner)this.body).processLeavingTail((XPathContext)xPathContextMajor);
            }
            this.checkStop(xPathContextMajor.getConfiguration());
            this.body.process((XPathContext)xPathContextMajor);
            this.checkStop(xPathContextMajor.getConfiguration());
            return null;
        }
        catch (XPathException xPathException) {
            xPathException.maybeSetLocation((SourceLocator)((Object)this));
            throw xPathException;
        }
        catch (jb jb2) {
            throw jb2;
        }
        catch (Exception exception) {
            String string = "Internal error evaluating template " + (this.getTemplateName() != null ? this.getTemplateName().getDisplayName() : "") + (this.getLineNumber() > 0 ? " at line " + this.getLineNumber() : "") + (this.getSystemId() != null ? " in module " + this.getSystemId() : "");
            throw new RuntimeException(string, exception);
        }
    }

    private void checkStop(Configuration configuration) {
        if (!this.initialized && configuration != null) {
            Object object = configuration.getConfigurationProperty("STOP_HANDLER");
            if (object instanceof f) {
                this.stopHandler = (f)object;
            }
            this.initialized = true;
        }
        if (this.stopHandler != null && this.stopHandler.wpd()) {
            throw new jb();
        }
    }

    public TailCall expand(XPathContext xPathContext) throws XPathException {
        if (this.bodyIsTailCallReturner) {
            return ((TailCallReturner)this.body).processLeavingTail(xPathContext);
        }
        if (this.body != null) {
            this.body.process(xPathContext);
        }
        return null;
    }

    public int getConstructType() {
        return 2008;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.emitAttribute("line", this.getLineNumber() + "");
        expressionPresenter.emitAttribute("module", this.getSystemId());
        if (this.isDeclaredStreamable()) {
            expressionPresenter.emitAttribute("streamable", "true");
        }
        if (this.getBody() != null) {
            this.getBody().explain(expressionPresenter);
        }
    }

    public Expression getInterpretedBody() {
        Expression expression = this.body;
        if (expression instanceof CompiledExpression) {
            expression = ((CompiledExpression)expression).getOriginalExpression();
        }
        return expression;
    }

    public boolean isActuallyStreamable(boolean bl, List<String> list) {
        if (!this.matchPattern.isMotionless(bl)) {
            if (list != null) {
                list.add("The match pattern is not motionless");
            }
            return false;
        }
        if (this.body == null) {
            if (list != null) {
                list.add("The template has no body");
            }
            return false;
        }
        ContextItemStaticInfo contextItemStaticInfo = new ContextItemStaticInfo(this.matchPattern.getItemType(), false, true);
        PostureAndSweep postureAndSweep = this.body.getStreamability(bl, contextItemStaticInfo, list);
        return postureAndSweep.getPosture() == Posture.GROUNDED;
    }

    public void makeInversion(Pattern pattern, Template template) throws XPathException {
        if (template.getBody() instanceof TraceExpression) {
            XPathException xPathException = new XPathException("Saxon restriction: code that uses streaming cannot be compiled with tracing enabled", (SourceLocator)((Object)template));
            xPathException.setErrorCode("SXST0065");
            throw xPathException;
        }
        TemplateInversion templateInversion = new TemplateInversion(template);
        templateInversion.setStackFrame(template.getStackFrameMap());
        templateInversion.invert();
        this.inversion = templateInversion;
    }

    public TemplateInversion getInversion() {
        return this.inversion;
    }
}

