/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ResultDocumentCompiler;
import com.saxonica.ee.stream.adjunct.ResultDocumentAdjunct;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.ReconfigurableSerializer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class ResultDocument
extends Instruction
implements ValidatingInstruction {
    protected Expression href;
    protected Expression formatExpression;
    protected Expression content;
    private boolean async = false;
    protected Properties globalProperties;
    protected Properties localProperties;
    protected String baseURI;
    protected ParseOptions validationOptions;
    protected Map<StructuredQName, Expression> serializationAttributes;
    protected NamespaceResolver nsResolver;
    protected Expression dynamicOutputElement;
    protected boolean resolveAgainstStaticBase = false;
    protected CharacterMapIndex characterMapIndex;

    public ResultDocument(Properties properties, Properties properties2, Expression expression, Expression expression2, String string, int n2, SchemaType schemaType, Map<StructuredQName, Expression> map, CharacterMapIndex characterMapIndex, NamespaceResolver namespaceResolver) {
        this.globalProperties = properties;
        this.localProperties = properties2;
        this.href = expression;
        this.formatExpression = expression2;
        this.baseURI = string;
        this.setValidationAction(n2, schemaType);
        this.serializationAttributes = map;
        this.characterMapIndex = characterMapIndex;
        this.nsResolver = namespaceResolver;
        this.adoptChildExpression(expression);
        for (Expression expression3 : map.values()) {
            this.adoptChildExpression(expression3);
        }
    }

    public void setContentExpression(Expression expression) {
        this.content = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    public void setSchemaType(SchemaType schemaType) {
        if (this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
        }
        this.validationOptions.setSchemaValidationMode(8);
        this.validationOptions.setTopLevelType(schemaType);
    }

    public SchemaType getSchemaType() {
        return this.validationOptions == null ? null : this.validationOptions.getTopLevelType();
    }

    public Expression getHrefExpression() {
        return this.href;
    }

    public String getStaticBaseURI() {
        return this.baseURI;
    }

    public boolean isResolveAgainstStaticBase() {
        return this.resolveAgainstStaticBase;
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int n2, SchemaType schemaType) {
        boolean bl;
        boolean bl2 = bl = n2 == 3 && schemaType == null;
        if (!bl && this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
            this.validationOptions.setSchemaValidationMode(n2);
            this.validationOptions.setTopLevelType(schemaType);
        }
    }

    public int getValidationAction() {
        return this.validationOptions == null ? 3 : this.validationOptions.getSchemaValidationMode();
    }

    public Expression getFormatExpression() {
        return this.formatExpression;
    }

    public void setDynamicOutputElement(Expression expression) {
        this.dynamicOutputElement = expression;
    }

    public void setUseStaticBaseUri(boolean bl) {
        this.resolveAgainstStaticBase = bl;
    }

    public void setAsynchronous(boolean bl) {
        this.async = bl;
    }

    public boolean isAsynchronous() {
        return this.async;
    }

    public Expression simplify(ExpressionVisitor expressionVisitor) throws XPathException {
        this.content = expressionVisitor.simplify(this.content);
        this.href = expressionVisitor.simplify(this.href);
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression expression = entry.getValue();
            if (expression instanceof Literal) continue;
            expression = expressionVisitor.simplify(expression);
            this.serializationAttributes.put(entry.getKey(), expression);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) throws XPathException {
        this.content = expressionVisitor.typeCheck(this.content, contextItemStaticInfo);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = expressionVisitor.typeCheck(this.href, contextItemStaticInfo);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = expressionVisitor.typeCheck(this.formatExpression, contextItemStaticInfo);
            this.adoptChildExpression(this.formatExpression);
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression expression = entry.getValue();
            if (expression instanceof Literal) continue;
            expression = expressionVisitor.typeCheck(expression, contextItemStaticInfo);
            this.adoptChildExpression(expression);
            this.serializationAttributes.put(entry.getKey(), expression);
        }
        try {
            DocumentInstr.checkContentSequence((StaticContext)expressionVisitor.getStaticContext(), (Expression)this.content, (ParseOptions)this.validationOptions);
        }
        catch (XPathException xPathException) {
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) throws XPathException {
        this.content = expressionVisitor.optimize(this.content, contextItemStaticInfo);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = expressionVisitor.optimize(this.href, contextItemStaticInfo);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = expressionVisitor.optimize(this.formatExpression, contextItemStaticInfo);
            this.adoptChildExpression(this.formatExpression);
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression expression = entry.getValue();
            if (expression instanceof Literal) continue;
            expression = expressionVisitor.optimize(expression, contextItemStaticInfo);
            this.adoptChildExpression(expression);
            this.serializationAttributes.put(entry.getKey(), expression);
        }
        return this;
    }

    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    public Expression copy() {
        ResultDocument resultDocument = new ResultDocument(this.globalProperties, this.localProperties, this.href == null ? null : this.href.copy(), this.formatExpression == null ? null : this.formatExpression.copy(), this.baseURI, this.getValidationAction(), this.getSchemaType(), this.serializationAttributes, this.characterMapIndex, this.nsResolver);
        resultDocument.content = this.content.copy();
        resultDocument.dynamicOutputElement = this.dynamicOutputElement == null ? null : this.dynamicOutputElement.copy();
        resultDocument.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        resultDocument.async = this.async;
        return resultDocument;
    }

    @Override
    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.content = this.doPromotion(this.content, promotionOffer);
        if (this.href != null) {
            this.href = this.doPromotion(this.href, promotionOffer);
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            Expression expression = entry.getValue();
            if (expression instanceof Literal) continue;
            expression = this.doPromotion(expression, promotionOffer);
            this.serializationAttributes.put(entry.getKey(), expression);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 192;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(6);
        arrayList.add(new Operand(this.content, OperandRole.SINGLE_ATOMIC));
        if (this.href != null) {
            arrayList.add(new Operand(this.href, OperandRole.SINGLE_ATOMIC));
        }
        if (this.formatExpression != null) {
            arrayList.add(new Operand(this.formatExpression, OperandRole.SINGLE_ATOMIC));
        }
        for (Expression expression : this.serializationAttributes.values()) {
            arrayList.add(new Operand(expression, OperandRole.SINGLE_ATOMIC));
        }
        if (this.dynamicOutputElement != null) {
            arrayList.add(new Operand(this.dynamicOutputElement, OperandRole.SINGLE_ATOMIC));
        }
        return arrayList;
    }

    public boolean replaceOperand(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.content == expression) {
            this.content = expression2;
            bl = true;
        }
        if (this.href == expression) {
            this.href = expression2;
            bl = true;
        }
        for (Map.Entry<StructuredQName, Expression> entry : this.serializationAttributes.entrySet()) {
            if (entry.getValue() != expression) continue;
            this.serializationAttributes.put(entry.getKey(), expression2);
            bl = true;
        }
        if (this.dynamicOutputElement == expression) {
            this.dynamicOutputElement = expression2;
            bl = true;
        }
        return bl;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2 = super.addToPathMap(pathMap, pathMapNodeSet);
        pathMapNodeSet2.setReturnable(false);
        return new PathMap.PathMapNodeSet((PathMap.PathMapNode)pathMap.makeNewRoot((Expression)this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        this.process(this.content, xPathContext);
        return null;
    }

    public void process(Expression expression, XPathContext xPathContext) throws XPathException {
        if (xPathContext.getTemporaryOutputState() != 0) {
            XPathException xPathException = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + xPathContext.getNamePool().getDisplayName(xPathContext.getTemporaryOutputState()));
            xPathException.setErrorCode("XTDE1480");
            xPathException.setLocator((SourceLocator)this);
            throw xPathException;
        }
        xPathContext.getConfiguration().processResultDocument(this, expression, xPathContext);
    }

    public void processInstruction(Expression expression, XPathContext xPathContext) throws XPathException {
        String string;
        Object object;
        Controller controller = xPathContext.getController();
        assert (controller != null);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        String string2 = xPathContext.getCurrentOutputUri();
        if (xPathContext.getTemporaryOutputState() != 0) {
            XPathException xPathException = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + xPathContext.getNamePool().getDisplayName(xPathContext.getTemporaryOutputState()));
            xPathException.setErrorCode("XTDE1480");
            xPathException.setLocator((SourceLocator)this);
            throw xPathException;
        }
        Properties properties = this.gatherOutputProperties(xPathContext);
        String string3 = properties.getProperty("{http://saxon.sf.net/}next-in-chain");
        OutputURIResolver outputURIResolver = null;
        Result result = null;
        if (this.href == null) {
            if (!properties.propertyNames().hasMoreElements()) {
                object = controller.getPrincipalResult();
            } else if (controller.getPrincipalResult() instanceof ReconfigurableSerializer) {
                string = (ReconfigurableSerializer)controller.getPrincipalResult();
                string.reconfigure(properties, this.characterMapIndex);
                object = string;
            } else {
                object = controller.getPrincipalResult();
            }
            string = controller.getBaseOutputURI();
            if (string == null) {
                string = "dummy:/anonymous/principal/result";
            }
            ResultDocument.checkAcceptableUri(xPathContext, string);
            xPathContext.changeOutputDestination(object, this.getValidationOptions());
            xPathContext.setCurrentOutputUri(string);
            object = xPathContext.getReceiver();
        } else {
            outputURIResolver = controller.getOutputURIResolver().newInstance();
            try {
                result = ResultDocument.getResult(this.href, this.baseURI, xPathContext, outputURIResolver, this.resolveAgainstStaticBase);
            }
            catch (XPathException xPathException) {
                xPathException.maybeSetLocation((SourceLocator)this);
                throw xPathException;
            }
            string = xPathContext.getConfiguration().getSerializerFactory();
            PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
            pipelineConfiguration.setHostLanguage(50);
            LocationProvider locationProvider = pipelineConfiguration.getLocationProvider();
            object = string.getReceiver(result, pipelineConfiguration, properties, this.characterMapIndex);
            xPathContext.changeOutputDestination(object, this.getValidationOptions());
            xPathContext.setCurrentOutputUri(result.getSystemId());
            object = xPathContext.getReceiver();
            pipelineConfiguration.setLocationProvider(locationProvider);
        }
        object.open();
        try {
            object.startDocument(0);
            expression.process(xPathContext);
            object.endDocument();
        }
        catch (XPathException xPathException) {
            xPathException.setXPathContext(xPathContext);
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
        finally {
            object.close();
            xPathContext.setReceiver(sequenceReceiver);
            xPathContext.setCurrentOutputUri(string2);
            if (outputURIResolver != null) {
                try {
                    outputURIResolver.close(result);
                }
                catch (TransformerException transformerException) {
                    throw XPathException.makeXPathException((Exception)transformerException);
                }
            }
        }
    }

    public static Result getResult(Expression expression, String string, XPathContext xPathContext, OutputURIResolver outputURIResolver, boolean bl) throws XPathException {
        String string2;
        Object object;
        block14: {
            Controller controller = xPathContext.getController();
            if (expression == null) {
                object = controller.getPrincipalResult();
                string2 = controller.getBaseOutputURI();
                if (string2 == null) {
                    string2 = "dummy:/anonymous/principal/result";
                }
            } else {
                try {
                    String string3 = bl ? string : controller.getCookedBaseOutputURI();
                    String string4 = ((Object)EscapeURI.iriToUri((CharSequence)expression.evaluateAsString(xPathContext))).toString();
                    if (string4.equals("")) {
                        object = controller.getPrincipalResult();
                        string2 = controller.getBaseOutputURI();
                        if (string2 == null) {
                            string2 = "dummy:/anonymous/principal/result";
                        }
                        break block14;
                    }
                    try {
                        object = outputURIResolver == null ? null : outputURIResolver.resolve(string4, string3);
                    }
                    catch (TransformerException transformerException) {
                        throw XPathException.makeXPathException((Exception)transformerException);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new XPathException("Exception thrown by OutputURIResolver", (Throwable)exception);
                    }
                    if (object == null) {
                        outputURIResolver = StandardOutputResolver.getInstance();
                        object = outputURIResolver.resolve(string4, string3);
                    }
                    if ((string2 = object.getSystemId()) == null) {
                        try {
                            string2 = new URI(string3).resolve(string4).toString();
                            object.setSystemId(string2);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (TransformerException transformerException) {
                    throw XPathException.makeXPathException((Exception)transformerException);
                }
            }
        }
        ResultDocument.checkAcceptableUri(xPathContext, string2);
        ResultDocument.traceDestination(xPathContext, (Result)object);
        return object;
    }

    public static void traceDestination(XPathContext xPathContext, Result result) {
        Configuration configuration = xPathContext.getConfiguration();
        boolean bl = configuration.isTiming();
        if (bl) {
            String string = result.getSystemId();
            if (string == null) {
                string = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            configuration.getStandardErrorOutput().println("Writing to " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAcceptableUri(XPathContext xPathContext, String string) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if (string != null) {
            if (controller.getDocumentPool().find(string) != null) {
                XPathException xPathException = new XPathException("Cannot write to a URI that has already been read: " + (string.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : string));
                xPathException.setXPathContext(xPathContext);
                xPathException.setErrorCode("XTRE1500");
                throw xPathException;
            }
            DocumentURI documentURI = new DocumentURI(string);
            Controller controller2 = controller;
            synchronized (controller2) {
                if (!controller.checkUniqueOutputDestination(documentURI)) {
                    XPathException xPathException = new XPathException("Cannot write more than one result document to the same URI: " + (string.equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : string));
                    xPathException.setXPathContext(xPathContext);
                    xPathException.setErrorCode("XTDE1490");
                    throw xPathException;
                }
                controller.addUnavailableOutputDestination(documentURI);
            }
        }
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    public Properties gatherOutputProperties(XPathContext xPathContext) throws XPathException {
        String string;
        Iterator<Object> iterator;
        Object object3;
        Object object4;
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Configuration configuration = xPathContext.getConfiguration();
        Properties properties = this.globalProperties;
        if (this.formatExpression != null) {
            object4 = this.formatExpression.evaluateAsString(xPathContext);
            try {
                object3 = NameChecker.getQNameParts((CharSequence)object4);
            }
            catch (QNameException qNameException) {
                XPathException xPathException = new XPathException("The requested output format " + Err.wrap((CharSequence)object4) + " is not a valid QName");
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            String object22 = this.nsResolver.getURIForPrefix((String)object3[0], false);
            if (object22 == null) {
                XPathException xPathException = new XPathException("The namespace prefix in the format name " + object4 + " is undeclared");
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            iterator = new StructuredQName((String)object3[0], object22, (String)object3[1]);
        }
        object4 = new Properties(properties);
        for (Object e2 : this.localProperties.keySet()) {
            iterator = (String)e2;
            String[] stringArray = NamePool.parseClarkName((String)((Object)iterator));
            try {
                ResultDocument.setSerializationProperty((Properties)object4, stringArray[0], stringArray[1], this.localProperties.getProperty((String)((Object)iterator)), this.nsResolver, true, configuration);
            }
            catch (XPathException xPathException) {
                xPathException.setErrorCode("XTDE0030");
                xPathException.maybeSetLocation((SourceLocator)this);
                throw xPathException;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            for (Map.Entry entry : this.serializationAttributes.entrySet()) {
                iterator = ((Object)((Expression)entry.getValue()).evaluateAsString(xPathContext)).toString();
                String string2 = ((StructuredQName)entry.getKey()).getLocalPart();
                string = ((StructuredQName)entry.getKey()).getURI();
                try {
                    ResultDocument.setSerializationProperty((Properties)object4, string, string2, iterator, this.nsResolver, false, configuration);
                }
                catch (XPathException xPathException) {
                    xPathException.setErrorCode("XTDE0030");
                    xPathException.maybeSetLocation((SourceLocator)this);
                    xPathException.maybeSetContext(xPathContext);
                    if ("http://saxon.sf.net/".equals(xPathException.getErrorCodeNamespace()) && "SXWN".equals(xPathException.getErrorCodeLocalPart().substring(0, 4))) {
                        controller.getErrorListener().warning((TransformerException)((Object)xPathException));
                        continue;
                    }
                    throw xPathException;
                }
            }
        }
        if (this.dynamicOutputElement != null) {
            object3 = this.dynamicOutputElement.evaluateItem(xPathContext);
            if (!(object3 instanceof NodeInfo) || ((NodeInfo)object3).getNodeKind() != 1 || ((NodeInfo)object3).getFingerprint() != 183) {
                XPathException xPathException = new XPathException("The third argument of saxon:result-document must be an <xsl:output> element");
                xPathException.setLocator((SourceLocator)this);
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
            Properties properties2 = new Properties();
            ResultDocument.processXslOutputElement((NodeInfo)object3, properties2, xPathContext);
            for (Object object : properties2.keySet()) {
                string = (String)object;
                StructuredQName structuredQName = StructuredQName.fromClarkName(string);
                String string3 = properties2.getProperty(string);
                try {
                    ResultDocument.setSerializationProperty((Properties)object4, structuredQName.getURI(), structuredQName.getLocalPart(), string3, this.nsResolver, false, configuration);
                }
                catch (XPathException xPathException) {
                    xPathException.setErrorCode("XTDE0030");
                    xPathException.maybeSetLocation((SourceLocator)this);
                    xPathException.maybeSetContext(xPathContext);
                    throw xPathException;
                }
            }
        }
        return object4;
    }

    public static void setSerializationProperty(Properties properties, String string, String string2, String string3, NamespaceResolver namespaceResolver, boolean bl, Configuration configuration) throws XPathException {
        if (string.length() == 0 || "http://saxon.sf.net/".equals(string)) {
            if (string2.equals("method")) {
                if (string3.equals("xml") || string3.equals("html") || string3.equals("text") || string3.equals("xhtml") || bl || string3.startsWith("{")) {
                    properties.setProperty("method", string3);
                } else {
                    try {
                        String[] stringArray = NameChecker.getQNameParts((CharSequence)string3);
                        String string4 = stringArray[0];
                        if (string4.length() == 0) {
                            XPathException xPathException = new XPathException("method must be xml, html, xhtml, or text, or a prefixed name");
                            xPathException.setErrorCode("SEPM0016");
                            xPathException.setIsStaticError(true);
                            throw xPathException;
                        }
                        if (namespaceResolver != null) {
                            String string5 = namespaceResolver.getURIForPrefix(string4, false);
                            if (string5 == null) {
                                XPathException xPathException = new XPathException("Namespace prefix '" + string4 + "' has not been declared");
                                xPathException.setErrorCode("SEPM0016");
                                xPathException.setIsStaticError(true);
                                throw xPathException;
                            }
                            properties.setProperty("method", '{' + string5 + '}' + stringArray[1]);
                        }
                        properties.setProperty("method", string3);
                    }
                    catch (QNameException qNameException) {
                        XPathException xPathException = new XPathException("Invalid method name. " + qNameException.getMessage());
                        xPathException.setErrorCode("SEPM0016");
                        xPathException.setIsStaticError(true);
                        throw xPathException;
                    }
                }
            } else if (string2.equals("use-character-maps")) {
                String string6 = properties.getProperty("use-character-maps");
                if (string6 == null) {
                    string6 = "";
                }
                properties.setProperty("use-character-maps", string6 + string3);
            } else if (string2.equals("cdata-section-elements")) {
                ResultDocument.processListOfNodeNames(properties, "cdata-section-elements", string3, namespaceResolver, true, bl);
            } else if (string2.equals("suppress-indentation")) {
                ResultDocument.processListOfNodeNames(properties, "suppress-indentation", string3, namespaceResolver, true, bl);
            } else if (string2.equals("double-space")) {
                ResultDocument.processListOfNodeNames(properties, "{http://saxon.sf.net/}double-space", string3, namespaceResolver, true, bl);
            } else if (string2.equals("attribute-order")) {
                ResultDocument.processListOfNodeNames(properties, "{http://saxon.sf.net/}attribute-order", string3, namespaceResolver, false, bl);
            } else {
                if (string2.equals("next-in-chain")) {
                    XPathException xPathException = new XPathException("saxon:next-in-chain property is available only on xsl:output");
                    xPathException.setErrorCodeQName(new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9004"));
                    throw xPathException;
                }
                if (string2.equals("output-version")) {
                    string2 = "version";
                }
                String string7 = string2;
                if (string.length() != 0) {
                    string7 = '{' + string + '}' + string2;
                }
                if (!bl) {
                    try {
                        string3 = SaxonOutputKeys.checkOutputProperty((String)string7, (String)Whitespace.trim((CharSequence)string3), (Configuration)configuration, (boolean)true);
                    }
                    catch (XPathException xPathException) {
                        xPathException.maybeSetErrorCode("SEPM0016");
                        throw xPathException;
                    }
                }
                properties.setProperty(string7, string3);
            }
        } else {
            properties.setProperty('{' + string + '}' + string2, string3);
        }
    }

    private static void processListOfNodeNames(Properties properties, String string, String string2, NamespaceResolver namespaceResolver, boolean bl, boolean bl2) throws XPathException {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            string3 = "";
        }
        String string4 = SaxonOutputKeys.parseListOfNodeNames((String)string2, (NamespaceResolver)namespaceResolver, (boolean)bl, (boolean)bl2, (String)"SEPM0016");
        properties.setProperty(string, string3 + string4);
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("resultDocument");
        if (this.href != null) {
            expressionPresenter.startSubsidiaryElement("href");
            this.href.explain(expressionPresenter);
            expressionPresenter.endSubsidiaryElement();
        }
        expressionPresenter.startSubsidiaryElement("content");
        this.content.explain(expressionPresenter);
        expressionPresenter.endSubsidiaryElement();
        expressionPresenter.endElement();
    }

    public static void processXslOutputElement(NodeInfo nodeInfo, Properties properties, XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo2;
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2);
        InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(nodeInfo);
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            String string = nodeInfo2.getURI();
            String string2 = nodeInfo2.getLocalPart();
            String string3 = Whitespace.trim((CharSequence)nodeInfo2.getStringValueCS());
            ResultDocument.setSerializationProperty(properties, string, string2, string3, (NamespaceResolver)inscopeNamespaceResolver, false, xPathContext.getConfiguration());
        }
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new ResultDocumentCompiler();
    }

    public ResultDocumentAdjunct getStreamingAdjunct() {
        return new ResultDocumentAdjunct();
    }
}

