/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.InterpretedExpressionCompiler;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import ro.sync.xml.transformer.v;

public class Message
extends Instruction {
    private Expression terminate;
    private Expression select;
    private Expression errorCode;
    private NamespaceResolver nsResolver;
    private boolean isAssert;

    public Message(Expression expression, Expression expression2, Expression expression3) {
        this.terminate = expression2;
        this.select = expression;
        this.errorCode = expression3 == null ? new StringLiteral((CharSequence)"Q{http://www.w3.org/2005/xqt-errors}XTMM9000", expression.getContainer()) : expression3;
        this.adoptChildExpression(expression2);
        this.adoptChildExpression(expression);
    }

    public void setIsAssert(boolean bl) {
        this.isAssert = bl;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.nsResolver = namespaceResolver;
    }

    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) throws XPathException {
        this.select = expressionVisitor.typeCheck(this.select, contextItemStaticInfo);
        this.adoptChildExpression(this.select);
        this.terminate = expressionVisitor.typeCheck(this.terminate, contextItemStaticInfo);
        this.adoptChildExpression(this.terminate);
        this.errorCode = expressionVisitor.typeCheck(this.errorCode, contextItemStaticInfo);
        this.adoptChildExpression(this.errorCode);
        return this;
    }

    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) throws XPathException {
        this.select = expressionVisitor.optimize(this.select, contextItemStaticInfo);
        this.adoptChildExpression(this.select);
        this.terminate = expressionVisitor.optimize(this.terminate, contextItemStaticInfo);
        this.adoptChildExpression(this.terminate);
        this.errorCode = expressionVisitor.optimize(this.errorCode, contextItemStaticInfo);
        this.adoptChildExpression(this.errorCode);
        return this;
    }

    public Expression copy() {
        return new Message(this.select.copy(), this.terminate.copy(), this.errorCode.copy());
    }

    @Override
    public int getInstructionNameCode() {
        return this.isAssert ? 134 : 173;
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        return 24576;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
        this.terminate = this.doPromotion(this.terminate, promotionOffer);
        this.errorCode = this.doPromotion(this.errorCode, promotionOffer);
    }

    public Iterable<Operand> operands() {
        return this.operandList(new Operand[]{new Operand(this.select, OperandRole.SINGLE_ATOMIC), new Operand(this.terminate, OperandRole.SINGLE_ATOMIC)});
    }

    public boolean replaceOperand(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        if (this.terminate == expression) {
            this.terminate = expression2;
            bl = true;
        }
        if (this.errorCode == expression) {
            this.errorCode = expression2;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Receiver receiver = controller.getMessageEmitter();
        if (receiver instanceof v) {
            ((v)receiver).b(this);
        }
        if (receiver != null) {
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                Item item;
                Object object = new TreeReceiver(receiver);
                object = new AttributeMasker((SequenceReceiver)object);
                SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
                int n2 = xPathContext.getTemporaryOutputState();
                Properties properties = new Properties();
                properties.setProperty("omit-xml-declaration", "yes");
                SerializerFactory serializerFactory = xPathContext.getConfiguration().getSerializerFactory();
                PipelineConfiguration pipelineConfiguration = controller.makePipelineConfiguration();
                pipelineConfiguration.setHostLanguage(50);
                Receiver receiver3 = serializerFactory.getReceiver((Result)object, pipelineConfiguration, properties);
                xPathContext.changeOutputDestination(receiver3, null);
                xPathContext.setTemporaryOutputState(173);
                boolean bl = false;
                String string = Whitespace.trim((CharSequence)this.terminate.evaluateAsString(xPathContext));
                if (!(string.equals("no") || string.equals("false") || string.equals("0"))) {
                    if (string.equals("yes") || string.equals("true") || string.equals("1")) {
                        bl = true;
                    } else {
                        XPathException xPathException = new XPathException("The terminate attribute of xsl:message must be yes|no|true|false|1|0");
                        xPathException.setXPathContext(xPathContext);
                        xPathException.setErrorCode("XTDE0030");
                        throw xPathException;
                    }
                }
                object.startDocument(bl ? 16384 : 0);
                SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    object.append(item, this.locationId, 2);
                }
                object.endDocument();
                xPathContext.setReceiver(sequenceReceiver);
                xPathContext.setTemporaryOutputState(n2);
                if (bl) {
                    TerminationException terminationException = new TerminationException("Processing terminated by " + StandardErrorListener.getInstructionName((Instruction)this) + " at line " + this.getLineNumber() + " in " + StandardErrorListener.abbreviatePath((String)this.getSystemId()));
                    terminationException.setLocator((SourceLocator)this);
                    try {
                        String string2 = ((Object)this.errorCode.evaluateAsString(xPathContext)).toString();
                        StructuredQName structuredQName = StructuredQName.fromLexicalQName(string2, false, true, this.nsResolver);
                        terminationException.setErrorCodeQName(structuredQName);
                    }
                    catch (XPathException xPathException) {
                        // empty catch block
                    }
                    throw terminationException;
                }
                return null;
            }
        }
        return null;
    }

    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("xslMessage");
        expressionPresenter.endElement();
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new InterpretedExpressionCompiler();
    }

    private static class AttributeMasker
    extends ProxyReceiver {
        private boolean contentStarted = true;

        public AttributeMasker(SequenceReceiver sequenceReceiver) {
            super((Receiver)sequenceReceiver);
        }

        public void startElement(NodeName nodeName, SchemaType schemaType, int n2, int n3) throws XPathException {
            this.contentStarted = false;
            super.startElement(nodeName, schemaType, n2, n3);
        }

        public void startContent() throws XPathException {
            this.contentStarted = true;
            super.startContent();
        }

        public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2, int n3) throws XPathException {
            if (this.contentStarted) {
                String string = nodeName.getDisplayName();
                this.processingInstruction("attribute", "name=\"" + string + "\" value=\"" + charSequence + "\"", 0, 0);
            } else {
                super.attribute(nodeName, simpleType, charSequence, n2, n3);
            }
        }

        public void namespace(NamespaceBinding namespaceBinding, int n2) throws XPathException {
            if (this.contentStarted) {
                String string = namespaceBinding.getPrefix();
                String string2 = namespaceBinding.getURI();
                this.processingInstruction("namespace", "prefix=\"" + string + "\" uri=\"" + string2 + "\"", 0, 0);
            } else {
                super.namespace(namespaceBinding, n2);
            }
        }

        public void append(Item item, int n2, int n3) throws XPathException {
            int n4;
            if (item instanceof NodeInfo && ((n4 = ((NodeInfo)item).getNodeKind()) == 2 || n4 == 13)) {
                ((NodeInfo)item).copy((Receiver)this, 0, 0);
                return;
            }
            ((SequenceReceiver)this.nextReceiver).append(item, n2, n3);
        }
    }
}

