/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SaxonInstruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import ro.sync.exml.editor.xmleditor.transform.b.f;
import ro.sync.xml.transformer.jb;

public abstract class Instruction
extends SaxonInstruction {
    private f stopHandler = null;
    private boolean initialized = false;

    @Override
    public void process(XPathContext xPathContext) throws XPathException {
        Configuration configuration = xPathContext.getConfiguration();
        try {
            this.checkStop(configuration);
            this.checkStop(configuration);
            for (TailCall tailCall = this.processLeavingTail(xPathContext); tailCall != null; tailCall = tailCall.processLeavingTail()) {
                this.checkStop(configuration);
            }
        }
        catch (XPathException xPathException) {
            xPathException.maybeSetLocation((SourceLocator)this);
            throw xPathException;
        }
        this.checkStop(configuration);
    }

    private void checkStop(Configuration configuration) {
        if (!this.initialized && configuration != null) {
            Object object = configuration.getConfigurationProperty("STOP_HANDLER");
            if (object instanceof f) {
                this.stopHandler = (f)object;
            }
            this.initialized = true;
        }
        if (this.stopHandler != null && this.stopHandler.wpd()) {
            throw new jb();
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        this.checkStop(xPathContext.getConfiguration());
        int n2 = this.getImplementationMethod();
        if ((n2 & 1) != 0) {
            Item item = this.evaluateItem(xPathContext);
            if (item == null) {
                return EmptyIterator.emptyIterator();
            }
            return SingletonIterator.makeIterator((Item)item);
        }
        if ((n2 & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        return this.getIteratorFromProcessMethod(xPathContext);
    }
}

