/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import ro.sync.xml.transformer.b.c;

public class Executable {
    private Configuration config;
    private SpaceStrippingRule stripperRules;
    private boolean stripsWhitespace;
    private KeyManager keyManager;
    private SlotManager globalVariableMap;
    private List<GlobalVariable> compiledGlobalVariables;
    private Properties defaultOutputProperties;
    private int largestPatternStackFrame = 0;
    private CharacterMapIndex characterMapIndex;
    private LocationMap locationMap = new LocationMap();
    private HashMap<String, List<QueryModule>> queryLibraryModules;
    private HashSet<String> queryLocationHintsProcessed;
    private boolean stripsInputTypeAnnotations;
    private FunctionLibraryList functionLibrary;
    private int hostLanguage = 50;
    private boolean allowXPath30 = false;
    private HashSet<StructuredQName> requiredParams = null;
    private HashMap<StructuredQName, Properties> outputDeclarations = null;
    private boolean createsSecondaryResult = false;
    private boolean schemaAware = false;
    private GlobalVariable initialContextItemVariable = null;

    public Executable(Configuration configuration) {
        this.setConfiguration(configuration);
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        c.b().b(configuration, true);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setHostLanguage(int n2, boolean bl) {
        this.hostLanguage = n2;
        this.allowXPath30 = bl;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public boolean isAllowXPath30() {
        return this.allowXPath30;
    }

    public FunctionLibraryList getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibraryList functionLibraryList) {
        this.functionLibrary = functionLibraryList;
    }

    public void setCharacterMapIndex(CharacterMapIndex characterMapIndex) {
        this.characterMapIndex = characterMapIndex;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        if (this.characterMapIndex == null) {
            this.characterMapIndex = new CharacterMapIndex();
        }
        return this.characterMapIndex;
    }

    public void setStripperRules(SpaceStrippingRule spaceStrippingRule) {
        this.stripperRules = spaceStrippingRule;
    }

    public SpaceStrippingRule getStripperRules() {
        return this.stripperRules == null ? NoElementsSpaceStrippingRule.getInstance() : this.stripperRules;
    }

    public void setStripsWhitespace(boolean bl) {
        this.stripsWhitespace = bl;
    }

    public boolean stripsWhitespace() {
        return this.stripsWhitespace;
    }

    public void setStripsInputTypeAnnotations(boolean bl) {
        this.stripsInputTypeAnnotations = bl;
    }

    public boolean stripsInputTypeAnnotations() {
        return this.stripsInputTypeAnnotations;
    }

    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.defaultOutputProperties = properties;
    }

    public Properties getDefaultOutputProperties() {
        if (this.defaultOutputProperties == null) {
            this.defaultOutputProperties = new Properties();
        }
        return this.defaultOutputProperties;
    }

    public void setOutputProperties(StructuredQName structuredQName, Properties properties) {
        if (this.outputDeclarations == null) {
            this.outputDeclarations = new HashMap(5);
        }
        this.outputDeclarations.put(structuredQName, properties);
    }

    public Properties getOutputProperties(StructuredQName structuredQName) {
        if (this.outputDeclarations == null) {
            return null;
        }
        return this.outputDeclarations.get(structuredQName);
    }

    public void addQueryLibraryModule(QueryModule queryModule) {
        String string;
        List<QueryModule> list;
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap(5);
        }
        if ((list = this.queryLibraryModules.get(string = queryModule.getModuleNamespace())) == null) {
            list = new ArrayList<QueryModule>(5);
            list.add(queryModule);
            this.queryLibraryModules.put(string, list);
        } else {
            list.add(queryModule);
        }
    }

    public List<QueryModule> getQueryLibraryModules(String string) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return this.queryLibraryModules.get(string);
    }

    public QueryModule getQueryModuleWithSystemId(String string, QueryModule queryModule) {
        if (string.equals(queryModule.getSystemId())) {
            return queryModule;
        }
        Iterator iterator = this.getQueryLibraryModules();
        while (iterator.hasNext()) {
            QueryModule queryModule2 = (QueryModule)iterator.next();
            String string2 = queryModule2.getSystemId();
            if (string2 == null || !string2.equals(string)) continue;
            return queryModule2;
        }
        return null;
    }

    public Iterator getQueryLibraryModules() {
        if (this.queryLibraryModules == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<QueryModule> arrayList = new ArrayList<QueryModule>();
        for (List<QueryModule> list : this.queryLibraryModules.values()) {
            arrayList.addAll(list);
        }
        return arrayList.iterator();
    }

    public void addQueryLocationHintProcessed(String string) {
        if (this.queryLocationHintsProcessed == null) {
            this.queryLocationHintsProcessed = new HashSet();
        }
        this.queryLocationHintsProcessed.add(string);
    }

    public boolean isQueryLocationHintProcessed(String string) {
        return this.queryLocationHintsProcessed != null && this.queryLocationHintsProcessed.contains(string);
    }

    public void fixupQueryModules(QueryModule queryModule, boolean bl) throws XPathException {
        Object object;
        Object object5;
        if (this.initialContextItemVariable == null) {
            object5 = new GlobalParam();
            object5.setPackageData(queryModule.getPackageData());
            object5.setRequiredParam(false);
            ErrorExpression object42 = new ErrorExpression(new XPathException("Context item is absent", "XPDY0002"));
            object42.setContainer((Container)object5);
            object5.setSelectExpression((Expression)object42);
            StructuredQName structuredQName = StandardNames.SAXON_CONTEXT_ITEM;
            object5.setVariableQName(structuredQName);
            object5.setRequiredType(SequenceType.SINGLE_ITEM);
            this.setInitialContextItemVariable((GlobalVariable)object5);
            this.registerGlobalVariable((GlobalVariable)object5);
            this.getGlobalVariableMap().allocateSlotNumber(structuredQName);
            object = object5;
        } else {
            object = this.initialContextItemVariable;
        }
        queryModule.bindUnboundVariables();
        if (this.queryLibraryModules != null) {
            for (List list : this.queryLibraryModules.values()) {
                for (Object object2 : list) {
                    object2.bindUnboundVariables();
                }
            }
        }
        object5 = queryModule.fixupGlobalVariables(queryModule.getGlobalStackFrameMap(), object);
        queryModule.bindUnboundFunctionCalls();
        if (this.queryLibraryModules != null) {
            for (List<QueryModule> list : this.queryLibraryModules.values()) {
                for (QueryModule queryModule2 : list) {
                    queryModule2.bindUnboundFunctionCalls();
                }
            }
        }
        queryModule.checkForCircularities((List)object5, queryModule.getGlobalFunctionLibrary());
        queryModule.fixupGlobalFunctions();
        if (bl) {
            Iterator iterator = this.getQueryLibraryModules();
            while (iterator.hasNext()) {
                QueryModule queryModule3 = (QueryModule)iterator.next();
                queryModule3.lookForModuleCycles(new Stack(), 1);
            }
        }
        queryModule.typeCheckGlobalVariables((List)object5);
        queryModule.optimizeGlobalFunctions();
    }

    public void setPatternSlotSpace(int n2) {
        this.largestPatternStackFrame = n2;
    }

    public SlotManager getGlobalVariableMap() {
        if (this.globalVariableMap == null) {
            this.globalVariableMap = this.config.makeSlotManager();
        }
        return this.globalVariableMap;
    }

    public List<GlobalVariable> getCompiledGlobalVariables() {
        return this.compiledGlobalVariables;
    }

    public void explainGlobalVariables(ExpressionPresenter expressionPresenter) {
        if (this.compiledGlobalVariables != null) {
            expressionPresenter.startElement("globalVariables");
            for (GlobalVariable globalVariable : this.compiledGlobalVariables) {
                Visibility visibility;
                expressionPresenter.startElement("declareVariable");
                expressionPresenter.emitAttribute("name", globalVariable.getVariableQName().getDisplayName());
                if (globalVariable.getDeclaringComponent() != null && (visibility = globalVariable.getDeclaringComponent().getVisibility()) != null) {
                    expressionPresenter.emitAttribute("visibility", visibility.toString());
                }
                if (globalVariable.isAssignable()) {
                    expressionPresenter.emitAttribute("assignable", "true");
                }
                if (globalVariable.getSelectExpression() != null) {
                    globalVariable.getSelectExpression().explain(expressionPresenter);
                }
                expressionPresenter.endElement();
            }
            expressionPresenter.endElement();
        }
    }

    public void registerGlobalVariable(GlobalVariable globalVariable) {
        if (this.compiledGlobalVariables == null) {
            this.compiledGlobalVariables = new ArrayList<GlobalVariable>(32);
        }
        this.compiledGlobalVariables.add(globalVariable);
        if (globalVariable.isRequiredParam()) {
            if (this.requiredParams == null) {
                this.requiredParams = new HashSet(5);
            }
            this.requiredParams.add(globalVariable.getVariableQName());
        }
    }

    public int getLargestPatternStackFrame() {
        return this.largestPatternStackFrame;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void checkAllRequiredParamsArePresent(GlobalParameterSet globalParameterSet) throws XPathException {
        if (this.requiredParams == null) {
            return;
        }
        for (StructuredQName structuredQName : this.requiredParams) {
            if (globalParameterSet != null && globalParameterSet.get(structuredQName) != null) continue;
            XPathException xPathException = new XPathException("No value supplied for required parameter " + structuredQName.getDisplayName());
            xPathException.setErrorCode(this.getHostLanguage() == 51 ? "XPDY0002" : "XTDE0050");
            throw xPathException;
        }
    }

    public void setCreatesSecondaryResult(boolean bl) {
        this.createsSecondaryResult = bl;
    }

    public boolean createsSecondaryResult() {
        return this.createsSecondaryResult;
    }

    public void setInitialContextItemVariable(GlobalVariable globalVariable) {
        this.initialContextItemVariable = globalVariable;
    }

    public GlobalVariable getInitialContextItemVariable() {
        return this.initialContextItemVariable;
    }

    public void setSchemaAware(boolean bl) {
        if (bl) {
            this.config.checkLicensedFeature(1, "schema-aware processing");
        }
        this.schemaAware = bl;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }
}

