/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trace.ContextStackIterator;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.DateTimeValue;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    FocusIterator currentIterator;
    LastValue last = new LastValue(-1);
    SequenceReceiver currentReceiver;
    XPathContext caller = null;
    protected StackFrame stackFrame;
    protected String currentDestination = "";
    protected int temporaryOutputState = 0;
    XPathException currentException;

    protected XPathContextMinor() {
    }

    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext((XPathContextMinor)this);
    }

    public XPathContextMinor newMinorContext() {
        XPathContextMinor xPathContextMinor = new XPathContextMinor();
        xPathContextMinor.controller = this.controller;
        xPathContextMinor.caller = this;
        xPathContextMinor.currentIterator = this.currentIterator;
        xPathContextMinor.currentReceiver = this.currentReceiver;
        xPathContextMinor.last = this.last;
        xPathContextMinor.stackFrame = this.stackFrame;
        xPathContextMinor.currentException = this.currentException;
        xPathContextMinor.currentDestination = this.currentDestination;
        xPathContextMinor.temporaryOutputState = this.temporaryOutputState;
        return xPathContextMinor;
    }

    public void setCaller(XPathContext xPathContext) {
        this.caller = xPathContext;
    }

    public XPathContextMajor newCleanContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.getController());
        xPathContextMajor.setCaller((XPathContext)this);
        return xPathContextMajor;
    }

    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    public final Controller getController() {
        return this.controller;
    }

    public final Configuration getConfiguration() {
        return this.controller.getConfiguration();
    }

    public final NamePool getNamePool() {
        return this.controller.getConfiguration().getNamePool();
    }

    public final XPathContext getCaller() {
        return this.caller;
    }

    public void setCurrentIterator(FocusIterator focusIterator) {
        this.currentIterator = focusIterator;
        this.last = new LastValue(-1);
    }

    public final FocusIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public final Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public final int getLast() throws XPathException {
        if (this.currentIterator == null) {
            XPathException xPathException = new XPathException("The context item is absent, so last() is undefined");
            xPathException.setXPathContext((XPathContext)this);
            xPathException.setErrorCode("XPDY0002");
            throw xPathException;
        }
        if (this.last.value >= 0) {
            return this.last.value;
        }
        if ((this.currentIterator.getProperties() & 2) == 0) {
            FocusIterator focusIterator = this.currentIterator.getAnother();
            int n2 = 0;
            while (focusIterator.next() != null) {
                ++n2;
            }
            this.last.value = n2;
            return this.last.value;
        }
        this.last.value = this.currentIterator.getLength();
        return this.last.value;
    }

    public final boolean isAtLast() throws XPathException {
        if ((this.currentIterator.getProperties() & 4) != 0) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.currentIterator.position() == this.getLast();
    }

    public URIResolver getURIResolver() {
        return this.caller.getURIResolver();
    }

    public UnfailingErrorListener getErrorListener() {
        return this.caller.getErrorListener();
    }

    public Component getCurrentComponent() {
        return this.caller.getCurrentComponent();
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public final Sequence evaluateLocalVariable(int n2) {
        return this.stackFrame.slots[n2];
    }

    public final void setLocalVariable(int n2, Sequence sequence) {
        try {
            this.stackFrame.slots[n2] = sequence;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AssertionError((Object)("Internal error: invalid slot number for local variable " + (n2 == -999 ? "(No slot allocated)" : "(" + n2 + ")")));
        }
    }

    public synchronized void notifyChildThreads() throws XPathException {
        this.getCaller().notifyChildThreads();
    }

    public void changeOutputDestination(Receiver receiver, ParseOptions parseOptions) throws XPathException {
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter(pipelineConfiguration);
        complexContentOutputter.setHostLanguage(pipelineConfiguration.getHostLanguage());
        NamespaceReducer namespaceReducer = new NamespaceReducer(receiver);
        namespaceReducer.setSystemId(receiver.getSystemId());
        receiver = namespaceReducer;
        if (parseOptions != null && parseOptions.getSchemaValidationMode() != 3) {
            Configuration configuration = this.controller.getConfiguration();
            receiver = configuration.getDocumentValidator((Receiver)namespaceReducer, receiver.getSystemId(), parseOptions);
        }
        complexContentOutputter.setReceiver(receiver);
        this.currentReceiver = complexContentOutputter;
    }

    public void setReceiver(SequenceReceiver sequenceReceiver) {
        this.currentReceiver = sequenceReceiver;
    }

    public final SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    public void setTemporaryOutputState(int n2) {
        this.temporaryOutputState = n2;
    }

    public int getTemporaryOutputState() {
        return this.temporaryOutputState;
    }

    public void setCurrentOutputUri(String string) {
        this.currentDestination = string;
    }

    public String getCurrentOutputUri() {
        return this.currentDestination;
    }

    public int useLocalParameter(StructuredQName structuredQName, int n2, boolean bl) throws XPathException {
        return this.getCaller().useLocalParameter(structuredQName, n2, bl);
    }

    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    public Rule getCurrentTemplateRule() {
        return null;
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    public GroupIterator getCurrentMergeGroupIterator() {
        return this.getCaller().getCurrentMergeGroupIterator();
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    public DateTimeValue getCurrentDateTime() {
        return this.controller.getCurrentDateTime();
    }

    public final int getImplicitTimezone() {
        return this.controller.getImplicitTimezone();
    }

    public Iterator iterateStackFrames() {
        return new ContextStackIterator((XPathContext)this);
    }

    public void setCurrentException(XPathException xPathException) {
        this.currentException = xPathException;
    }

    public XPathException getCurrentException() {
        return this.currentException;
    }

    public Component getTargetComponent(int n2) {
        return this.getCaller().getTargetComponent(n2);
    }

    protected static class LastValue {
        public int value = 0;

        public LastValue(int n2) {
            this.value = n2;
        }
    }
}

