/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;

public class ReceivingContentHandler
implements ContentHandler,
LexicalHandler,
DTDHandler {
    private PipelineConfiguration pipe;
    private Receiver receiver;
    private boolean inDTD = false;
    private Locator locator;
    private LocalLocator localLocator = new LocalLocator();
    private char[] buffer = new char[512];
    private int charsUsed = 0;
    private CharSlice slice = new CharSlice(this.buffer, 0, 0);
    private NamespaceBinding[] namespaces = new NamespaceBinding[20];
    private int namespacesUsed = 0;
    private boolean ignoreIgnorable = false;
    private boolean retainDTDAttributeTypes = false;
    private boolean suppressDTDAttributeDefaults = false;
    private boolean allowDisableOutputEscaping = false;
    private boolean escapingDisabled = false;
    private boolean afterStartTag = true;
    private HashMap<String, HashMap<Object, NodeName>> nameCache = new HashMap(10);
    private HashMap<Object, NodeName> noNamespaceNameCache = new HashMap(10);

    public void reset() {
        this.pipe = null;
        this.receiver = null;
        this.ignoreIgnorable = false;
        this.retainDTDAttributeTypes = false;
        this.charsUsed = 0;
        this.slice.setLength(0);
        this.namespacesUsed = 0;
        this.locator = null;
        this.allowDisableOutputEscaping = false;
        this.escapingDisabled = false;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
        pipelineConfiguration.setLocationProvider((LocationProvider)this.localLocator);
        Configuration configuration = pipelineConfiguration.getConfiguration();
        this.ignoreIgnorable = pipelineConfiguration.getParseOptions().getStripSpace() != 0;
        this.retainDTDAttributeTypes = configuration.getBooleanProperty("http://saxon.sf.net/feature/retain-dtd-attribute-types");
        this.suppressDTDAttributeDefaults = !pipelineConfiguration.getParseOptions().isExpandAttributeDefaults();
        this.allowDisableOutputEscaping = (Boolean)configuration.getConfigurationProperty("http://saxon.sf.net/feature/use-pi-disable-output-escaping");
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void setIgnoreIgnorableWhitespace(boolean bl) {
        this.ignoreIgnorable = bl;
    }

    public boolean isIgnoringIgnorableWhitespace() {
        return this.ignoreIgnorable;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.charsUsed = 0;
            this.namespacesUsed = 0;
            this.pipe.setLocationProvider((LocationProvider)this.localLocator);
            this.receiver.setPipelineConfiguration(this.pipe);
            this.receiver.setSystemId(this.localLocator.getSystemId());
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.flush(true);
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (ValidationException validationException) {
            validationException.setLocator(this.locator);
            throw new SAXException((Exception)((Object)validationException));
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string.equals("xmlns")) {
            return;
        }
        if (this.namespacesUsed >= this.namespaces.length) {
            NamespaceBinding[] namespaceBindingArray = new NamespaceBinding[this.namespacesUsed * 2];
            System.arraycopy(this.namespaces, 0, namespaceBindingArray, 0, this.namespacesUsed);
            this.namespaces = namespaceBindingArray;
        }
        this.namespaces[this.namespacesUsed++] = new NamespaceBinding(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n2;
            this.flush(true);
            NodeName nodeName = this.getNodeName(string, string2, string3);
            this.receiver.startElement(nodeName, (SchemaType)Untyped.getInstance(), 0, 64);
            for (n2 = 0; n2 < this.namespacesUsed; ++n2) {
                this.receiver.namespace(this.namespaces[n2], 0);
            }
            for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                int n3 = 64;
                String string4 = attributes.getQName(n2);
                if (string4.startsWith("xmlns") && (string4.equals("xmlns") || string4.startsWith("xmlns:")) || this.suppressDTDAttributeDefaults && attributes instanceof Attributes2 && !((Attributes2)attributes).isSpecified(string4)) continue;
                NodeName nodeName2 = this.getNodeName(attributes.getURI(n2), attributes.getLocalName(n2), attributes.getQName(n2));
                String string5 = attributes.getType(n2);
                BuiltInAtomicType builtInAtomicType = BuiltInAtomicType.UNTYPED_ATOMIC;
                if (this.retainDTDAttributeTypes) {
                    if (!string5.equals("CDATA")) {
                        if (string5.equals("ID")) {
                            builtInAtomicType = BuiltInAtomicType.ID;
                        } else if (string5.equals("IDREF")) {
                            builtInAtomicType = BuiltInAtomicType.IDREF;
                        } else if (string5.equals("IDREFS")) {
                            builtInAtomicType = BuiltInListType.IDREFS;
                        } else if (string5.equals("NMTOKEN")) {
                            builtInAtomicType = BuiltInAtomicType.NMTOKEN;
                        } else if (string5.equals("NMTOKENS")) {
                            builtInAtomicType = BuiltInListType.NMTOKENS;
                        } else if (string5.equals("ENTITY")) {
                            builtInAtomicType = BuiltInAtomicType.ENTITY;
                        } else if (string5.equals("ENTITIES")) {
                            builtInAtomicType = BuiltInListType.ENTITIES;
                        }
                    }
                } else if (string5.equals("ID")) {
                    n3 |= 0x800;
                } else if (string5.equals("IDREF")) {
                    n3 |= 0x1000;
                } else if (string5.equals("IDREFS")) {
                    n3 |= 0x1000;
                }
                this.receiver.attribute(nodeName2, (SimpleType)builtInAtomicType, (CharSequence)attributes.getValue(n2), 0, n3);
            }
            this.afterStartTag = true;
            this.receiver.startContent();
            this.namespacesUsed = 0;
        }
        catch (ValidationException validationException) {
            if (validationException.getLineNumber() == -1) {
                validationException.setLocator(this.locator);
            }
            throw new SAXException((Exception)((Object)validationException));
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    private NodeName getNodeName(String string, String string2, String string3) throws SAXException {
        NodeName nodeName;
        HashMap<Object, Object> hashMap;
        if (string3.length() == 0) {
            throw new SAXException("Saxon requires an XML parser that reports the QName of each element");
        }
        if (string2.length() == 0) {
            throw new SAXException("Parser configuration problem: namespace reporting is not enabled");
        }
        HashMap<Object, Object> hashMap2 = hashMap = string.length() == 0 ? this.noNamespaceNameCache : this.nameCache.get(string);
        if (hashMap == null) {
            hashMap = new HashMap(50);
            this.nameCache.put(string, hashMap);
            if (string.length() == 0) {
                this.noNamespaceNameCache = hashMap;
            }
        }
        if ((nodeName = hashMap.get(string3)) == null) {
            if (string.length() == 0) {
                NoNamespaceName noNamespaceName = new NoNamespaceName(string2);
                hashMap.put(string3, (NodeName)noNamespaceName);
                return noNamespaceName;
            }
            String string4 = NameChecker.getPrefix((String)string3);
            FingerprintedQName fingerprintedQName = new FingerprintedQName(string4, string, string2);
            hashMap.put(string3, fingerprintedQName);
            return fingerprintedQName;
        }
        return nodeName;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.flush(!this.afterStartTag);
            this.receiver.endElement();
        }
        catch (ValidationException validationException) {
            validationException.maybeSetLocation((SourceLocator)ExpressionLocation.makeFromSax((Locator)this.locator));
            if (!validationException.hasBeenReported()) {
                this.pipe.getErrorListener().fatalError((TransformerException)((Object)validationException));
            }
            validationException.setHasBeenReported(true);
            throw new SAXException((Exception)((Object)validationException));
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
        this.afterStartTag = false;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        while (this.charsUsed + n3 > this.buffer.length) {
            char[] cArray2 = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.charsUsed);
            this.buffer = cArray2;
            this.slice = new CharSlice(this.buffer, 0, 0);
        }
        System.arraycopy(cArray, n2, this.buffer, this.charsUsed, n3);
        this.charsUsed += n3;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (!this.ignoreIgnorable) {
            this.characters(cArray, n2, n3);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.flush(true);
            if (!this.inDTD) {
                if (string == null) {
                    this.comment(string2.toCharArray(), 0, string2.length());
                } else {
                    if (!NameChecker.isValidNCName((CharSequence)string)) {
                        throw new SAXException("Invalid processing instruction name (" + string + ')');
                    }
                    if (this.allowDisableOutputEscaping) {
                        if (string.equals("javax.xml.transform.disable-output-escaping")) {
                            this.escapingDisabled = true;
                            return;
                        }
                        if (string.equals("javax.xml.transform.enable-output-escaping")) {
                            this.escapingDisabled = false;
                            return;
                        }
                    }
                    CharSequence charSequence = string2 == null ? "" : Whitespace.removeLeadingWhitespace((CharSequence)string2);
                    this.receiver.processingInstruction(string, charSequence, 0, 0);
                }
            }
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.flush(true);
            if (!this.inDTD) {
                this.receiver.comment((CharSequence)new CharSlice(cArray, n2, n3), 0, 0);
            }
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    private void flush(boolean bl) throws XPathException {
        if (this.charsUsed > 0) {
            this.slice.setLength(this.charsUsed);
            Object object = bl ? CompressedWhitespace.compress((CharSequence)this.slice) : this.slice;
            this.receiver.characters((CharSequence)object, 0, this.escapingDisabled ? 1 : 1024);
            this.charsUsed = 0;
            this.escapingDisabled = false;
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        String string5 = string3;
        if (this.locator != null) {
            try {
                String string6;
                URI uRI = new URI(string3);
                if (!uRI.isAbsolute() && (string6 = this.locator.getSystemId()) != null) {
                    URI uRI2 = new URI(string6).resolve(string3);
                    string5 = uRI2.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                string5 = string3;
            }
        }
        try {
            this.receiver.setUnparsedEntity(string, string5, string2);
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    private class LocalLocator
    implements SourceLocationProvider {
        private LocalLocator() {
        }

        public String getSystemId() {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getSystemId();
        }

        public String getPublicId() {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getPublicId();
        }

        public int getLineNumber() {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber() {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getColumnNumber();
        }

        public int getLineNumber(int n2) {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber(int n2) {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getColumnNumber();
        }

        public String getSystemId(int n2) {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getSystemId();
        }
    }
}

