/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ContentHandlerProxyLocator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxy
implements Receiver {
    private PipelineConfiguration pipe;
    private String systemId;
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    private LocationProvider locationProvider;
    private int depth = 0;
    private boolean requireWellFormed = false;
    private boolean undeclareNamespaces = false;
    private Stack elementStack = new Stack();
    private Stack namespaceStack = new Stack();
    private ContentHandlerProxyTraceListener traceListener;
    protected AttributeCollectionImpl pendingAttributes;
    private NodeName pendingElement = null;
    private int currentLocationId;
    private static final String MARKER = "##";

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public ContentHandler getUnderlyingContentHandler() {
        return this.handler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
        this.locationProvider = pipelineConfiguration.getLocationProvider();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        if (this.systemId == null) {
            return this.locationProvider.getSystemId(this.currentLocationId);
        }
        return this.systemId;
    }

    public ContentHandlerProxyTraceListener getTraceListener() {
        if (this.traceListener == null) {
            this.traceListener = new ContentHandlerProxyTraceListener();
        }
        return this.traceListener;
    }

    public LocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public int getCurrentLocationId() {
        return this.currentLocationId;
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws XPathException {
    }

    public void setOutputProperties(Properties properties) throws XPathException {
        String string = properties.getProperty("{http://saxon.sf.net/}require-well-formed");
        if (string != null) {
            this.requireWellFormed = string.equals("yes");
        }
        if ((string = properties.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = string.equals("yes");
        }
    }

    public boolean isRequireWellFormed() {
        return this.requireWellFormed;
    }

    public void setRequireWellFormed(boolean bl) {
        this.requireWellFormed = bl;
    }

    public boolean isUndeclareNamespaces() {
        return this.undeclareNamespaces;
    }

    public void setUndeclareNamespaces(boolean bl) {
        this.undeclareNamespaces = bl;
    }

    public void open() throws XPathException {
        this.pendingAttributes = new AttributeCollectionImpl(this.getPipelineConfiguration().getConfiguration());
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandlerProxy.open(): no underlying handler provided");
        }
        try {
            this.locationProvider = this.getPipelineConfiguration().getLocationProvider();
            this.pendingAttributes.setLocationProvider(this.locationProvider);
            ContentHandlerProxyLocator contentHandlerProxyLocator = new ContentHandlerProxyLocator(this);
            this.handler.setDocumentLocator((Locator)contentHandlerProxyLocator);
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        this.depth = 0;
    }

    public void close() throws XPathException {
        if (this.depth >= 0) {
            try {
                this.handler.endDocument();
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
        this.depth = -1;
    }

    public void startDocument(int n2) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(NodeName nodeName, SchemaType schemaType, int n2, int n3) throws XPathException {
        ++this.depth;
        if (this.depth <= 0 && this.requireWellFormed) {
            this.notifyNotWellFormed();
        }
        this.pendingElement = nodeName;
        this.currentLocationId = n2;
        this.namespaceStack.push(MARKER);
    }

    public void namespace(NamespaceBinding namespaceBinding, int n2) throws XPathException {
        String string = namespaceBinding.getPrefix();
        if (string.equals("xml")) {
            return;
        }
        String string2 = namespaceBinding.getURI();
        if (!this.undeclareNamespaces && string2.length() == 0 && string.length() != 0) {
            return;
        }
        try {
            this.handler.startPrefixMapping(string, string2);
            this.namespaceStack.push(string);
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, int n2, int n3) throws XPathException {
        int n4 = this.pendingAttributes.findByNodeName(nodeName);
        if (n4 < 0) {
            this.pendingAttributes.addAttribute(nodeName, simpleType, ((Object)charSequence).toString(), n2, n3);
        } else {
            this.pendingAttributes.setAttribute(n4, nodeName, simpleType, ((Object)charSequence).toString(), n2, n3);
        }
    }

    public void startContent() throws XPathException {
        try {
            if (this.depth > 0 || !this.requireWellFormed) {
                String string = this.pendingElement.getURI();
                String string2 = this.pendingElement.getLocalPart();
                String string3 = this.pendingElement.getDisplayName();
                this.handler.startElement(string, string2, string3, (Attributes)this.pendingAttributes);
                this.elementStack.push(string);
                this.elementStack.push(string2);
                this.elementStack.push(string3);
                this.pendingAttributes.clear();
                this.pendingElement = null;
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void endElement() throws XPathException {
        String string;
        if (this.depth > 0) {
            try {
                string = (String)this.elementStack.pop();
                String string2 = (String)this.elementStack.pop();
                String string3 = (String)this.elementStack.pop();
                this.handler.endElement(string3, string2, string);
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
        while (!(string = (String)this.namespaceStack.pop()).equals(MARKER)) {
            try {
                this.handler.endPrefixMapping(string);
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        boolean bl;
        this.currentLocationId = n2;
        boolean bl2 = bl = (n3 & 1) != 0;
        if (bl) {
            this.setEscaping(false);
        }
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                if (!Whitespace.isWhite((CharSequence)charSequence)) {
                    this.notifyNotWellFormed();
                }
            } else {
                this.handler.characters(((Object)charSequence).toString().toCharArray(), 0, charSequence.length());
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        if (bl) {
            this.setEscaping(true);
        }
    }

    protected void notifyNotWellFormed() throws XPathException {
        XPathException xPathException = new XPathException("The result tree cannot be supplied to the ContentHandler because it is not well-formed XML");
        xPathException.setErrorCode("SXCH0002");
        throw xPathException;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        this.currentLocationId = n2;
        try {
            this.handler.processingInstruction(string, ((Object)charSequence).toString());
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.currentLocationId = n2;
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(((Object)charSequence).toString().toCharArray(), 0, charSequence.length());
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    private void setEscaping(boolean bl) {
        try {
            this.handler.processingInstruction(bl ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException sAXException) {
            throw new AssertionError((Object)sAXException);
        }
    }

    private void handleSAXException(SAXException sAXException) throws XPathException {
        Exception exception = sAXException.getException();
        if (exception instanceof XPathException) {
            throw (XPathException)((Object)exception);
        }
        if (exception instanceof SchemaException) {
            throw new XPathException((Throwable)exception);
        }
        XPathException xPathException = new XPathException((Throwable)sAXException);
        xPathException.setErrorCode("SXCH0003");
        throw xPathException;
    }

    public static class ContentHandlerProxyTraceListener
    implements TraceListener {
        private Stack contextItemStack;

        public void setOutputDestination(Logger logger) {
        }

        public Stack getContextItemStack() {
            return this.contextItemStack;
        }

        public void open(Controller controller) {
            this.contextItemStack = new Stack();
        }

        public void close() {
            this.contextItemStack = null;
        }

        public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        }

        public void leave(InstructionInfo instructionInfo) {
        }

        public void startCurrentItem(Item item) {
            if (this.contextItemStack == null) {
                this.contextItemStack = new Stack();
            }
            this.contextItemStack.push(item);
        }

        public void endCurrentItem(Item item) {
            this.contextItemStack.pop();
        }
    }
}

