/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.NamespaceSupport;

public class SaxonDOMSender
implements SourceLocationProvider {
    private Receiver receiver;
    protected Node root;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private HashMap<String, String> nsDeclarations = new HashMap(10);
    protected String systemId;

    public SaxonDOMSender(Node node, Receiver receiver) {
        if (node == null) {
            throw new NullPointerException("startNode");
        }
        if (receiver == null) {
            throw new NullPointerException("receiver");
        }
        this.root = node;
        this.receiver = receiver;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void send() throws XPathException {
        this.receiver.setSystemId(this.systemId);
        this.receiver.getPipelineConfiguration().setLocationProvider((LocationProvider)this);
        this.receiver.open();
        switch (this.root.getNodeType()) {
            case 9: 
            case 11: {
                this.receiver.startDocument(0);
                this.walkNode(this.root);
                this.receiver.endDocument();
                break;
            }
            case 1: {
                this.sendElement((Element)this.root);
                break;
            }
            case 3: 
            case 4: {
                this.receiver.characters((CharSequence)((CharacterData)this.root).getData(), 0, 0);
                break;
            }
            case 8: {
                this.receiver.comment((CharSequence)((Comment)this.root).getData(), 0, 0);
                break;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstruction)this.root).getTarget(), (CharSequence)((ProcessingInstruction)this.root).getData(), 0, 0);
                break;
            }
            default: {
                throw new IllegalStateException("DOMSender: unsupported kind of start node (" + this.root.getNodeType() + ")");
            }
        }
        this.receiver.close();
    }

    private void sendElement(Element element) throws XPathException {
        Element element2 = element;
        boolean bl = this.gatherNamespaces(element2, false);
        while (true) {
            this.gatherNamespaces(element2, true);
            Node node = element2.getParentNode();
            if (node == null || node.getNodeType() != 1) break;
            element2 = (Element)node;
        }
        this.outputElement(element, bl);
    }

    private void walkNode(Node node) throws XPathException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            block9: for (int i2 = 0; i2 < n2; ++i2) {
                Node node2 = nodeList.item(i2);
                switch (node2.getNodeType()) {
                    case 9: 
                    case 11: {
                        continue block9;
                    }
                    case 1: {
                        Element element = (Element)node2;
                        boolean bl = this.gatherNamespaces(element, false);
                        this.outputElement(element, bl);
                        this.nsSupport.popContext();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 7: {
                        this.receiver.processingInstruction(((ProcessingInstruction)node2).getTarget(), (CharSequence)((ProcessingInstruction)node2).getData(), 0, 0);
                        continue block9;
                    }
                    case 8: {
                        String string = ((Comment)node2).getData();
                        if (string == null) continue block9;
                        this.receiver.comment((CharSequence)string, 0, 0);
                        continue block9;
                    }
                    case 3: 
                    case 4: {
                        String string = ((CharacterData)node2).getData();
                        if (string == null) continue block9;
                        this.receiver.characters((CharSequence)string, 0, 0);
                        continue block9;
                    }
                    case 5: {
                        this.walkNode(node2);
                        continue block9;
                    }
                }
            }
        }
    }

    protected void outputElement(Element element, boolean bl) throws XPathException {
        String[] stringArray = this.nsSupport.processName(element.getTagName(), this.elparts, false);
        if (stringArray == null) {
            throw new XPathException("Undeclared namespace in " + element.getTagName());
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = NameChecker.getPrefix((String)stringArray[2]);
        this.receiver.startElement((NodeName)new FingerprintedQName(string3, string, string2), (SchemaType)Untyped.getInstance(), 0, 0);
        for (Map.Entry<String, String> entry : this.nsDeclarations.entrySet()) {
            this.receiver.namespace(new NamespaceBinding(entry.getKey(), entry.getValue()), 0);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                String string4 = attr.getName();
                if (bl && (string4.equals("xmlns") || string4.startsWith("xmlns:"))) continue;
                String[] stringArray2 = this.nsSupport.processName(string4, this.parts, true);
                if (stringArray2 == null) {
                    throw new XPathException("Undeclared namespace in " + string4);
                }
                String string5 = stringArray2[0];
                String string6 = stringArray2[1];
                String string7 = NameChecker.getPrefix((String)stringArray2[2]);
                FingerprintedQName fingerprintedQName = new FingerprintedQName(string7, string5, string6);
                this.receiver.attribute((NodeName)fingerprintedQName, (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, (CharSequence)attr.getValue(), 0, 0);
            }
        }
        this.receiver.startContent();
        this.walkNode(element);
        this.receiver.endElement();
    }

    private boolean gatherNamespaces(Element element, boolean bl) {
        Object object;
        boolean bl2 = false;
        if (!bl) {
            this.nsSupport.pushContext();
            this.nsDeclarations.clear();
        }
        try {
            object = element.getPrefix();
            String string = element.getNamespaceURI();
            if (object == null) {
                object = "";
            }
            if (string == null) {
                string = "";
            }
            if (this.nsDeclarations.get(object) == null) {
                this.nsSupport.declarePrefix((String)object, string);
                this.nsDeclarations.put((String)object, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = element.getAttributes();
        if (object == null) {
            return false;
        }
        int n2 = object.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2;
            Attr attr = (Attr)object.item(i2);
            String string3 = attr.getName();
            boolean bl3 = string3.startsWith("xmlns");
            if (bl3 && string3.equals("xmlns")) {
                bl2 = true;
                string2 = attr.getValue();
                if (this.nsDeclarations.get("") != null && (bl || this.nsDeclarations.get("").equals(string2))) continue;
                this.nsSupport.declarePrefix("", string2);
                this.nsDeclarations.put("", string2);
                continue;
            }
            if (bl3 && string3.startsWith("xmlns:")) {
                bl2 = true;
                string2 = string3.substring(6);
                if (this.nsDeclarations.get(string2) != null) continue;
                string = attr.getValue();
                this.nsSupport.declarePrefix(string2, string);
                this.nsDeclarations.put(string2, string);
                continue;
            }
            if (string3.indexOf(58) < 0) continue;
            try {
                string2 = attr.getPrefix();
                string = attr.getNamespaceURI();
                if (this.nsDeclarations.get(string2) != null) continue;
                this.nsSupport.declarePrefix(string2, string);
                this.nsDeclarations.put(string2, string);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl2;
    }

    public String getSystemId(int n2) {
        return this.systemId;
    }

    public int getLineNumber(int n2) {
        return -1;
    }

    public int getColumnNumber(int n2) {
        return -1;
    }
}

