/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Transmitter;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.ImplicitResultChecker;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SingletonClosure;
import org.xml.sax.SAXParseException;

public class Controller {
    private Configuration config;
    private Executable executable;
    private Item initialContextItem;
    private Item contextForGlobalVariables;
    private Bindery bindery;
    private String messageReceiverClassName;
    private Receiver messageReceiver;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private Logger traceFunctionDestination;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Receiver principalResult;
    private String principalResultURI;
    private String cookedPrincipalResultURI;
    private boolean thereHasBeenAnExplicitResultDocument;
    private OutputURIResolver outputURIResolver;
    private UnparsedTextURIResolver unparsedTextResolver;
    private CollectionURIResolver collectionURIResolver;
    private String defaultCollectionURI;
    private UnfailingErrorListener errorListener;
    private int recoveryPolicy;
    private TreeModel treeModel = TreeModel.TINY_TREE;
    private Template initialTemplate = null;
    private HashSet<DocumentURI> allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private HashMap<String, Object> userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private Mode initialMode = null;
    private FunctionItem initialFunction = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private PathMap pathMap = null;
    private int validationMode;
    private boolean inUse = false;
    private boolean stripSourceTrees = true;
    private Map<StructuredQName, Sequence> initialTemplateParams;
    private Map<StructuredQName, Sequence> initialTemplateTunnelParams;
    public static final String ANONYMOUS_PRINCIPAL_OUTPUT_URI = "dummy:/anonymous/principal/result";

    public Controller(Configuration configuration) {
        this.config = configuration;
        this.executable = new Executable(configuration);
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration configuration, Executable executable) {
        this.config = configuration;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public void reset() {
        Logger logger;
        this.bindery = new Bindery();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.unparsedTextResolver = new StandardUnparsedTextResolver();
        this.setErrorListener((ErrorListener)this.config.getErrorListener());
        this.recoveryPolicy = this.config.getRecoveryPolicy();
        this.validationMode = this.config.getSchemaValidationMode();
        if (this.errorListener instanceof StandardErrorListener) {
            logger = ((StandardErrorListener)this.errorListener).getLogger();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setLogger(logger);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.recoveryPolicy);
        }
        this.traceListener = null;
        this.traceFunctionDestination = this.config.getLogger();
        try {
            logger = this.config.makeTraceListener();
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
        if (logger != null) {
            this.addTraceListener((TraceListener)logger);
        }
        this.setModel(this.config.getParseOptions().getModel());
        this.contextForGlobalVariables = null;
        this.messageReceiver = null;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialContextItem = null;
        this.initialMode = null;
        this.initialTemplate = null;
        this.clearPerTransformationData();
    }

    private void clearPerTransformationData() {
        this.userDataTable = new HashMap(20);
        this.principalResult = null;
        this.allOutputDestinations = null;
        this.thereHasBeenAnExplicitResultDocument = false;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.tracingPaused = false;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(StructuredQName structuredQName) throws XPathException {
        if (structuredQName == null) {
            this.initialMode = null;
        } else {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().getMode(structuredQName, false);
            if (this.initialMode == null) {
                throw new XPathException("Requested initial mode " + structuredQName + " is not defined in the stylesheet", "XTDE0045");
            }
        }
    }

    public StructuredQName getInitialModeName() {
        return this.initialMode == null ? null : this.initialMode.getModeName();
    }

    public Mode getInitialMode() {
        if (this.initialMode == null) {
            this.initialMode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
        }
        return this.initialMode;
    }

    public Sequence getParameter(StructuredQName structuredQName) {
        return this.getBindery().getSuppliedParameters().get(structuredQName);
    }

    public void setBaseOutputURI(String string) {
        this.principalResultURI = string;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public String getCookedBaseOutputURI() {
        if (this.cookedPrincipalResultURI == null) {
            String string = this.getBaseOutputURI();
            if (string == null && this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                string = new File(System.getProperty("user.dir")).toURI().toString();
            }
            if (string != null) {
                string = ((Object)EscapeURI.iriToUri((CharSequence)string)).toString();
            }
            this.cookedPrincipalResultURI = string;
        }
        return this.cookedPrincipalResultURI;
    }

    public Receiver getPrincipalResult() {
        return this.principalResult;
    }

    public synchronized boolean checkUniqueOutputDestination(DocumentURI documentURI) {
        if (documentURI == null) {
            return true;
        }
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        return !this.allOutputDestinations.contains(documentURI);
    }

    public void addUnavailableOutputDestination(DocumentURI documentURI) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        this.allOutputDestinations.add(documentURI);
    }

    public void removeUnavailableOutputDestination(DocumentURI documentURI) {
        if (this.allOutputDestinations != null) {
            this.allOutputDestinations.remove(documentURI);
        }
    }

    public boolean isUnusedOutputDestination(DocumentURI documentURI) {
        return this.allOutputDestinations == null || !this.allOutputDestinations.contains(documentURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImplicitResultTree() throws XPathException {
        String string = this.principalResultURI;
        if (string == null) {
            string = ANONYMOUS_PRINCIPAL_OUTPUT_URI;
        }
        DocumentURI documentURI = new DocumentURI(string);
        Controller controller = this;
        synchronized (controller) {
            if (!this.checkUniqueOutputDestination(documentURI)) {
                XPathException xPathException = new XPathException("Cannot write an implicit result document if an explicit result document has been written to the same URI: " + (string.equals(ANONYMOUS_PRINCIPAL_OUTPUT_URI) ? "(no URI supplied)" : string));
                xPathException.setErrorCode("XTDE1490");
                throw xPathException;
            }
            this.addUnavailableOutputDestination(documentURI);
        }
    }

    public void setThereHasBeenAnExplicitResultDocument() {
        this.thereHasBeenAnExplicitResultDocument = true;
    }

    public boolean hasThereBeenAnExplicitResultDocument() {
        return this.thereHasBeenAnExplicitResultDocument;
    }

    public synchronized SequenceOutputter allocateSequenceOutputter(int n2) {
        PipelineConfiguration pipelineConfiguration = this.makePipelineConfiguration();
        return new SequenceOutputter(pipelineConfiguration, this, n2);
    }

    public void reuseSequenceOutputter(SequenceOutputter sequenceOutputter) {
    }

    public void setInitialTemplate(StructuredQName structuredQName) throws XPathException {
        if (structuredQName == null) {
            this.initialTemplate = null;
            return;
        }
        Template template = ((PreparedStylesheet)this.getExecutable()).getNamedTemplate(structuredQName);
        if (template == null) {
            XPathException xPathException = new XPathException("The requested initial template " + structuredQName.getDisplayName() + " does not exist");
            xPathException.setErrorCode("XTDE0040");
            this.reportFatalError(xPathException);
            throw xPathException;
        }
        this.initialTemplate = template;
    }

    public StructuredQName getInitialTemplate() {
        if (this.initialTemplate == null) {
            return null;
        }
        return this.initialTemplate.getTemplateName();
    }

    public void setInitialTemplateParameters(Map<StructuredQName, Sequence> map, boolean bl) throws XPathException {
        if (!map.isEmpty() && !this.executable.isAllowXPath30()) {
            throw new XPathException("Cannot supply initial template parameters when running as XSLT 2.0", "SXST0070");
        }
        if (bl) {
            this.initialTemplateTunnelParams = map;
        } else {
            this.initialTemplateParams = map;
        }
    }

    public Map<StructuredQName, Sequence> getInitialTemplateParameters(boolean bl) {
        return bl ? this.initialTemplateTunnelParams : this.initialTemplateParams;
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipelineConfiguration = this.config.makePipelineConfiguration();
        pipelineConfiguration.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipelineConfiguration.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipelineConfiguration.setLocationProvider((LocationProvider)executable.getLocationMap());
            pipelineConfiguration.setHostLanguage(executable.getHostLanguage());
        }
        return pipelineConfiguration;
    }

    public void setMessageReceiverClassName(String string) {
        this.messageReceiverClassName = string;
    }

    private Receiver makeMessageReceiver() throws XPathException {
        Object object = this.config.getInstance(this.messageReceiverClassName, null);
        if (!(object instanceof Receiver)) {
            throw new XPathException(this.messageReceiverClassName + " is not a Receiver");
        }
        ((Receiver)object).setPipelineConfiguration(this.makePipelineConfiguration());
        this.setMessageEmitter((Receiver)object);
        return (Receiver)object;
    }

    public void setMessageEmitter(Receiver receiver) {
        this.messageReceiver = receiver;
        receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        if (receiver instanceof Emitter && ((Emitter)receiver).getOutputProperties() == null) {
            try {
                Properties properties = new Properties();
                properties.setProperty("method", "xml");
                properties.setProperty("indent", "yes");
                properties.setProperty("omit-xml-declaration", "yes");
                ((Emitter)receiver).setOutputProperties(properties);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public Receiver getMessageEmitter() {
        return this.messageReceiver;
    }

    public void setRecoveryPolicy(int n2) {
        this.recoveryPolicy = n2;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(n2);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener instanceof UnfailingErrorListener ? (UnfailingErrorListener)errorListener : new DelegatingErrorListener(errorListener);
        this.config.setErrorListener(errorListener);
    }

    public UnfailingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException xPathException) throws XPathException {
        if (this.executable.getHostLanguage() == 51 || this.recoveryPolicy == 2) {
            throw xPathException;
        }
        if (this.executable.getHostLanguage() == 50 && this.executable.isAllowXPath30()) {
            this.errorListener.warning((TransformerException)((Object)xPathException));
        } else {
            this.errorListener.error((TransformerException)((Object)xPathException));
        }
    }

    public void reportFatalError(XPathException xPathException) {
        if (!xPathException.hasBeenReported()) {
            this.getErrorListener().fatalError((TransformerException)((Object)xPathException));
            xPathException.setHasBeenReported(true);
        }
    }

    public void warning(String string, String string2) {
        this.getErrorListener().warning((TransformerException)((Object)new XPathException(string, string2)));
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool.discardIndexes(this.getKeyManager());
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setInitialContextItem(Item item) {
        if (item instanceof NodeInfo) {
            item = this.prepareInputTree((Source)((NodeInfo)item));
        }
        this.initialContextItem = item;
        this.contextForGlobalVariables = item;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public Item getInitialContextItem() {
        return this.initialContextItem;
    }

    public Item getContextForGlobalVariables() {
        return this.contextForGlobalVariables;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userURIResolver = uRIResolver;
        if (uRIResolver instanceof StandardURIResolver) {
            ((StandardURIResolver)uRIResolver).setConfiguration(this.getConfiguration());
        }
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver == null ? this.config.getOutputURIResolver() : outputURIResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.unparsedTextResolver = unparsedTextURIResolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver collectionURIResolver) {
        this.collectionURIResolver = collectionURIResolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionURIResolver == null ? this.getConfiguration().getCollectionURIResolver() : this.collectionURIResolver;
    }

    public void setDefaultCollection(String string) {
        this.defaultCollectionURI = string;
    }

    public String getDefaultCollection() {
        return this.defaultCollectionURI == null ? this.getConfiguration().getDefaultCollection() : this.defaultCollectionURI;
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int n2) {
        this.validationMode = n2;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    @Deprecated
    public void setTreeModel(int n2) {
        this.treeModel = TreeModel.getTreeModel((int)n2);
    }

    @Deprecated
    public int getTreeModel() {
        return this.treeModel.getSymbolicValue();
    }

    public void setModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public Builder makeBuilder() {
        Builder builder = this.treeModel.makeBuilder(this.makePipelineConfiguration());
        builder.setTiming(this.config.isTiming());
        builder.setLineNumbering(this.config.isLineNumbering());
        return builder;
    }

    public void setStripSourceTrees(boolean bl) {
        this.stripSourceTrees = bl;
    }

    public boolean isStripSourceTree() {
        return this.stripSourceTrees;
    }

    public Stripper makeStripper(Receiver receiver) {
        if (receiver == null) {
            receiver = new Sink(this.makePipelineConfiguration());
        }
        return new Stripper(this.getSpaceStrippingRule(), receiver);
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        if (this.config.isStripsAllWhiteSpace()) {
            return AllElementsSpaceStrippingRule.getInstance();
        }
        if (this.executable == null) {
            return NoElementsSpaceStrippingRule.getInstance();
        }
        return this.executable.getStripperRules();
    }

    public void registerDocument(DocumentInfo documentInfo, DocumentURI documentURI) throws XPathException {
        if (documentInfo == null) {
            throw new NullPointerException("null");
        }
        if (!this.getExecutable().isSchemaAware() && !Untyped.getInstance().equals(documentInfo.getSchemaType())) {
            String string = this.getExecutable().getHostLanguage() == 50 ? "transformation" : "query";
            throw new XPathException("The " + string + " is not schema-aware, so the source document must be untyped");
        }
        if (documentURI != null) {
            this.sourceDocumentPool.add(documentInfo, documentURI);
        }
    }

    public RuleManager getRuleManager() {
        Executable executable = this.getExecutable();
        return executable instanceof PreparedStylesheet ? ((PreparedStylesheet)this.getExecutable()).getRuleManager() : null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean bl) {
        this.tracingPaused = bl;
    }

    public void addTraceListener(TraceListener traceListener) {
        if (traceListener != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, traceListener);
        }
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, traceListener);
    }

    public void setTraceFunctionDestination(Logger logger) {
        this.traceFunctionDestination = logger;
    }

    public Logger getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void initializeController(GlobalParameterSet globalParameterSet) throws XPathException {
        if (this.traceListener != null) {
            this.traceListener.open(this);
        }
        this.bindery = new Bindery();
        this.bindery.allocateGlobals(this.executable.getGlobalVariableMap());
        this.executable.checkAllRequiredParamsArePresent(globalParameterSet);
        this.bindery.defineGlobalParameters(globalParameterSet);
    }

    public Object getUserData(Object object, String string) {
        String string2 = object.hashCode() + " " + string;
        return this.userDataTable.get(string2);
    }

    public void setUserData(Object object, String string, Object object2) {
        String string2 = object.hashCode() + " " + string;
        if (object2 == null) {
            this.userDataTable.remove(string2);
        } else {
            this.userDataTable.put(string2, object2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(Source source, Receiver receiver) throws XPathException {
        if (this.inUse) {
            throw new IllegalStateException("The Transformer is being used recursively or concurrently. This is not permitted.");
        }
        this.inUse = true;
        this.clearPerTransformationData();
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        if (source instanceof SAXSource && this.config.getBooleanProperty("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            ((SAXSource)source).setXMLReader(null);
        }
        boolean bl = false;
        try {
            Object object;
            NodeInfo nodeInfo = null;
            boolean bl2 = true;
            boolean bl3 = false;
            int n2 = this.getSchemaValidationMode();
            Object object2 = source;
            if (source instanceof AugmentedSource) {
                object = ((AugmentedSource)source).getWrapDocument();
                if (object != null) {
                    bl2 = (Boolean)object;
                }
                bl = ((AugmentedSource)source).isPleaseCloseAfterUse();
                int n3 = ((AugmentedSource)source).getSchemaValidation();
                if (n3 != 0) {
                    n2 = n3;
                }
                if (n2 == 1 || n2 == 2) {
                    bl2 = false;
                }
                object2 = ((AugmentedSource)source).getContainedSource();
            }
            if ((object = this.config.getSourceResolver().resolveSource((Source)object2, this.config)) != null) {
                object2 = object;
            }
            if (bl2 && (object2 instanceof NodeInfo || object2 instanceof DOMSource)) {
                nodeInfo = this.prepareInputTree((Source)object2);
                String string = object2.getSystemId();
                DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
                if (documentInfo != null) {
                    this.registerDocument(nodeInfo.getDocumentRoot(), string == null ? null : new DocumentURI(string));
                }
            } else if (source == null) {
                if (this.initialMode != null) {
                    throw new XPathException("Either a source document or initial match selection must be specified for an initial mode", "XTDE0044");
                }
                if (this.initialTemplate == null && this.initialFunction == null) {
                    throw new XPathException("Either a source document, an initial template or an initial function must be specified");
                }
            } else {
                Mode mode = this.initialMode;
                if (mode == null) {
                    mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
                }
                if (mode == null || this.initialMode != null && mode.isEmpty()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
                }
                if (mode.isDeclaredStreamable()) {
                    if (!(source instanceof StreamSource) && !(source instanceof SAXSource) && !(source instanceof Transmitter)) throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a SAXSource or StreamSource", "SXST0061");
                    bl3 = true;
                    this.transformStream(source, mode, receiver);
                } else {
                    Builder builder = this.makeBuilder();
                    if (builder instanceof TinyBuilder) {
                        ((TinyBuilder)builder).setStatistics(Statistics.SOURCE_DOCUMENT_STATISTICS);
                    }
                    Builder builder2 = builder;
                    if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace() || n2 == 1 || n2 == 2) {
                        builder2 = this.makeStripper((Receiver)builder);
                    }
                    if (this.executable.stripsInputTypeAnnotations()) {
                        builder2 = this.config.getAnnotationStripper((Receiver)builder2);
                    }
                    PipelineConfiguration pipelineConfiguration = builder.getPipelineConfiguration();
                    pipelineConfiguration.getParseOptions().setSchemaValidationMode(n2);
                    builder2.setPipelineConfiguration(pipelineConfiguration);
                    Sender.send((Source)source, (Receiver)builder2, null);
                    if (bl) {
                        ((AugmentedSource)source).close();
                    }
                    DocumentInfo documentInfo = (DocumentInfo)builder.getCurrentRoot();
                    builder.reset();
                    if (source.getSystemId() != null) {
                        this.registerDocument(documentInfo, new DocumentURI(source.getSystemId()));
                    }
                    nodeInfo = documentInfo;
                }
            }
            if (bl3) return;
            this.transformDocument(nodeInfo, receiver);
            return;
        }
        catch (TerminationException terminationException) {
            if (terminationException.hasBeenReported()) throw terminationException;
            this.reportFatalError((XPathException)((Object)terminationException));
            throw terminationException;
        }
        catch (XPathException xPathException) {
            Throwable throwable = xPathException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if (!((throwable = sAXParseException.getException()) instanceof RuntimeException)) throw xPathException;
                this.reportFatalError(xPathException);
                throw xPathException;
            } else {
                this.reportFatalError(xPathException);
            }
            throw xPathException;
        }
        finally {
            this.inUse = false;
            if (bl && source instanceof AugmentedSource) {
                ((AugmentedSource)source).close();
            }
            if (this.messageReceiver != null) {
                this.messageReceiver.close();
            }
        }
    }

    public void applyTemplates(Sequence sequence, Receiver receiver) throws XPathException {
        if (this.inUse) {
            throw new IllegalStateException("The Transformer is being used recursively or concurrently. This is not permitted.");
        }
        this.inUse = true;
        this.clearPerTransformationData();
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        boolean bl = false;
        try {
            Object object;
            Mode mode = this.initialMode;
            if (mode == null) {
                mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
            }
            if (mode == null || this.initialMode != null && mode.isEmpty()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
            }
            if (mode.isDeclaredStreamable()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a StreamSource or SAXSource");
            }
            this.openMessageEmitter();
            boolean bl2 = false;
            this.principalResult = receiver;
            if (this.principalResultURI == null) {
                this.principalResultURI = receiver.getSystemId();
            }
            ParameterSet parameterSet = null;
            if (this.initialTemplateParams != null) {
                parameterSet = new ParameterSet(this.initialTemplateParams);
            }
            ParameterSet parameterSet2 = null;
            if (this.initialTemplateTunnelParams != null) {
                parameterSet2 = new ParameterSet(this.initialTemplateTunnelParams);
            }
            XPathContextMajor xPathContextMajor = this.newXPathContext();
            xPathContextMajor.createThreadManager();
            xPathContextMajor.setOriginatingConstructType(2000);
            SequenceIterator sequenceIterator = sequence.iterate();
            xPathContextMajor.setCurrentIterator((FocusIterator)new FocusTrackingIterator(sequenceIterator));
            while ((object = sequenceIterator.next()) != null) {
                if (!(object instanceof NodeInfo)) continue;
                NodeInfo nodeInfo = (NodeInfo)object;
                if (nodeInfo.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!nodeInfo.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (!(nodeInfo instanceof DocumentInfo) || !((DocumentInfo)nodeInfo).isTyped() || this.executable.isSchemaAware()) continue;
                throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
            }
            if (this.stripSourceTrees && this.executable.stripsWhitespace()) {
                object = new ItemMappingFunction<Item, Item>(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof DocumentInfo) {
                            return new SpaceStrippedDocument((DocumentInfo)item, Controller.this.executable.getStripperRules());
                        }
                        return item;
                    }
                };
                sequenceIterator = new ItemMappingIterator(sequenceIterator, (ItemMappingFunction)object);
            }
            if (this.executable.stripsInputTypeAnnotations()) {
                object = new ItemMappingFunction<Item, Item>(){

                    public Item mapItem(Item item) throws XPathException {
                        if (item instanceof DocumentInfo) {
                            return new TypeStrippedDocument((DocumentInfo)item);
                        }
                        return item;
                    }
                };
                sequenceIterator = new ItemMappingIterator(sequenceIterator, (ItemMappingFunction)object);
            }
            receiver = this.openResult(receiver, xPathContextMajor);
            xPathContextMajor.setCurrentIterator((FocusIterator)new FocusTrackingIterator(sequenceIterator.getAnother()));
            xPathContextMajor.setCurrentMode(mode);
            for (object = mode.applyTemplates(parameterSet, parameterSet2, xPathContextMajor, 0); object != null; object = object.processLeavingTail()) {
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            xPathContextMajor.notifyChildThreads();
            this.closeResult((Result)receiver, bl2, xPathContextMajor);
        }
        catch (TerminationException terminationException) {
            if (!terminationException.hasBeenReported()) {
                this.reportFatalError((XPathException)((Object)terminationException));
            }
            throw terminationException;
        }
        catch (XPathException xPathException) {
            Throwable throwable = xPathException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if ((throwable = sAXParseException.getException()) instanceof RuntimeException) {
                    this.reportFatalError(xPathException);
                }
            } else {
                this.reportFatalError(xPathException);
            }
            throw xPathException;
        }
        finally {
            this.inUse = false;
            this.closeMessageEmitter();
            if (bl && sequence instanceof AugmentedSource) {
                ((AugmentedSource)sequence).close();
            }
            this.principalResultURI = null;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        SpaceStrippedDocument spaceStrippedDocument;
        DocumentInfo documentInfo;
        NodeInfo nodeInfo = this.getConfiguration().unravel(source);
        if (this.stripSourceTrees && this.executable.stripsWhitespace()) {
            documentInfo = nodeInfo.getDocumentRoot();
            spaceStrippedDocument = new SpaceStrippedDocument(documentInfo, this.getSpaceStrippingRule());
            nodeInfo = spaceStrippedDocument.wrap(nodeInfo);
        }
        if (this.executable.stripsInputTypeAnnotations()) {
            documentInfo = nodeInfo.getDocumentRoot();
            if (!Untyped.getInstance().equals(documentInfo.getSchemaType())) {
                spaceStrippedDocument = new TypeStrippedDocument(documentInfo);
                nodeInfo = spaceStrippedDocument.wrap(nodeInfo);
            }
        }
        return nodeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformDocument(NodeInfo nodeInfo, Receiver receiver) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean bl = false;
        try {
            ParameterSet parameterSet;
            ParameterSet parameterSet2;
            this.principalResult = receiver;
            if (this.principalResultURI == null) {
                this.principalResultURI = receiver.getSystemId();
            }
            XPathContextMajor xPathContextMajor = this.newXPathContext();
            xPathContextMajor.createThreadManager();
            xPathContextMajor.setOriginatingConstructType(2000);
            if (nodeInfo != null) {
                this.initialContextItem = nodeInfo;
                this.contextForGlobalVariables = nodeInfo.getRoot();
                if (nodeInfo.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!nodeInfo.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (nodeInfo instanceof DocumentInfo && ((DocumentInfo)nodeInfo).isTyped() && !this.executable.isSchemaAware()) {
                    throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                }
                parameterSet2 = SingletonIterator.makeIterator((Item)nodeInfo);
                parameterSet = new FocusTrackingIterator((SequenceIterator)parameterSet2);
                if (this.initialTemplate != null) {
                    parameterSet.next();
                }
                xPathContextMajor.setCurrentIterator((FocusIterator)parameterSet);
            }
            if (this.traceListener != null) {
                this.preEvaluateGlobals((XPathContext)xPathContextMajor);
            }
            receiver = this.openResult(receiver, xPathContextMajor);
            parameterSet2 = null;
            if (this.initialTemplateParams != null) {
                parameterSet2 = new ParameterSet(this.initialTemplateParams);
            }
            parameterSet = null;
            if (this.initialTemplateTunnelParams != null) {
                parameterSet = new ParameterSet(this.initialTemplateTunnelParams);
            }
            if (this.initialTemplate == null) {
                TailCall tailCall;
                this.initialContextItem = nodeInfo;
                Mode mode = this.initialMode;
                if (mode == null) {
                    mode = ((PreparedStylesheet)this.executable).getRuleManager().getUnnamedMode();
                }
                if (this.initialMode != null && mode.isEmpty()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " does not exist", "XTDE0045");
                }
                if (mode.isDeclaredStreamable()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getModeName().getDisplayName()) + " is streamable: must supply a StreamSource or SAXSource");
                }
                if (nodeInfo instanceof DocumentInfo && !this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/suppressXsltNamespaceCheck") && (tailCall = nodeInfo.iterateAxis((byte)3, (NodeTest)NodeKindTest.ELEMENT).next()) != null) {
                    String string = tailCall.getURI();
                    Set set = mode.getExplicitNamespaces(this.getConfiguration().getNamePool());
                    if (!set.isEmpty() && !set.contains(string)) {
                        Object object;
                        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)4, (NodeTest)NodeKindTest.ELEMENT);
                        boolean bl2 = false;
                        while ((object = axisIterator.next()) != null) {
                            String string2 = object.getURI();
                            if (!set.contains(string2)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            object = "(Use --suppressXsltNamespaceCheck:on to avoid this warning)";
                            if (set.size() == 1 && set.contains("")) {
                                this.warning("The source document is in namespace " + string + ", but all the template rules match elements in no namespace " + (String)object, "SXXP0005");
                            } else if (string.equals("")) {
                                this.warning("The source document is in no namespace, but the template rules all expect elements in a namespace " + (String)object, "SXXP0005");
                            } else {
                                this.warning("The source document is in namespace " + string + ", but none of the template rules match elements in this namespace " + (String)object, "SXXP0005");
                            }
                        }
                    }
                }
                xPathContextMajor.setCurrentMode(mode);
                for (tailCall = mode.applyTemplates(parameterSet2, parameterSet, xPathContextMajor, 0); tailCall != null; tailCall = tailCall.processLeavingTail()) {
                }
            } else {
                Template template = this.initialTemplate;
                XPathContextMajor xPathContextMajor2 = xPathContextMajor.newContext();
                xPathContextMajor.setOriginatingConstructType(2000);
                xPathContextMajor2.setCurrentComponent(template.getDeclaringComponent());
                xPathContextMajor2.openStackFrame(template.getStackFrameMap());
                xPathContextMajor2.setLocalParameters(parameterSet2);
                xPathContextMajor2.setTunnelParameters(parameterSet);
                for (TailCall tailCall = template.expand((XPathContext)xPathContextMajor2); tailCall != null; tailCall = tailCall.processLeavingTail()) {
                }
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            xPathContextMajor.notifyChildThreads();
            this.closeResult((Result)receiver, bl, xPathContextMajor);
        }
        finally {
            this.closeMessageEmitter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTemplate(StructuredQName structuredQName, Receiver receiver) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        if (this.initialMode != null && !this.initialMode.isDefaultMode()) {
            throw new XPathException("Initial mode and template cannot both be defined", "XTDE0047");
        }
        this.openMessageEmitter();
        boolean bl = false;
        try {
            Template template;
            ParameterSet parameterSet;
            ParameterSet parameterSet2;
            this.principalResult = receiver;
            if (this.principalResultURI == null) {
                this.principalResultURI = receiver.getSystemId();
            }
            XPathContextMajor xPathContextMajor = this.newXPathContext();
            xPathContextMajor.createThreadManager();
            xPathContextMajor.setOriginatingConstructType(2000);
            NodeInfo nodeInfo = null;
            if (this.initialContextItem != null) {
                nodeInfo = (NodeInfo)this.initialContextItem.head();
            }
            if (nodeInfo != null) {
                this.initialContextItem = nodeInfo;
                this.contextForGlobalVariables = nodeInfo.getRoot();
                if (nodeInfo.getConfiguration() == null) {
                    throw new XPathException("The supplied source document must be associated with a Configuration");
                }
                if (!nodeInfo.getConfiguration().isCompatible(this.executable.getConfiguration())) {
                    throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
                }
                if (nodeInfo instanceof DocumentInfo && ((DocumentInfo)nodeInfo).isTyped() && !this.executable.isSchemaAware()) {
                    throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
                }
                parameterSet2 = SingletonIterator.makeIterator((Item)nodeInfo);
                parameterSet = new FocusTrackingIterator((SequenceIterator)parameterSet2);
                if (structuredQName != null) {
                    parameterSet.next();
                }
                xPathContextMajor.setCurrentIterator((FocusIterator)parameterSet);
            }
            if (this.traceListener != null) {
                this.preEvaluateGlobals((XPathContext)xPathContextMajor);
            }
            receiver = this.openResult(receiver, xPathContextMajor);
            parameterSet2 = null;
            if (this.initialTemplateParams != null) {
                parameterSet2 = new ParameterSet(this.initialTemplateParams);
            }
            parameterSet = null;
            if (this.initialTemplateTunnelParams != null) {
                parameterSet = new ParameterSet(this.initialTemplateTunnelParams);
            }
            if ((template = ((PreparedStylesheet)this.executable).getNamedTemplate(structuredQName)) == null) {
                throw new XPathException("Template " + structuredQName.getDisplayName() + " does not exist (or is not public)", "XTDE0040");
            }
            XPathContextMajor xPathContextMajor2 = xPathContextMajor.newContext();
            xPathContextMajor.setOriginatingConstructType(2000);
            xPathContextMajor2.setCurrentComponent(template.getDeclaringComponent());
            xPathContextMajor2.openStackFrame(template.getStackFrameMap());
            xPathContextMajor2.setLocalParameters(parameterSet2);
            xPathContextMajor2.setTunnelParameters(parameterSet);
            for (TailCall tailCall = template.expand((XPathContext)xPathContextMajor2); tailCall != null; tailCall = tailCall.processLeavingTail()) {
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            xPathContextMajor.notifyChildThreads();
            this.closeResult((Result)receiver, bl, xPathContextMajor);
        }
        finally {
            this.closeMessageEmitter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformStream(Source source, Mode mode, Receiver receiver) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        try {
            boolean bl = receiver instanceof StreamResult && ((StreamResult)receiver).getOutputStream() == null;
            this.principalResult = receiver;
            if (this.principalResultURI == null) {
                this.principalResultURI = receiver.getSystemId();
            }
            XPathContextMajor xPathContextMajor = this.newXPathContext();
            xPathContextMajor.setOriginatingConstructType(2000);
            this.initialContextItem = null;
            this.contextForGlobalVariables = null;
            receiver = this.openResult(receiver, xPathContextMajor);
            if (!mode.isDeclaredStreamable()) {
                if (this.config.getBooleanProperty("http://saxon.sf.net/feature/streamingFallback")) {
                    this.warning("Mode is not streamable; attempting fallback to non-streamed evaluation", "");
                    DocumentInfo documentInfo = this.config.buildDocument(source);
                    this.initialMode = mode;
                    this.transformDocument((NodeInfo)documentInfo, receiver);
                    return;
                }
                throw new XPathException("mode supplied to transformStream() must be streamable");
            }
            Receiver receiver2 = this.config.makeStreamingTransformer((XPathContext)xPathContextMajor, mode);
            if (receiver2 == null) {
                throw new XPathException("Streaming requires Saxon-EE");
            }
            if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
                receiver2 = this.makeStripper(receiver2);
            }
            PipelineConfiguration pipelineConfiguration = receiver2.getPipelineConfiguration();
            pipelineConfiguration.getParseOptions().setSchemaValidationMode(this.validationMode);
            try {
                Sender.send((Source)source, (Receiver)receiver2, null);
            }
            catch (QuitParsingException quitParsingException) {
                // empty catch block
            }
            if (this.traceListener != null) {
                this.traceListener.close();
            }
            this.closeResult((Result)receiver, bl, xPathContextMajor);
        }
        finally {
            this.closeMessageEmitter();
        }
    }

    public Receiver getStreamingReceiver(Mode mode, Receiver receiver) throws XPathException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean bl = receiver instanceof StreamResult && ((StreamResult)receiver).getOutputStream() == null;
        this.principalResult = receiver;
        if (this.principalResultURI == null) {
            this.principalResultURI = receiver.getSystemId();
        }
        XPathContextMajor xPathContextMajor = this.newXPathContext();
        xPathContextMajor.setOriginatingConstructType(2000);
        this.initialContextItem = null;
        this.contextForGlobalVariables = null;
        Receiver receiver2 = this.openResult(receiver, xPathContextMajor);
        if (!mode.isDeclaredStreamable()) {
            throw new XPathException("mode supplied to getStreamingReceiver() must be streamable");
        }
        Receiver receiver3 = this.config.makeStreamingTransformer((XPathContext)xPathContextMajor, mode);
        if (receiver3 == null) {
            throw new XPathException("Streaming requires Saxon-EE");
        }
        if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
            receiver3 = this.makeStripper(receiver3);
        }
        receiver3.setPipelineConfiguration(this.makePipelineConfiguration());
        return new ProxyReceiver(receiver3, (Result)receiver2, bl, xPathContextMajor){
            final /* synthetic */ Result val$result2;
            final /* synthetic */ boolean val$mustClose;
            final /* synthetic */ XPathContextMajor val$initialContext;
            {
                this.val$result2 = result;
                this.val$mustClose = bl;
                this.val$initialContext = xPathContextMajor;
                super(receiver);
            }

            public void close() throws XPathException {
                if (Controller.this.traceListener != null) {
                    Controller.this.traceListener.close();
                }
                Controller.this.closeResult(this.val$result2, this.val$mustClose, this.val$initialContext);
                Controller.this.closeMessageEmitter();
            }
        };
    }

    private void closeMessageEmitter() throws XPathException {
        Receiver receiver = this.getMessageEmitter();
        if (receiver != null) {
            receiver.close();
        }
    }

    private void closeResult(Result result, boolean bl, XPathContextMajor xPathContextMajor) throws XPathException {
        OutputStream outputStream;
        SequenceReceiver sequenceReceiver = xPathContextMajor.getReceiver();
        sequenceReceiver.endDocument();
        sequenceReceiver.close();
        if (bl && result instanceof StreamResult && (outputStream = ((StreamResult)result).getOutputStream()) != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                throw new XPathException((Throwable)iOException);
            }
        }
    }

    private Receiver openResult(Receiver receiver, XPathContextMajor xPathContextMajor) throws XPathException {
        Receiver receiver2 = receiver;
        boolean bl = false;
        if (this.getExecutable().createsSecondaryResult()) {
            receiver2 = new ImplicitResultChecker(receiver2, this);
            receiver2.setPipelineConfiguration(this.makePipelineConfiguration());
        } else {
            bl = true;
        }
        receiver2.getPipelineConfiguration().setController(this);
        xPathContextMajor.changeOutputDestination(receiver2, null);
        if (bl) {
            SequenceReceiver sequenceReceiver = xPathContextMajor.getReceiver();
            sequenceReceiver.open();
            sequenceReceiver.startDocument(0);
        }
        return receiver;
    }

    private void openMessageEmitter() throws XPathException {
        if (this.getMessageEmitter() == null) {
            Receiver receiver = this.makeMessageReceiver();
            this.setMessageEmitter(receiver);
            if (receiver instanceof Emitter && ((Emitter)receiver).getWriter() == null) {
                ((Emitter)receiver).setStreamResult(this.getConfiguration().getLogger().asStreamResult());
            }
        }
        this.getMessageEmitter().open();
    }

    public void preEvaluateGlobals(XPathContext xPathContext) throws XPathException {
        List<GlobalVariable> list = this.getExecutable().getCompiledGlobalVariables();
        if (list != null) {
            for (GlobalVariable globalVariable : list) {
                if (globalVariable.isUnused()) continue;
                try {
                    globalVariable.evaluateVariable(xPathContext, globalVariable.getDeclaringComponent());
                }
                catch (XPathException xPathException) {
                    SingletonClosure singletonClosure = new SingletonClosure((Expression)new ErrorExpression(xPathException), xPathContext);
                    this.getBindery().setGlobalVariable(globalVariable, (Sequence)singletonClosure);
                }
            }
        }
    }

    public void setCurrentDateTime(DateTimeValue dateTimeValue) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTimeValue.getComponent(7) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
        } else {
            throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
        }
        this.currentDateTime = dateTimeValue;
        this.dateTimePreset = true;
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue((Calendar)new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this);
        xPathContextMajor.setCurrentOutputUri(this.principalResultURI);
        return xPathContextMajor;
    }

    public void setRememberedNumber(NodeInfo nodeInfo, int n2) {
        this.lastRememberedNode = nodeInfo;
        this.lastRememberedNumber = n2;
    }

    public int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.lastRememberedNode == nodeInfo) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.pathMap = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.pathMap;
    }
}

