/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.xsd.XsdProperty;
import com.thaiopensource.validate.xerces.ValidatorImpl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

class SchemaImpl
extends AbstractSchema {
    private final SymbolTable symbolTable;
    private final XMLGrammarPool grammarPool;

    SchemaImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, PropertyMap propertyMap, PropertyId<?>[] propertyIdArray) {
        super(propertyMap, propertyIdArray);
        this.symbolTable = symbolTable;
        this.grammarPool = xMLGrammarPool;
    }

    public Validator createValidator(PropertyMap propertyMap) {
        PropertyMap propertyMap2 = propertyMap;
        if (this.getProperties().contains((PropertyId)XsdProperty.XSD_VERSION)) {
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
            for (int i2 = 0; i2 < propertyMap.size(); ++i2) {
                SchemaImpl.copy(propertyMapBuilder, propertyMap.getKey(i2), propertyMap);
            }
            SchemaImpl.copy(propertyMapBuilder, XsdProperty.XSD_VERSION, this.getProperties());
            SchemaImpl.copy(propertyMapBuilder, XsdProperty.FULL_XPATH, this.getProperties());
            propertyMap2 = propertyMapBuilder.toPropertyMap();
        }
        return new ValidatorImpl(this.symbolTable, this.grammarPool, propertyMap2);
    }

    private static <T> void copy(PropertyMapBuilder propertyMapBuilder, PropertyId<T> propertyId, PropertyMap propertyMap) {
        Object object = propertyMap.get(propertyId);
        if (object != null) {
            propertyMapBuilder.put(propertyId, object);
        }
    }
}

