/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.sax;

import com.thaiopensource.relaxng.match.MatchContext;
import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMatcher;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.sax.Context;
import com.thaiopensource.xml.util.Name;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.exml.n.c.k;

public class PatternValidator
extends Context
implements ContentHandler,
DTDHandler {
    private Matcher matcher;
    private final ErrorHandler eh;
    private boolean bufferingCharacters = false;
    private final StringBuilder charBuf = new StringBuilder();
    private Locator locator = null;
    private String rootLocalName = null;

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.rootLocalName == null) {
            this.rootLocalName = string2;
        }
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), (MatchContext)this));
        }
        Name name = new Name(string, string2);
        this.check(this.matcher.matchStartTagOpen(name, string3, (MatchContext)this));
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Name name2 = new Name(attributes.getURI(i2), attributes.getLocalName(i2));
            String string4 = attributes.getQName(i2);
            boolean bl = false;
            if (string4 != null && string4.startsWith("data-") && ("http://www.w3.org/1999/xhtml".equals(string) || "html".equalsIgnoreCase(this.rootLocalName) && "".equals(string)) && !"false".equals(System.getProperty("com.oxygenxml.jing.skip.validation.xhtml.data.attrs"))) {
                bl = true;
            }
            boolean bl2 = this.matcher.matchAttributeName(name2, string4, (MatchContext)this);
            if (bl && !bl2) {
                this.matcher.matchAttributeValue(attributes.getValue(i2), name2, string4, (MatchContext)this);
                continue;
            }
            this.check(bl2);
            this.check(this.matcher.matchAttributeValue(attributes.getValue(i2), name2, string4, (MatchContext)this));
        }
        this.check(this.matcher.matchStartTagClose(name, string3, (MatchContext)this));
        if (this.matcher.isTextTyped()) {
            this.bufferingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            if (this.charBuf.length() > 0) {
                this.check(this.matcher.matchTextBeforeEndTag(this.charBuf.toString(), new Name(string, string2), string3, (MatchContext)this));
            }
        }
        this.check(this.matcher.matchEndTag(new Name(string, string2), string3, (MatchContext)this));
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.bufferingCharacters) {
            this.charBuf.append(cArray, n2, n3);
            return;
        }
        block3: for (int i2 = 0; i2 < n3; ++i2) {
            switch (cArray[n2 + i2]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    this.check(this.matcher.matchUntypedText((MatchContext)this));
                    return;
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.check(this.matcher.matchEndDocument());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.check(this.matcher.matchStartDocument());
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.bufferingCharacters) {
            this.bufferingCharacters = false;
            this.check(this.matcher.matchTextBeforeStartTag(this.charBuf.toString(), (MatchContext)this));
        }
        super.startPrefixMapping(string, string2);
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder, ErrorHandler errorHandler) {
        this.matcher = new PatternMatcher(pattern, validatorPatternBuilder);
        this.eh = errorHandler;
    }

    public void reset() {
        super.reset();
        this.bufferingCharacters = false;
        this.locator = null;
        this.matcher = this.matcher.start();
    }

    private void check(boolean bl) throws SAXException {
        if (!bl) {
            SAXParseException sAXParseException = new SAXParseException(this.matcher.getErrorMessage(), this.locator);
            if (this.matcher instanceof PatternMatcher) {
                PatternMatcher patternMatcher = (PatternMatcher)this.matcher;
                sAXParseException = new k(sAXParseException, patternMatcher.getErrorKey(), patternMatcher.getErrorArgs());
            }
            this.eh.error(sAXParseException);
        }
    }
}

