/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.xml;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.InferHandler;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.ParticleVisitor;
import com.thaiopensource.xml.infer.Schema;
import com.thaiopensource.xml.infer.SequenceParticle;
import com.thaiopensource.xml.infer.TextParticle;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class Inferrer {
    private final Schema schema;
    private final Set<Name> multiplyReferencedElementNames = new HashSet<Name>();
    private final GrammarPattern grammar;
    private final ParticleConverter particleConverter = new ParticleConverter();
    private final List<Name> outputQueue = new Vector<Name>();
    private final Set<Name> queued = new HashSet<Name>();
    private String prefixSeparator;
    private static final String SEPARATORS = ".-_";

    static SchemaCollection infer(String[] stringArray, Options options, ErrorHandler errorHandler) throws SAXException, IOException {
        InputSource inputSource;
        InferHandler inferHandler = new InferHandler((DatatypeLibraryFactory)new DatatypeLibraryLoader());
        XMLReader xMLReader = new SAXResolver(options.resolver).createXMLReader();
        xMLReader.setFeature("http://apache.org/xml/features/xinclude", true);
        xMLReader.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        xMLReader.setErrorHandler(errorHandler);
        xMLReader.setContentHandler((ContentHandler)inferHandler);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            inputSource = new InputSource(stringArray[i2]);
            if (options.encoding != null) {
                inputSource.setEncoding(options.encoding);
            }
            xMLReader.parse(inputSource);
        }
        SchemaCollection schemaCollection = new SchemaCollection();
        schemaCollection.setMainUri(stringArray[0]);
        inputSource = new SchemaDocument((Pattern)new Inferrer((Schema)inferHandler.getSchema()).grammar);
        schemaCollection.getSchemaDocumentMap().put(schemaCollection.getMainUri(), inputSource);
        return schemaCollection;
    }

    private Inferrer(Schema schema) {
        this.schema = schema;
        this.grammar = new GrammarPattern();
        this.findMultiplyReferencedElements();
        this.choosePrefixSeparator();
        this.grammar.getComponents().add(new DefineComponent(DefineComponent.START, this.particleConverter.convert(schema.getStart())));
        for (int i2 = 0; i2 < this.outputQueue.size(); ++i2) {
            Name name = this.outputQueue.get(i2);
            this.grammar.getComponents().add(new DefineComponent(this.getDefineName(name), this.createElementPattern(name)));
        }
    }

    private void findMultiplyReferencedElements() {
        ReferenceFinder referenceFinder = new ReferenceFinder();
        this.schema.getStart().accept((ParticleVisitor)referenceFinder);
        for (ElementDecl elementDecl : this.schema.getElementDecls().values()) {
            Particle particle = elementDecl.getContentModel();
            if (particle == null) continue;
            particle.accept((ParticleVisitor)referenceFinder);
        }
    }

    private void choosePrefixSeparator() {
        Map map = this.schema.getPrefixMap();
        HashSet<String> hashSet = new HashSet<String>();
        for (Name object : this.multiplyReferencedElementNames) {
            hashSet.add(object.getNamespaceUri());
        }
        if (hashSet.size() <= 1) {
            return;
        }
        hashSet.removeAll(map.keySet());
        if (hashSet.size() > 1) {
            hashSet.remove("");
            int n2 = 1;
            for (String string : hashSet) {
                String string2;
                while (map.containsKey(string2 = "ns" + Integer.toString(n2++))) {
                }
                map.put(string, string2);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (true) {
            int n2;
            for (int i2 = 0; i2 < SEPARATORS.length(); ++i2) {
                char c2 = SEPARATORS.charAt(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    stringBuffer.append(c2);
                }
                this.prefixSeparator = stringBuffer.toString();
                if (this.prefixSeparatorOk()) {
                    return;
                }
                stringBuffer.setLength(0);
            }
            ++n2;
        }
    }

    private boolean prefixSeparatorOk() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Name name : this.multiplyReferencedElementNames) {
            String string = this.getDefineName(name);
            if (hashSet.contains(string)) {
                return false;
            }
            hashSet.add(string);
        }
        return true;
    }

    private Pattern createElementPattern(Name name) {
        ElementDecl elementDecl = this.schema.getElementDecl(name);
        Particle particle = elementDecl.getContentModel();
        Object object = particle != null ? this.particleConverter.convert(particle) : Inferrer.makeDatatype(elementDecl.getDatatype());
        Map map = elementDecl.getAttributeDecls();
        if (map.size() > 0) {
            GroupPattern groupPattern = new GroupPattern();
            Vector vector = new Vector();
            vector.addAll(map.keySet());
            Collections.sort(vector, new Comparator<Name>(){

                @Override
                public int compare(Name name, Name name2) {
                    return Name.compare((Name)name, (Name)name2);
                }
            });
            for (Name name2 : vector) {
                AttributeDecl attributeDecl = (AttributeDecl)map.get(name2);
                Object object2 = attributeDecl.getDatatype() == null ? new TextPattern() : Inferrer.makeDatatype(attributeDecl.getDatatype());
                object2 = new AttributePattern((NameClass)this.makeNameClass(name2), (Pattern)object2);
                if (attributeDecl.isOptional()) {
                    object2 = new OptionalPattern((Pattern)object2);
                }
                groupPattern.getChildren().add(object2);
            }
            if (object instanceof GroupPattern) {
                groupPattern.getChildren().addAll(((GroupPattern)object).getChildren());
            } else if (!(object instanceof EmptyPattern)) {
                groupPattern.getChildren().add(object);
            }
            object = groupPattern;
        }
        return new ElementPattern((NameClass)this.makeNameClass(name), (Pattern)object);
    }

    private NameNameClass makeNameClass(Name name) {
        String string;
        String string2 = name.getNamespaceUri();
        NameNameClass nameNameClass = new NameNameClass(string2, name.getLocalName());
        if (!string2.equals("") && (string = (String)this.schema.getPrefixMap().get(string2)) != null) {
            nameNameClass.setPrefix(string);
        }
        return nameNameClass;
    }

    private static DataPattern makeDatatype(Name name) {
        return new DataPattern(name.getNamespaceUri(), name.getLocalName());
    }

    private String getDefineName(Name name) {
        String string;
        if (this.prefixSeparator != null && (string = (String)this.schema.getPrefixMap().get(name.getNamespaceUri())) != null) {
            return string + this.prefixSeparator + name.getLocalName();
        }
        return name.getLocalName();
    }

    private static Pattern normalize(CompositePattern compositePattern) {
        if (compositePattern.getChildren().size() == 1) {
            return (Pattern)compositePattern.getChildren().get(0);
        }
        return compositePattern;
    }

    private class ReferenceFinder
    implements ParticleVisitor {
        private final Set<Name> referencedElementNames = new HashSet<Name>();

        private ReferenceFinder() {
        }

        public Object visitElement(ElementParticle elementParticle) {
            Name name = elementParticle.getName();
            if (this.referencedElementNames.contains(name)) {
                Inferrer.this.multiplyReferencedElementNames.add(name);
            } else {
                this.referencedElementNames.add(name);
            }
            return null;
        }

        public Object visitChoice(ChoiceParticle choiceParticle) {
            choiceParticle.getChild1().accept((ParticleVisitor)this);
            choiceParticle.getChild2().accept((ParticleVisitor)this);
            return null;
        }

        public Object visitSequence(SequenceParticle sequenceParticle) {
            sequenceParticle.getChild1().accept((ParticleVisitor)this);
            sequenceParticle.getChild2().accept((ParticleVisitor)this);
            return null;
        }

        public Object visitEmpty(EmptyParticle emptyParticle) {
            return null;
        }

        public Object visitText(TextParticle textParticle) {
            return null;
        }

        public Object visitOneOrMore(OneOrMoreParticle oneOrMoreParticle) {
            return oneOrMoreParticle.getChild().accept((ParticleVisitor)this);
        }
    }

    private class ParticleConverter
    extends PatternComparator
    implements ParticleVisitor {
        private ParticleConverter() {
        }

        public Object visitElement(ElementParticle elementParticle) {
            Name name = elementParticle.getName();
            if (Inferrer.this.multiplyReferencedElementNames.contains(name)) {
                if (!Inferrer.this.queued.contains(name)) {
                    Inferrer.this.queued.add(name);
                    Inferrer.this.outputQueue.add(name);
                }
                return new RefPattern(Inferrer.this.getDefineName(name));
            }
            return Inferrer.this.createElementPattern(name);
        }

        public Object visitChoice(ChoiceParticle choiceParticle) {
            ChoicePattern choicePattern = new ChoicePattern();
            List list = choicePattern.getChildren();
            this.addChoices(list, choiceParticle.getChild1());
            this.addChoices(list, choiceParticle.getChild2());
            Collections.sort(list, this);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof EmptyPattern)) continue;
                iterator.remove();
                return this.makeOptional(choicePattern);
            }
            return choicePattern;
        }

        private Object makeOptional(ChoicePattern choicePattern) {
            List list = choicePattern.getChildren();
            boolean bl = false;
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Pattern pattern = (Pattern)list.get(i2);
                if (!(pattern instanceof OneOrMorePattern)) continue;
                list.set(i2, new ZeroOrMorePattern(((OneOrMorePattern)pattern).getChild()));
                bl = true;
            }
            if (bl) {
                return Inferrer.normalize((CompositePattern)choicePattern);
            }
            return new OptionalPattern(Inferrer.normalize((CompositePattern)choicePattern));
        }

        private void addChoices(List<Pattern> list, Particle particle) {
            Pattern pattern = this.convert(particle);
            if (pattern instanceof ChoicePattern) {
                list.addAll(((ChoicePattern)pattern).getChildren());
            } else {
                list.add(pattern);
            }
        }

        public Object visitSequence(SequenceParticle sequenceParticle) {
            GroupPattern groupPattern = new GroupPattern();
            this.addGroup(groupPattern.getChildren(), sequenceParticle.getChild1());
            this.addGroup(groupPattern.getChildren(), sequenceParticle.getChild2());
            return groupPattern;
        }

        private void addGroup(List<Pattern> list, Particle particle) {
            Pattern pattern = this.convert(particle);
            if (pattern instanceof GroupPattern) {
                list.addAll(((GroupPattern)pattern).getChildren());
            } else {
                list.add(pattern);
            }
        }

        public Object visitEmpty(EmptyParticle emptyParticle) {
            return new EmptyPattern();
        }

        public Object visitText(TextParticle textParticle) {
            return new TextPattern();
        }

        public Object visitOneOrMore(OneOrMoreParticle oneOrMoreParticle) {
            return new OneOrMorePattern(this.convert(oneOrMoreParticle.getChild()));
        }

        public Pattern convert(Particle particle) {
            return (Pattern)particle.accept((ParticleVisitor)this);
        }
    }

    private static class PatternComparator
    implements Comparator<Pattern> {
        private static final Class<?>[] classOrder = new Class[]{TextPattern.class, RefPattern.class, ElementPattern.class};

        private PatternComparator() {
        }

        @Override
        public int compare(Pattern pattern, Pattern pattern2) {
            if (pattern.getClass() != pattern2.getClass()) {
                return PatternComparator.classIndex(pattern.getClass()) - PatternComparator.classIndex(pattern2.getClass());
            }
            if (pattern instanceof RefPattern) {
                return ((RefPattern)pattern).getName().compareTo(((RefPattern)pattern2).getName());
            }
            if (pattern instanceof ElementPattern) {
                return Name.compare((Name)PatternComparator.extractElementName(pattern), (Name)PatternComparator.extractElementName(pattern2));
            }
            return 0;
        }

        private static Name extractElementName(Object object) {
            NameNameClass nameNameClass = (NameNameClass)((ElementPattern)object).getNameClass();
            return new Name(nameNameClass.getNamespaceUri(), nameNameClass.getLocalName());
        }

        private static int classIndex(Class<? extends Pattern> clazz) {
            for (int i2 = 0; i2 < classOrder.length; ++i2) {
                if (clazz != classOrder[i2]) continue;
                return i2;
            }
            return classOrder.length;
        }
    }

    static class Options {
        String encoding;
        Resolver resolver;

        Options() {
        }
    }
}

