/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.util;

import java.util.EmptyStackException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.SAXException;

public class ParserPool {
    private Stack parsers;
    private SAXParserFactory factory;
    private int capacity;

    public ParserPool(int n2) {
        this.capacity = n2;
        this.factory = new SAXParserFactoryImpl();
        this.factory.setNamespaceAware(true);
        this.parsers = new Stack();
    }

    public synchronized SAXParser get() throws ParserConfigurationException, SAXException {
        try {
            return (SAXParser)this.parsers.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return this.factory.newSAXParser();
        }
    }

    public synchronized void put(SAXParser sAXParser) {
        if (this.parsers.size() < this.capacity) {
            this.parsers.push(sAXParser);
        }
    }
}

