/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.impl;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocument;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.impl.ElementFactory;
import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.impl.FaultImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public abstract class BodyImpl
extends ElementImpl
implements SOAPBody {
    private SOAPFault fault;

    protected BodyImpl(SOAPDocumentImpl sOAPDocumentImpl, NameImpl nameImpl) {
        super(sOAPDocumentImpl, (Name)nameImpl);
    }

    protected abstract NameImpl getFaultName(String var1);

    protected abstract boolean isFault(SOAPElement var1);

    protected abstract SOAPBodyElement createBodyElement(Name var1);

    protected abstract SOAPBodyElement createBodyElement(QName var1);

    protected abstract SOAPFault createFaultElement();

    protected abstract QName getDefaultFaultCode();

    public SOAPFault addFault() throws SOAPException {
        if (this.hasFault()) {
            log.severe("SAAJ0110.impl.fault.already.exists");
            throw new SOAPExceptionImpl("Error: Fault already exists");
        }
        this.fault = this.createFaultElement();
        this.addNode((org.w3c.dom.Node)this.fault);
        this.fault.setFaultCode(this.getDefaultFaultCode());
        this.fault.setFaultString("Fault string, and possibly fault code, not set");
        return this.fault;
    }

    public SOAPFault addFault(Name name, String string, Locale locale) throws SOAPException {
        SOAPFault sOAPFault = this.addFault();
        sOAPFault.setFaultCode(name);
        sOAPFault.setFaultString(string, locale);
        return sOAPFault;
    }

    public SOAPFault addFault(QName qName, String string, Locale locale) throws SOAPException {
        SOAPFault sOAPFault = this.addFault();
        sOAPFault.setFaultCode(qName);
        sOAPFault.setFaultString(string, locale);
        return sOAPFault;
    }

    public SOAPFault addFault(Name name, String string) throws SOAPException {
        SOAPFault sOAPFault = this.addFault();
        sOAPFault.setFaultCode(name);
        sOAPFault.setFaultString(string);
        return sOAPFault;
    }

    public SOAPFault addFault(QName qName, String string) throws SOAPException {
        SOAPFault sOAPFault = this.addFault();
        sOAPFault.setFaultCode(qName);
        sOAPFault.setFaultString(string);
        return sOAPFault;
    }

    void initializeFault() {
        FaultImpl faultImpl = (FaultImpl)this.findFault();
        this.fault = faultImpl;
    }

    protected SOAPElement findFault() {
        Iterator iterator = this.getChildElementNodes();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            if (!this.isFault(sOAPElement)) continue;
            return sOAPElement;
        }
        return null;
    }

    public boolean hasFault() {
        this.initializeFault();
        return this.fault != null;
    }

    public SOAPFault getFault() {
        if (this.hasFault()) {
            return this.fault;
        }
        return null;
    }

    public SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)ElementFactory.createNamedElement((SOAPDocumentImpl)((SOAPDocument)this.getOwnerDocument()).getDocument(), (String)name.getLocalName(), (String)name.getPrefix(), (String)name.getURI());
        if (sOAPBodyElement == null) {
            sOAPBodyElement = this.createBodyElement(name);
        }
        this.addNode((org.w3c.dom.Node)sOAPBodyElement);
        return sOAPBodyElement;
    }

    public SOAPBodyElement addBodyElement(QName qName) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = (SOAPBodyElement)ElementFactory.createNamedElement((SOAPDocumentImpl)((SOAPDocument)this.getOwnerDocument()).getDocument(), (String)qName.getLocalPart(), (String)qName.getPrefix(), (String)qName.getNamespaceURI());
        if (sOAPBodyElement == null) {
            sOAPBodyElement = this.createBodyElement(qName);
        }
        this.addNode((org.w3c.dom.Node)sOAPBodyElement);
        return sOAPBodyElement;
    }

    @Override
    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (!(sOAPElement instanceof SOAPEnvelope)) {
            log.severe("SAAJ0111.impl.body.parent.must.be.envelope");
            throw new SOAPException("Parent of SOAPBody has to be a SOAPEnvelope");
        }
        super.setParentElement(sOAPElement);
    }

    @Override
    protected SOAPElement addElement(Name name) throws SOAPException {
        return this.addBodyElement(name);
    }

    @Override
    protected SOAPElement addElement(QName qName) throws SOAPException {
        return this.addBodyElement(qName);
    }

    public SOAPBodyElement addDocument(Document document) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = null;
        DocumentFragment documentFragment = document.createDocumentFragment();
        Element element = document.getDocumentElement();
        if (element != null) {
            documentFragment.appendChild(element);
            Document document2 = this.getOwnerDocument();
            org.w3c.dom.Node node = document2.importNode(documentFragment, true);
            this.addNode(node);
            Iterator iterator = this.getChildElements(NameImpl.copyElementName((Element)element));
            while (iterator.hasNext()) {
                sOAPBodyElement = (SOAPBodyElement)iterator.next();
            }
        }
        return sOAPBodyElement;
    }

    @Override
    protected SOAPElement convertToSoapElement(Element element) {
        if (element instanceof SOAPBodyElement && !element.getClass().equals(ElementImpl.class)) {
            return (SOAPElement)element;
        }
        return BodyImpl.replaceElementWithSOAPElement(element, (ElementImpl)this.createBodyElement(NameImpl.copyElementName((Element)element)));
    }

    @Override
    public SOAPElement setElementQName(QName qName) throws SOAPException {
        log.log(Level.SEVERE, "SAAJ0146.impl.invalid.name.change.requested", new Object[]{this.elementQName.getLocalPart(), qName.getLocalPart()});
        throw new SOAPException("Cannot change name for " + this.elementQName.getLocalPart() + " to " + qName.getLocalPart());
    }

    public Document extractContentAsDocument() throws SOAPException {
        org.w3c.dom.Node node;
        Iterator iterator = this.getChildElements();
        Node node2 = null;
        while (iterator.hasNext() && !(node2 instanceof SOAPElement)) {
            node2 = (Node)iterator.next();
        }
        boolean bl = true;
        if (node2 == null) {
            bl = false;
        } else {
            for (node = node2.getNextSibling(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            log.log(Level.SEVERE, "SAAJ0250.impl.body.should.have.exactly.one.child");
            throw new SOAPException("Cannot extract Document from body");
        }
        node = null;
        try {
            DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryImpl.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactoryImpl.newDocumentBuilder();
            node = documentBuilder.newDocument();
            Element element = (Element)node.importNode((org.w3c.dom.Node)node2, true);
            node.appendChild(element);
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0251.impl.cannot.extract.document.from.body");
            throw new SOAPExceptionImpl("Unable to extract Document from body", (Throwable)exception);
        }
        node2.detachNode();
        return node;
    }
}

