/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.messaging.saaj.soap.MessageImpl;
import com.sun.xml.messaging.saaj.soap.SOAPExceptionWithContentDetails;
import com.sun.xml.messaging.saaj.soap.ver1_1.Message1_1Impl;
import com.sun.xml.messaging.saaj.soap.ver1_2.Message1_2Impl;
import com.sun.xml.messaging.saaj.util.TeeInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageFactoryImpl
extends MessageFactory {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    protected static OutputStream listener;
    protected boolean lazyAttachments = false;

    public static OutputStream listen(OutputStream outputStream) {
        OutputStream outputStream2 = listener;
        listener = outputStream;
        return outputStream2;
    }

    public SOAPMessage createMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(boolean bl, boolean bl2) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPException, IOException {
        String string = MessageImpl.getContentType(mimeHeaders);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (listener == null && (string != null && string.contains("html") || string.contains("text") || string.contains("xml") || string.contains("script"))) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        if (listener != null || byteArrayOutputStream != null) {
            inputStream = new TeeInputStream(inputStream, listener != null ? listener : byteArrayOutputStream);
        }
        try {
            ContentType contentType = new ContentType(string);
            int n2 = MessageImpl.identifyContentType(contentType);
            if (MessageImpl.isSoap1_1Content(n2)) {
                return new Message1_1Impl(mimeHeaders, contentType, n2, inputStream);
            }
            if (MessageImpl.isSoap1_2Content(n2)) {
                return new Message1_2Impl(mimeHeaders, contentType, n2, inputStream);
            }
            log.severe("SAAJ0530.soap.unknown.Content-Type");
            throw new SOAPExceptionImpl("Unrecognized Content-Type");
        }
        catch (ParseException parseException) {
            log.severe("SAAJ0531.soap.cannot.parse.Content-Type");
            throw new SOAPExceptionImpl("Unable to parse content type: " + parseException.getMessage());
        }
        catch (SOAPException sOAPException) {
            try {
                if (byteArrayOutputStream != null) {
                    while (inputStream.read() != -1) {
                    }
                    throw new SOAPExceptionWithContentDetails(sOAPException.getMessage(), sOAPException, byteArrayOutputStream.toByteArray());
                }
            }
            catch (IOException iOException) {
                log.severe(iOException.getMessage());
            }
            throw sOAPException;
        }
    }

    protected static final String getContentType(MimeHeaders mimeHeaders) {
        String[] stringArray = mimeHeaders.getHeader("Content-Type");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public void setLazyAttachmentOptimization(boolean bl) {
        this.lazyAttachments = bl;
    }
}

