/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.optim.GeneralComparisonEE;
import com.saxonica.ee.optim.IndexedFilterExpression;
import com.saxonica.ee.optim.IndexedValue;
import com.saxonica.ee.optim.MultithreadedForEach;
import com.saxonica.ee.optim.SwitchExpression;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingApplyTemplates;
import com.saxonica.ee.stream.StreamingCopy;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.functions.hof.CallableFunctionItem;
import com.saxonica.functions.hof.SpecificFunctionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CastToUnion;
import net.sf.saxon.expr.CastableToList;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison10;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.PathFinder;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class OptimizerEE
extends Optimizer {
    public OptimizerEE(Configuration configuration) {
        super(configuration);
    }

    public FunctionItem makeCastToUnion(final UnionType unionType, final NamespaceResolver namespaceResolver) {
        Callable callable = new Callable(){

            public Sequence call(XPathContext xPathContext, Sequence[] sequenceArray) throws XPathException {
                AtomicValue atomicValue = (AtomicValue)sequenceArray[0].head();
                if (atomicValue == null) {
                    return EmptySequence.getInstance();
                }
                return CastToUnion.cast((AtomicValue)atomicValue, (UnionType)unionType, (NamespaceResolver)namespaceResolver, (ConversionRules)xPathContext.getConfiguration().getConversionRules());
            }
        };
        SequenceType sequenceType = unionType.getResultTypeOfCast();
        return new CallableFunctionItem(1, callable, (FunctionItemType)new SpecificFunctionType(new SequenceType[]{SequenceType.OPTIONAL_ATOMIC}, sequenceType));
    }

    public BinaryExpression optimizeGeneralComparison(GeneralComparison generalComparison, boolean bl) {
        if (generalComparison instanceof GeneralComparisonEE) {
            return generalComparison;
        }
        if (generalComparison.getOperator() == 6) {
            Expression[] expressionArray = generalComparison.getOperands();
            Expression expression = expressionArray[0];
            Expression expression2 = expressionArray[1];
            boolean bl2 = Cardinality.expectsMany((Expression)expression);
            boolean bl3 = Cardinality.expectsMany((Expression)expression2);
            if (bl2 || bl3) {
                GeneralComparisonEE generalComparisonEE = new GeneralComparisonEE(expression, generalComparison.getOperator(), expression2);
                generalComparisonEE.setAtomicComparer(generalComparison.getAtomicComparer());
                generalComparisonEE.setComparisonCardinality(generalComparison.getComparisonCardinality());
                generalComparisonEE.setNeedsRuntimeCheck(generalComparison.needsRuntimeCheck());
                return generalComparisonEE;
            }
        }
        return generalComparison;
    }

    public Expression optimizeCopy(Expression expression) throws XPathException {
        Expression expression2 = super.optimizeCopy(expression);
        if (expression2 != null) {
            return expression2;
        }
        if (!this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-multithreading")) {
            return null;
        }
        Expression expression3 = this.i(expression);
        if (expression3 != null) {
            ExpressionTool.copyLocationInfo((Expression)expression, (Expression)expression3);
            this.trace("Using streaming copy");
        }
        return expression3;
    }

    private Expression i(Expression expression) throws XPathException {
        Object object;
        Expression expression2;
        Object object2;
        if (!(expression instanceof SlashExpression)) {
            if (expression instanceof DocumentSorter) {
                this.trace("Cannot use streaming copy: expression is not provably in document order");
            } else {
                this.trace("Cannot use streaming copy: not a path expression");
            }
            return null;
        }
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        SlashExpression slashExpression = (SlashExpression)expression;
        Expression expression3 = slashExpression.getFirstStep();
        if (!(expression3 instanceof Doc) && !(expression3 instanceof DocumentFn)) {
            this.trace("Cannot use streaming copy: path must start with call on doc() or document()");
            return null;
        }
        Expression expression4 = expression3;
        Expression expression5 = slashExpression.getRemainingSteps();
        Literal literal = Literal.makeLiteral((GroundedValue)BooleanValue.TRUE, (Container)expression.getContainer());
        if (expression5 instanceof SlashExpression) {
            expression5 = OptimizerEE.h((SlashExpression)expression5);
        }
        if (expression5 instanceof VennExpression) {
            object2 = new HashSet();
            ((VennExpression)expression5).gatherComponents(1, (Set)object2);
            expression2 = object2.iterator();
            while (expression2.hasNext()) {
                object = (Expression)expression2.next();
                ItemType itemType = object.getItemType();
                if (typeHierarchy.isSubType(itemType, (ItemType)NodeKindTest.ELEMENT) || typeHierarchy.isSubType(itemType, (ItemType)NodeKindTest.ATTRIBUTE)) continue;
                this.trace("Cannot use streaming copy: each component of union must return elements or attributes");
                return null;
            }
        } else {
            object2 = expression.getItemType();
            if (!typeHierarchy.isSubType((ItemType)object2, (ItemType)NodeKindTest.ELEMENT) && !typeHierarchy.isSubType((ItemType)object2, (ItemType)NodeKindTest.ATTRIBUTE)) {
                this.trace("Cannot use streaming copy: must be either all-elements or all-attributes");
                return null;
            }
        }
        while (true) {
            object2 = null;
            if (expression5 instanceof FilterExpression) {
                object2 = (FilterExpression)expression5;
            } else if (expression5 instanceof SlashExpression) {
                object2 = this.convertToFilterExpression((SlashExpression)expression5, this.config.getTypeHierarchy());
            }
            if (object2 == null) break;
            expression2 = object2.getFilter();
            if (!expression2.isSubtreeExpression()) {
                this.trace("Cannot use streaming copy: filter looks outside subtree");
                return null;
            }
            literal = new AndExpression((Expression)literal, expression2);
            expression5 = object2.getSelectExpression();
        }
        object2 = new ArrayList();
        expression2 = StreamingPatternMaker.makeStreamingPattern((Expression)expression5, (Configuration)this.config, (List)object2);
        if (expression2 == null) {
            object = "(unspecified reason)";
            if (!object2.isEmpty()) {
                object = (String)object2.get(0);
            }
            this.trace("Cannot use streaming copy: " + (String)object);
            return null;
        }
        return new StreamingCopy(expression4, (Pattern)expression2, (Expression)literal);
    }

    public void makeCopyOperationsExplicit(Expression expression, Expression expression2) throws XPathException {
        block4: {
            Expression[] expressionArray;
            block3: {
                Expression[] expressionArray2;
                boolean bl;
                boolean bl2 = expression2.getItemType() instanceof AtomicType || expression2.getItemType() instanceof FunctionItemType;
                boolean bl3 = bl = expression2 instanceof ContextItemExpression || !bl2 && (expression2.getSpecialProperties() & 0x100000) != 0;
                if (bl) {
                    CopyOf copyOf = new CopyOf(expression2, true, 3, null, false);
                    expression.replaceOperand(expression2, (Expression)copyOf);
                    return;
                }
                if (!(expression2 instanceof Choose)) break block3;
                for (Expression expression3 : expressionArray2 = ((Choose)expression2).getActions()) {
                    this.makeCopyOperationsExplicit(expression2, expression3);
                }
                break block4;
            }
            if (!(expression2 instanceof Block)) break block4;
            for (Expression expression4 : expressionArray = ((Block)expression2).getChildren()) {
                this.makeCopyOperationsExplicit(expression2, expression4);
            }
        }
    }

    public void checkStreamability(XSLTemplate xSLTemplate, Template template) throws XPathException {
        if (template.isDeclaredStreamable()) {
            boolean bl;
            boolean bl2;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = this.getConfiguration().getStreamability();
            if (n2 == 0) {
                arrayList.add("Streaming is disabled for this Saxon Configuration");
                bl2 = false;
            } else {
                bl = n2 == 2;
                bl2 = template.isActuallyStreamable(bl, arrayList);
                if (!bl2 && !bl) {
                    template.getBody().clearStreamabilityData();
                    if (template.isActuallyStreamable(true, new ArrayList<String>())) {
                        arrayList.add("Template would be streamable if Saxon extensions were enabled");
                    }
                }
            }
            if (!bl2) {
                bl = this.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/streamingFallback");
                String string = "Template rule is declared streamable but it does not satisfy the streamability rules. ";
                for (String string2 : arrayList) {
                    string = string + "\n  * " + string2;
                }
                XPathException xPathException = new XPathException(string);
                xPathException.setErrorCode("XTSE3430");
                xPathException.setLocator((SourceLocator)xSLTemplate);
                if (bl) {
                    string = string + "\n  * Falling back to non-streaming implementation";
                    xSLTemplate.getStaticContext().issueWarning(string, (SourceLocator)xSLTemplate);
                    xSLTemplate.getCompiledTemplate().setDeclaredStreamable(false);
                } else {
                    throw xPathException;
                }
            }
        }
    }

    public Expression makeCastableToList(Expression expression, SchemaType schemaType, boolean bl) {
        return new CastableToList(expression, (ListType)schemaType, bl);
    }

    public Expression optimizeForExpressionForStreaming(ForExpression forExpression) throws XPathException {
        Expression expression = Streamability.rewriteForExpressionAsMappingExpression((ForExpression)forExpression);
        if (expression != null) {
            return expression;
        }
        return forExpression;
    }

    public Expression optimizeQuantifiedExpressionForStreaming(QuantifiedExpression quantifiedExpression) throws XPathException {
        Expression expression = Streamability.rewriteQuantifiedExpressionAsFilterExpression((QuantifiedExpression)quantifiedExpression);
        if (expression != null) {
            return expression;
        }
        return null;
    }

    private static Expression h(SlashExpression slashExpression) {
        Expression expression = slashExpression.getFirstStep();
        Expression expression2 = slashExpression.getRemainingSteps();
        if (expression2 instanceof SlashExpression) {
            expression2 = OptimizerEE.h((SlashExpression)expression2);
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        OptimizerEE.c(expression2, arrayList);
        if (arrayList.size() < 2) {
            return slashExpression;
        }
        Expression expression3 = ExpressionTool.makePathExpression((Expression)expression, (Expression)((Expression)arrayList.get(0)), (boolean)false);
        for (int i2 = 1; i2 < arrayList.size(); ++i2) {
            expression3 = new VennExpression(expression3, 1, ExpressionTool.makePathExpression((Expression)expression.copy(), (Expression)((Expression)arrayList.get(i2)), (boolean)false));
        }
        return expression3;
    }

    private static void c(Expression expression, List<Expression> list) {
        if (expression instanceof VennExpression && ((VennExpression)expression).getOperator() == 1) {
            Expression[] expressionArray = ((VennExpression)expression).getOperands();
            OptimizerEE.c(expressionArray[0], list);
            OptimizerEE.c(expressionArray[1], list);
        } else {
            list.add(expression);
        }
    }

    public Expression convertPathExpressionToKey(SlashExpression slashExpression, ExpressionVisitor expressionVisitor) throws XPathException {
        TypeHierarchy typeHierarchy = expressionVisitor.getConfiguration().getTypeHierarchy();
        SlashExpression slashExpression2 = slashExpression.tryToMakeAbsolute(typeHierarchy);
        if (slashExpression2 != null) {
            Expression expression = slashExpression2.getRemainingSteps();
            FilterExpression filterExpression = null;
            if (expression instanceof FilterExpression) {
                filterExpression = (FilterExpression)expression;
                if (filterExpression.getFilter() instanceof BooleanExpression) {
                    filterExpression = this.b(filterExpression.getSelectExpression(), filterExpression.getFilter());
                }
            } else if (expression instanceof SlashExpression) {
                filterExpression = this.convertToFilterExpression((SlashExpression)expression, typeHierarchy);
            }
            if (filterExpression != null) {
                return this.g(filterExpression, expressionVisitor, slashExpression2.getFirstStep());
            }
        }
        return null;
    }

    public Expression tryIndexedFilter(FilterExpression filterExpression, ExpressionVisitor expressionVisitor, boolean bl, boolean bl2) {
        if (expressionVisitor.getStaticContext().isInBackwardsCompatibleMode()) {
            return filterExpression;
        }
        try {
            Expression expression = this.f(filterExpression, expressionVisitor, bl2);
            if (expression != null) {
                return expression;
            }
            if (filterExpression.getSelectExpression() instanceof VariableReference) {
                Binding binding = ((VariableReference)filterExpression.getSelectExpression()).getBinding();
                if (binding instanceof LetExpression && expressionVisitor.isLoopingSubexpression((Expression)((LetExpression)binding))) {
                    ((LetExpression)binding).setIndexedVariable();
                    return new IndexedFilterExpression((VariableReference)filterExpression.getSelectExpression(), (ComparisonExpression)filterExpression.getFilter(), bl);
                }
                if (binding instanceof UserFunctionParameter && expressionVisitor.isLoopingSubexpression(null)) {
                    ((UserFunctionParameter)binding).setIndexedVariable(true);
                    return new IndexedFilterExpression((VariableReference)filterExpression.getSelectExpression(), (ComparisonExpression)filterExpression.getFilter(), bl);
                }
                if (binding instanceof GlobalVariable && !(binding instanceof GlobalParam)) {
                    ((GlobalVariable)binding).setIndexedVariable();
                    return new IndexedFilterExpression((VariableReference)filterExpression.getSelectExpression(), (ComparisonExpression)filterExpression.getFilter(), bl);
                }
            }
        }
        catch (XPathException xPathException) {
            return filterExpression;
        }
        return filterExpression;
    }

    private Expression f(FilterExpression filterExpression, ExpressionVisitor expressionVisitor, boolean bl) throws XPathException {
        TypeHierarchy typeHierarchy;
        Expression expression = filterExpression.getSelectExpression();
        while (!(expression instanceof SlashExpression)) {
            if (expression instanceof AxisExpression) {
                if (!bl) break;
                expression = new SlashExpression((Expression)new RootExpression(), expression);
                break;
            }
            if (expression instanceof VariableReference) {
                typeHierarchy = ((VariableReference)expression).getBinding();
                if (typeHierarchy instanceof LetExpression) {
                    expression = ((LetExpression)typeHierarchy).getSequence();
                    continue;
                }
                return null;
            }
            if (expression instanceof DocumentSorter) {
                expression = ((DocumentSorter)expression).getBaseExpression();
                continue;
            }
            if (expression instanceof FilterExpression) {
                typeHierarchy = (FilterExpression)expression;
                if (!typeHierarchy.isFilterIsPositional() && this.isIndexableFilter(typeHierarchy.getFilter()) == 0) {
                    Expression expression2 = typeHierarchy.getSelectExpression();
                    Expression expression3 = typeHierarchy.getFilter();
                    FilterExpression filterExpression2 = new FilterExpression(expression2.copy(), filterExpression.getFilter().copy());
                    FilterExpression filterExpression3 = new FilterExpression((Expression)filterExpression2, expression3);
                    return this.f(filterExpression3, expressionVisitor, bl);
                }
                return null;
            }
            return null;
        }
        typeHierarchy = expressionVisitor.getConfiguration().getTypeHierarchy();
        if (expression instanceof SlashExpression) {
            SlashExpression slashExpression = (SlashExpression)expression;
            SlashExpression slashExpression2 = slashExpression.tryToMakeAbsolute(typeHierarchy);
            if (slashExpression2 == null) {
                return null;
            }
            Expression expression4 = slashExpression2.getFirstStep();
            if (!typeHierarchy.isSubType(expression4.getItemType(), (ItemType)NodeKindTest.DOCUMENT)) {
                return null;
            }
            return this.g(filterExpression, expressionVisitor, expression4);
        }
        return null;
    }

    private Expression g(FilterExpression filterExpression, ExpressionVisitor expressionVisitor, Expression expression) {
        StructuredQName structuredQName;
        StringCollator stringCollator;
        SlotManager slotManager;
        Configuration configuration;
        String string;
        StaticContext staticContext;
        boolean bl;
        DocumentSorter documentSorter;
        if (filterExpression.getFilter() instanceof BooleanExpression) {
            filterExpression = this.b(filterExpression.getSelectExpression(), filterExpression.getFilter());
        }
        TypeHierarchy typeHierarchy = expressionVisitor.getConfiguration().getTypeHierarchy();
        int n2 = this.isIndexableFilter(filterExpression.getFilter());
        if (n2 == 0) {
            if (filterExpression.isPositional(typeHierarchy)) {
                return null;
            }
            return this.d(filterExpression, expressionVisitor, expression);
        }
        boolean bl2 = n2 > 0;
        Expression expression2 = filterExpression.getSelectExpression().copy();
        if ((expression2.getDependencies() & 0xFFFFFBED) != 0) {
            return this.d(filterExpression, expressionVisitor, expression);
        }
        if (expression2 instanceof SlashExpression && !(expression instanceof RootExpression) && (expression.getDependencies() & 0x1E) != 0) {
            expression2 = new SlashExpression((Expression)new RootExpression(), ((SlashExpression)expression2).getRemainingSteps());
        }
        ComparisonExpression comparisonExpression = (ComparisonExpression)filterExpression.getFilter().copy();
        Expression[] expressionArray = comparisonExpression.getOperands();
        Expression expression3 = expressionArray[bl2 ? 0 : 1];
        Expression expression4 = expressionArray[bl2 ? 1 : 0];
        if ((expression3.getDependencies() & 0xFFFFFBFD) != 0) {
            return null;
        }
        int n3 = expression2.getSpecialProperties();
        if ((n3 & 0x400000) == 0 || (n3 & 0x800000) == 0) {
            return null;
        }
        if ((n3 & 0x20000) == 0) {
            documentSorter = new DocumentSorter(expression2);
            ExpressionTool.copyLocationInfo((Expression)expression2, (Expression)documentSorter);
            expression2 = documentSorter;
        }
        documentSorter = new PathFinder(expression2);
        ItemType itemType = expression3.getItemType();
        if (!itemType.isPlainType()) {
            try {
                expression3 = Atomizer.makeAtomizer((Expression)expression3).simplify(expressionVisitor);
            }
            catch (XPathException xPathException) {
                return null;
            }
            ExpressionTool.copyLocationInfo((Expression)filterExpression, (Expression)expression3);
            itemType = expression3.getItemType();
            if (((AtomicType)itemType).isExternalType()) {
                return null;
            }
        }
        if (bl = comparisonExpression.convertsUntypedToOther()) {
            staticContext = expression4.getItemType().getAtomizedItemType();
            if (!itemType.equals(BuiltInAtomicType.ANY_ATOMIC) || !staticContext.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                if (!(!itemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || staticContext.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || typeHierarchy.isSubType((ItemType)staticContext, (ItemType)BuiltInAtomicType.STRING) || typeHierarchy.isSubType((ItemType)staticContext, (ItemType)BuiltInAtomicType.ANY_ATOMIC))) {
                    string = (AtomicType)staticContext;
                    if (typeHierarchy.isSubType((ItemType)string, (ItemType)BuiltInAtomicType.NUMERIC)) {
                        string = BuiltInAtomicType.DOUBLE;
                    }
                    expression3 = new AtomicSequenceConverter(expression3, (PlainType)string);
                    ((AtomicSequenceConverter)expression3).allocateConverter(this.config, false);
                } else if (!(!staticContext.equals(BuiltInAtomicType.ANY_ATOMIC) && !staticContext.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || typeHierarchy.isSubType(itemType, (ItemType)BuiltInAtomicType.STRING) || typeHierarchy.isSubType((ItemType)staticContext, (ItemType)BuiltInAtomicType.ANY_ATOMIC))) {
                    string = (AtomicType)staticContext;
                    if (typeHierarchy.isSubType((ItemType)string, (ItemType)BuiltInAtomicType.NUMERIC)) {
                        string = BuiltInAtomicType.DOUBLE;
                    }
                    expression4 = new AtomicSequenceConverter(expression4, (PlainType)string);
                    ((AtomicSequenceConverter)expression4).allocateConverter(this.config, false);
                }
            }
        }
        staticContext = expressionVisitor.getStaticContext();
        string = staticContext.getDefaultCollationName();
        KeyManager keyManager = staticContext.getKeyManager();
        KeyDefinitionSet keyDefinitionSet = keyManager.findKeyDefinition((PathFinder)documentSorter, expression3, string);
        if (keyDefinitionSet == null) {
            configuration = expressionVisitor.getConfiguration();
            slotManager = configuration.makeSlotManager();
            int n4 = ExpressionTool.allocateSlots((Expression)documentSorter.getSelectionExpression(), (int)0, (SlotManager)slotManager);
            ExpressionTool.allocateSlots((Expression)expression3, (int)n4, (SlotManager)slotManager);
            try {
                stringCollator = configuration.getCollation(string);
            }
            catch (XPathException xPathException) {
                return null;
            }
            KeyDefinition keyDefinition = new KeyDefinition((PatternFinder)documentSorter, expression3, string, stringCollator);
            keyDefinition.setPackageData(filterExpression.getContainer().getPackageData());
            keyDefinition.setIndexedItemType((BuiltInAtomicType)itemType.getPrimitiveItemType());
            keyDefinition.setConvertUntypedToOther(bl);
            keyDefinition.setStackFrameMap(slotManager);
            structuredQName = new StructuredQName("saxon", "http://saxon.sf.net/", "kk" + (100 + staticContext.getKeyManager().getNumberOfKeyDefinitions()));
            if (filterExpression.getFilter() instanceof ValueComparison) {
                keyDefinition.setStrictComparison(true);
            }
            try {
                staticContext.getKeyManager().addKeyDefinition(structuredQName, keyDefinition, true, expressionVisitor.getConfiguration());
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)xPathException);
            }
            keyDefinitionSet = keyManager.getKeyDefinitionSet(structuredQName);
        } else {
            structuredQName = keyDefinitionSet.getKeyName();
        }
        if (expression.getCardinality() != 16384) {
            slotManager = new ForExpression();
            slotManager.setRequiredType(SequenceType.makeSequenceType((ItemType)expression.getItemType(), (int)expression.getCardinality()));
            slotManager.setVariableQName(new StructuredQName("dd", "http://saxon.sf.net/", "dd" + slotManager.hashCode()));
            Expression expression5 = expression;
            if ((expression5.getSpecialProperties() & 0x20000) == 0) {
                expression5 = new DocumentSorter(expression5);
            }
            slotManager.setSequence(expression5);
            stringCollator = new LocalVariableReference((LocalBinding)slotManager);
            configuration = KeyFn.internalKeyCall((KeyManager)keyManager, (KeyDefinitionSet)keyDefinitionSet, (String)structuredQName.getDisplayName(), (Expression)expression4, (Expression)stringCollator);
            slotManager.setAction((Expression)configuration);
            configuration = slotManager;
        } else {
            configuration = KeyFn.internalKeyCall((KeyManager)keyManager, (KeyDefinitionSet)keyDefinitionSet, (String)structuredQName.getDisplayName(), (Expression)expression4, (Expression)expression);
        }
        ExpressionTool.copyLocationInfo((Expression)filterExpression, (Expression)configuration);
        this.trace("Replaced filter expression with call to key function: ", (Expression)configuration);
        return configuration;
    }

    private Expression d(FilterExpression filterExpression, ExpressionVisitor expressionVisitor, Expression expression) {
        Expression expression2 = filterExpression.getSelectExpression();
        if (expression2 instanceof FilterExpression) {
            Expression expression3 = filterExpression.getFilter();
            Expression expression4 = this.g((FilterExpression)expression2, expressionVisitor, expression);
            if (expression4 != null) {
                FilterExpression filterExpression2 = new FilterExpression(expression4, expression3);
                ExpressionTool.copyLocationInfo((Expression)filterExpression, (Expression)filterExpression2);
                return filterExpression2;
            }
            return null;
        }
        return null;
    }

    public FilterExpression convertToFilterExpression(SlashExpression slashExpression, TypeHierarchy typeHierarchy) throws XPathException {
        Expression expression = slashExpression.getFirstStep();
        Expression expression2 = slashExpression.getRemainingSteps();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        arrayList.add(expression);
        while (expression2 instanceof SlashExpression) {
            expression = ((SlashExpression)expression2).getFirstStep();
            arrayList.add(expression);
            expression2 = ((SlashExpression)expression2).getRemainingSteps();
        }
        if (expression2 instanceof FilterExpression && !((FilterExpression)expression2).isPositional(typeHierarchy)) {
            FilterExpression filterExpression;
            Expression expression3 = ((FilterExpression)expression2).getFilter();
            Expression expression4 = ((FilterExpression)expression2).getSelectExpression();
            boolean bl = expression4 instanceof FilterExpression;
            for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                expression4 = ExpressionTool.makePathExpression((Expression)((Expression)arrayList.get(i2)), (Expression)expression4, (boolean)false);
                ExpressionTool.copyLocationInfo((Expression)slashExpression, (Expression)expression4);
            }
            if (expression4 instanceof SlashExpression && bl && (filterExpression = this.convertToFilterExpression((SlashExpression)expression4, typeHierarchy)) != null) {
                expression4 = filterExpression;
            }
            if (expression3 instanceof BooleanExpression) {
                return this.b(expression4, expression3);
            }
            FilterExpression filterExpression2 = new FilterExpression(expression4, expression3);
            ExpressionTool.copyLocationInfo((Expression)slashExpression, (Expression)filterExpression2);
            this.trace("Moved predicate to outer level of path expression: ", (Expression)filterExpression2);
            return filterExpression2;
        }
        return null;
    }

    private FilterExpression b(Expression expression, Expression expression2) {
        ArrayList arrayList = new ArrayList(4);
        BooleanExpression.listAndComponents((Expression)expression2, arrayList);
        for (Expression expression3 : arrayList) {
            FilterExpression filterExpression = new FilterExpression(expression, expression3);
            ExpressionTool.copyLocationInfo((Expression)expression, (Expression)filterExpression);
            expression = filterExpression;
        }
        this.trace("Split composite predicate into multiple predicates: ", expression);
        return (FilterExpression)expression;
    }

    public int isIndexableFilter(Expression expression) {
        if (expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getSingletonOperator() == 50) {
            return OptimizerEE.e((ComparisonExpression)expression);
        }
        return 0;
    }

    private static int e(ComparisonExpression comparisonExpression) {
        boolean bl;
        if (comparisonExpression instanceof GeneralComparison10) {
            return 0;
        }
        Expression expression = comparisonExpression.getOperands()[0];
        Expression expression2 = comparisonExpression.getOperands()[1];
        boolean bl2 = ExpressionTool.dependsOnFocus((Expression)expression);
        boolean bl3 = (expression.getDependencies() & 0x80) != 0;
        boolean bl4 = ExpressionTool.dependsOnFocus((Expression)expression2);
        boolean bl5 = bl = (expression2.getDependencies() & 0x80) != 0;
        if (bl2 && !bl4 && !bl3) {
            return 1;
        }
        if (bl4 && !bl2 && !bl) {
            return -1;
        }
        return 0;
    }

    public Sequence makeIndexedValue(SequenceIterator sequenceIterator) throws XPathException {
        return new IndexedValue(sequenceIterator);
    }

    public Expression makeConditionalDocumentSorter(DocumentSorter documentSorter, SlashExpression slashExpression) {
        Expression expression;
        Expression expression2 = expression = slashExpression.getFirstStep();
        if (expression instanceof ItemChecker && ((ItemChecker)expression).getRequiredType() instanceof NodeTest) {
            expression2 = ((ItemChecker)expression).getBaseExpression();
        }
        Expression expression3 = slashExpression.getRemainingSteps();
        int n2 = expression3.getSpecialProperties();
        if (!Cardinality.allowsMany((int)expression2.getCardinality()) && (n2 & 0x20000) != 0) {
            return slashExpression;
        }
        if (expression2 instanceof VariableReference && (n2 & 0x20000) != 0) {
            Expression expression4 = expression.copy();
            TailExpression tailExpression = new TailExpression(expression4, 2);
            FunctionCall functionCall = SystemFunctionCall.makeSystemFunction((String)"exists", (Expression[])new Expression[]{tailExpression});
            assert (functionCall != null);
            return new ConditionalSorter((Expression)functionCall, documentSorter);
        }
        return documentSorter;
    }

    public Expression tryInlineFunctionCall(UserFunctionCall userFunctionCall, ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        boolean bl;
        Expression expression;
        UserFunction userFunction = userFunctionCall.getFunction();
        Boolean bl2 = userFunction.isInlineable();
        if (bl2 == null) {
            expression = new ArrayList(10);
            if (userFunction.getBody() == null) {
                return userFunctionCall;
            }
            ExpressionTool.gatherCalledFunctions((Expression)userFunction.getBody(), (List)expression);
            bl = expression.isEmpty() && !ExpressionTool.changesXsltContext((Expression)userFunction.getBody()) && ExpressionTool.expressionSize((Expression)userFunction.getBody()) <= 15 && !userFunction.isMemoFunction();
            userFunction.setInlineable(bl);
        } else {
            bl = bl2;
        }
        if (bl) {
            expression = userFunction.getBody().copy();
            UserFunctionParameter[] userFunctionParameterArray = userFunction.getParameterDefinitions();
            for (int i2 = userFunctionParameterArray.length - 1; i2 >= 0; --i2) {
                UserFunctionParameter userFunctionParameter = userFunctionParameterArray[i2];
                LetExpression letExpression = new LetExpression();
                letExpression.setRequiredType(userFunctionParameter.getRequiredType());
                letExpression.setVariableQName(userFunctionParameter.getVariableQName());
                letExpression.setSequence(userFunctionCall.getArguments()[i2]);
                letExpression.setAction(expression);
                ExpressionTool.rebindVariableReferences((Expression)expression, (Binding)userFunctionParameter, (Binding)letExpression);
                expression = letExpression;
            }
            expression.setContainer(userFunctionCall.getContainer());
            try {
                StructuredQName structuredQName = userFunction.getFunctionName();
                this.trace("Moved function " + (structuredQName == null ? "(anonymous)" : structuredQName.getDisplayName()) + " inline: ", expression);
                expression = expressionVisitor.simplify(expression);
                expression = expressionVisitor.typeCheck(expression, contextItemStaticInfo);
                expression = expressionVisitor.optimize(expression, contextItemStaticInfo);
                return expression;
            }
            catch (XPathException xPathException) {
                return userFunctionCall;
            }
        }
        return userFunctionCall;
    }

    public Expression trySwitch(Choose choose, StaticContext staticContext) {
        Expression[] expressionArray = choose.getConditions();
        Expression[] expressionArray2 = choose.getActions();
        if (expressionArray.length < 4) {
            return choose;
        }
        _b _b2 = new _b();
        _b2.g = this.getConfiguration().getTypeHierarchy();
        _b2.b = null;
        _b2.e = null;
        _b2.f = staticContext.makeEarlyEvaluationContext();
        _b2.c = new HashMap(expressionArray.length);
        try {
            _b2.d = this.getConfiguration().getCollation(staticContext.getDefaultCollationName());
        }
        catch (XPathException xPathException) {
            return choose;
        }
        Literal literal = Literal.makeEmptySequence((Container)expressionArray[0].getContainer());
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            boolean bl;
            Expression expression = expressionArray[i2];
            boolean bl2 = bl = i2 == expressionArray.length - 1 && Literal.isConstantBoolean((Expression)expression, (boolean)true);
            if (bl) {
                literal = expressionArray2[i2];
                continue;
            }
            if (this.processSwitchCondition(expression, expressionArray2[i2], _b2)) continue;
            return choose;
        }
        return new SwitchExpression(_b2.b, _b2.c, (Expression)literal, _b2.d);
    }

    public boolean processSwitchCondition(Expression expression, Expression expression2, _b _b2) {
        if (expression instanceof OrExpression) {
            boolean bl = this.processSwitchCondition(((OrExpression)expression).getArguments()[0], expression2, _b2);
            return bl && this.processSwitchCondition(((OrExpression)expression).getArguments()[1], expression2, _b2);
        }
        if (!(expression instanceof ComparisonExpression)) {
            return false;
        }
        if (expression instanceof GeneralComparison) {
            return false;
        }
        if (((ComparisonExpression)expression).getSingletonOperator() != 50) {
            return false;
        }
        Expression[] expressionArray = ((ComparisonExpression)expression).getOperands();
        Expression expression3 = expressionArray[0];
        Expression expression4 = expressionArray[1];
        if (!Literal.isAtomic((Expression)expression4)) {
            return false;
        }
        if (_b2.b == null) {
            _b2.b = expression3;
            _b2.e = (BuiltInAtomicType)expression4.getItemType().getPrimitiveItemType();
            if (!_b2.e.isOrdered(false)) {
                return false;
            }
        } else {
            if (!_b2.b.equals(expression3)) {
                return false;
            }
            if (!_b2.e.equals((Object)expression4.getItemType().getPrimitiveItemType())) {
                return false;
            }
        }
        try {
            AtomicMatchKey atomicMatchKey = ((AtomicValue)((Literal)expression4).getValue()).getXPathComparable(false, _b2.d, _b2.f.getImplicitTimezone());
            if (atomicMatchKey == null) {
                return false;
            }
            if (_b2.c.get(atomicMatchKey) == null) {
                _b2.c.put(atomicMatchKey, expression2);
            }
        }
        catch (NoDynamicContextException noDynamicContextException) {
            return false;
        }
        return true;
    }

    public Expression promoteExpressionsToGlobal(Expression expression, GlobalVariableManager globalVariableManager, ExpressionVisitor expressionVisitor) throws XPathException {
        PromotionOffer promotionOffer = new PromotionOffer((Optimizer)this);
        promotionOffer.action = 14;
        promotionOffer.globalVariableManager = globalVariableManager;
        promotionOffer.visitor = expressionVisitor;
        Expression expression2 = expression.promote(promotionOffer, null);
        if (promotionOffer.accepted) {
            return expression2;
        }
        return null;
    }

    public Expression extractGlobalVariables(Expression expression, ExpressionVisitor expressionVisitor, PromotionOffer promotionOffer) throws XPathException {
        GlobalVariable globalVariable;
        StructuredQName structuredQName2;
        promotionOffer.accepted = true;
        Collection collection = promotionOffer.globalVariableManager.getGlobalVariableNames();
        for (StructuredQName structuredQName2 : collection) {
            globalVariable = promotionOffer.globalVariableManager.getGlobalVariable(structuredQName2);
            if (globalVariable == null || globalVariable instanceof GlobalParam || globalVariable.isAssignable() || globalVariable.getSelectExpression() == null || !globalVariable.getSelectExpression().equals(expression)) continue;
            GlobalVariableReference globalVariableReference = new GlobalVariableReference(globalVariable);
            SequenceType sequenceType = SequenceType.makeSequenceType((ItemType)expression.getItemType(), (int)expression.getCardinality());
            globalVariableReference.setStaticType(sequenceType, null, expression.getSpecialProperties() | 0x400000);
            return globalVariableReference;
        }
        GlobalVariable globalVariable2 = new GlobalVariable();
        globalVariable2.setPackageData(expression.getContainer().getPackageData());
        globalVariable2.setSystemId(expression.getSystemId());
        globalVariable2.setLineNumber(expression.getLineNumber());
        globalVariable2.setRequiredType(SequenceType.makeSequenceType((ItemType)expression.getItemType(), (int)expression.getCardinality()));
        globalVariable2.setSelectExpression(expression);
        structuredQName2 = new StructuredQName("gg", "http://saxon.sf.net/generated-global-variable", "gg" + globalVariable2.hashCode());
        globalVariable2.setVariableQName(structuredQName2);
        promotionOffer.globalVariableManager.addGlobalVariable(globalVariable2);
        globalVariable = new GlobalVariableReference(globalVariable2);
        globalVariable2.registerReference((BindingReference)globalVariable);
        globalVariable2.typeCheck(expressionVisitor);
        SlotManager slotManager = expressionVisitor.getConfiguration().makeSlotManager();
        int n2 = ExpressionTool.allocateSlots((Expression)expression, (int)0, (SlotManager)slotManager);
        if (n2 > 0) {
            globalVariable2.setContainsLocals(slotManager);
        }
        globalVariable2.init(expression, structuredQName2);
        this.trace("Extracted global variable: ", expression);
        return globalVariable;
    }

    public Expression makeStreamingApplyTemplates(ApplyTemplates applyTemplates, List<String> list) throws XPathException {
        Expression expression = applyTemplates.getSelectExpression();
        if (expression instanceof Doc || expression instanceof DocumentFn) {
            Expression expression2 = expression;
            return new StreamingApplyTemplates(applyTemplates, expression2, (Pattern)new NodeTestPattern((NodeTest)NodeKindTest.DOCUMENT));
        }
        if (expression instanceof SlashExpression) {
            SlashExpression slashExpression = (SlashExpression)expression;
            Expression expression3 = slashExpression.getFirstStep();
            if (!(expression3 instanceof Doc) && !(expression3 instanceof DocumentFn)) {
                list.add("Cannot initiate streaming apply-templates: path must start with call on doc() or document()");
                return null;
            }
            Expression expression4 = expression3;
            Expression expression5 = slashExpression.getRemainingSteps();
            Pattern pattern = StreamingPatternMaker.makeStreamingPattern((Expression)expression5, (Configuration)this.config, list);
            if (pattern == null) {
                return null;
            }
            return new StreamingApplyTemplates(applyTemplates, expression4, pattern);
        }
        if (expression instanceof DocumentSorter) {
            list.add("Cannot initiate streaming apply-templates: expression is not provably in document order");
        } else {
            list.add("Cannot initiate streaming apply-templates: {" + expression.toString() + "} is not a path expression starting with doc()");
        }
        return null;
    }

    public Expression generateMultithreadedInstruction(Expression expression) {
        if (expression instanceof ForEach && this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-multithreading")) {
            ForEach forEach = (ForEach)expression;
            return new MultithreadedForEach(forEach.getSelectExpression(), forEach.getActionExpression(), false, forEach.getNumberOfThreadsExpression());
        }
        return expression;
    }

    public Expression compileToByteCode(Expression expression, String string, int n2) {
        if (expression instanceof CompiledExpression || expression instanceof Literal || expression instanceof VariableReference) {
            return expression;
        }
        CompilerService compilerService = new CompilerService(this.config);
        return compilerService.compileToByteCode(expression, string, n2);
    }

    private static class _b {
        public HashMap<AtomicMatchKey, Expression> c = new HashMap();
        public Expression b = null;
        public BuiltInAtomicType e = null;
        public TypeHierarchy g = null;
        public XPathContext f = null;
        public StringCollator d = null;

        private _b() {
        }
    }
}

