/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.tree.AttributeCollection;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLMessageSaxon
extends StyleElement {
    boolean terminate = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i2 = 0; i2 < attributeCollection.getLength(); ++i2) {
            int n2 = attributeCollection.getNameCode(i2);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.TERMINATE) {
                string = attributeCollection.getValue(i2);
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.terminate = true;
            } else if (string.equals("no")) {
                this.terminate = false;
            } else {
                this.styleError("terminate must be \"yes\" or \"no\"");
            }
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    @Override
    public void process(Context context) throws TransformerException {
        Controller controller = context.getController();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            emitter = controller.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter((Writer)new OutputStreamWriter(System.err));
        }
        Outputter outputter = controller.getOutputter();
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        controller.changeOutputDestination(properties, (Result)emitter);
        this.processChildren(context);
        controller.resetOutputDestination(outputter);
        if (this.terminate) {
            throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber());
        }
    }
}

