

SED(1)                     Unix Programmer's Manual                     SED(1)


NNNAAAMMMEEE
     sed - a Stream EDitor

SSSYYYNNNOOOPPPSSSIIISSS
     sed [-V] [--version] [--help] [-n] [--quiet] [--silent]
         [-l N] [--line-length=N] [-u] [--unbuffered]
         [-e script] [--expression=script]
         [-f script-file] [--file=script-file]
         [script-if-no-other-script]
         [file...]

DDDEEESSSCCCRRRIIIPPPTTTIIIOOONNN
     _S_e_d is a stream editor.  A stream editor is used to  perform  basic  text
     transformations  on  an  input  stream (a file or input from a pipeline).
     While in some ways similar to an  editor  which  permits  scripted  edits
     (such as _e_d), _s_e_d works by making only one pass over the input(s), and is
     consequently more efficient.  But it is _s_e_d's ability to filter text in a
     pipeline which particularly distinguishes it from other types of editors.


OOOPPPTTTIIIOOONNNSSS
     _S_e_d may be invoked with the following command-line options:

     ---VVV

     ------vvveeerrrsssiiiooonnn
          Print out the version of _s_e_d that  is  being  run  and  a  copyright
          notice, then exit.

     ---hhh

     ------hhheeelllppp
          Print a usage message briefly summarizing these command-line options
          and the bug-reporting address, then exit.

     ---nnn

     ------qqquuuiiieeettt

     ------sssiiillleeennnttt
          By default, _s_e_d will print out the pattern space at the end of  each
          cycle  through  the  script.   These  options disable this automatic
          printing, and _s_e_d will only produce output when explicitly  told  to
          via the ppp command.

     ---lll_N

     ------llliiinnneee-llleeennngggttthhh===_N
          Specify the desired line-wrap length for the 'l' command.  A  length
          of 0 (zero) means to never wrap long lines.

     -u

     --unbuffered
          Buffer both input and output as minimally as  practical.   (This  is
          particularly  useful  if the input is coming from the likes of "tail


                                 1999-09-06                                  1



SED(1)                     Unix Programmer's Manual                     SED(1)


          -f", and  you  wish  to  see  the  transformed  output  as  soon  as
          possible.)

     ---eee _s_c_r_i_p_t

     ------eeexxxppprrreeessssssiiiooonnn===_s_c_r_i_p_t
          Add the commands in _s_c_r_i_p_t to the set of commands to  be  run  while
          processing the input.

     ---fff _s_c_r_i_p_t-_f_i_l_e

     ------fffiiillleee===_s_c_r_i_p_t-_f_i_l_e
          Add the commands contained in the file _s_c_r_i_p_t-_f_i_l_e  to  the  set  of
          commands to be run while processing the input.

     If no ---eee,-fff,----eeexxxppprrreeessssssiiiooonnn, or ------fffiiillleee options are  given  on  the  command-
     line,  then the first non-option argument on the command line is taken to
     be the _s_c_r_i_p_t to be executed.

     If any command-line parameters remain after processing the  above,  these
     parameters  are  interpreted as the names of input files to be processed.
     A file name of --- refers to the standard input stream.  The standard input
     will processed if no file names are specified.



     Command Synopsis This is just a brief synopsis of _s_e_d commands  to  serve
     as a reminder to those who already know _s_e_d; other documentation (such as
     the texinfo document) must be consulted for fuller descriptions.


     Zero-address ``commands''

     :\fIlabel
          Label for bbb and ttt commands.

     #_c_o_m_m_e_n_t
          The comment extends until the next newline  (or  the  end  of  a  ---eee
          script fragment).

     }    The closing bracket of a { } block.


     Zero- or One- address commands

     =    Print the current line number.

     a \

     _t_e_x_t Append  _t_e_x_t,  which  has  each  embedded  newline  preceded  by   a
          backslash.

     i \





                                 1999-09-06                                  2



SED(1)                     Unix Programmer's Manual                     SED(1)


     _t_e_x_t Insert  _t_e_x_t,  which  has  each  embedded  newline  preceded  by   a
          backslash.

     q    Immediately quit the _s_e_d script without processing any  more  input,
          except  that if auto-print is not disabled the current pattern space
          will be printed.

     r\fIfilename
          Append text read from _f_i_l_e_n_a_m_e.


     Commands which accept address ranges

     {    Begin a block of commands (end with a }).

     b\fIlabel
          Branch to _l_a_b_e_l; if _l_a_b_e_l is omitted, branch to end of script.

     t\fIlabel
          If a s/// has done a successful substitution since  the  last  input
          line was read and since the last t command, then branch to _l_a_b_e_l; if
          _l_a_b_e_l is omitted, branch to end of script.

     c \

     _t_e_x_t Replace the selected  lines  with  _t_e_x_t,  which  has  each  embedded
          newline preceded by a backslash.

     d    Delete pattern space.  Start next cycle.

     D    Delete up to the first embedded newline in the pattern space.  Start
          next  cycle,  but skip reading from the input if there is still data
          in the pattern space.

     h H  Copy/append pattern space to hold space.

     g G  Copy/append hold space to pattern space.

     x    Exchange the contents of the hold and pattern spaces.

     l    List out the current line in a ``visually unambiguous'' form.

     n N  Read/append the next line of input into the pattern space.

     p    Print the current pattern space.

     P    Print up to the first embedded newline of the current pattern space.

     s/_r_e_g_e_x_p/_r_e_p_l_a_c_e_m_e_n_t/
          Attempt to match _r_e_g_e_x_p against the pattern space.   If  successful,
          replace  that portion matched with _r_e_p_l_a_c_e_m_e_n_t.  The _r_e_p_l_a_c_e_m_e_n_t may
          contain the special character &&& to refer  to  that  portion  of  the
          pattern  space  which matched, and the special escapes \1 through \9
          to refer  to  the  corresponding  matching  sub-expressions  in  the
          _r_e_g_e_x_p.



                                 1999-09-06                                  3



SED(1)                     Unix Programmer's Manual                     SED(1)


     w    _f_i_l_e_n_a_m_e Write the current pattern space to _f_i_l_e_n_a_m_e.

     y/_s_o_u_r_c_e/_d_e_s_t/
          Transliterate the characters in the pattern space  which  appear  in
          _s_o_u_r_c_e to the corresponding character in _d_e_s_t.


     Addresses _S_e_d commands can be given with no addresses, in which case  the
     command  will be executed for all input lines; with one address, in which
     case the command will only be executed for input lines which  match  that
     address;  or  with  two  addresses,  in  which  case  the command will be
     executed for all input lines which match the  inclusive  range  of  lines
     starting  from  the  first  address and continuing to the second address.
     Three things to note about address ranges:   the  syntax  is  _a_d_d_r_1,_a_d_d_r_2
     (i.e.,  the  addresses  are  separated  by a comma); the line which _a_d_d_r_1
     matched will always be accepted, even if _a_d_d_r_2 selects an  earlier  line;
     and  if  _a_d_d_r_2  is  a _r_e_g_e_x_p, it will not be tested against the line that
     _a_d_d_r_1 matched.

     After the address (or address-range), and before the command, a !!! may  be
     inserted,  which specifies that the command shall only be executed if the
     address (or address-range) does nnnooottt match.

     The following address types are supported:

     _n_u_m_b_e_r
          Match only the specified line _n_u_m_b_e_r.

     _f_i_r_s_t~_s_t_e_p
          Match every _s_t_e_p'th line starting with  line  _f_i_r_s_t.   For  example,
          ``sed  -n  1~2p'' will print all the odd-numbered lines in the input
          stream, and the address 2~5 will match every  fifth  line,  starting
          with the second.  (This is a GNU extension.)

     $    Match the last line.

     /_r_e_g_e_x_p/
          Match lines matching the regular expression _r_e_g_e_x_p.

     \ccc_r_e_g_e_x_pccc
          Match lines matching the regular expression _r_e_g_e_x_p.  The  ccc  may  be
          any character.

     GNU _s_e_d also supports some special 2-address forms:

     0,_a_d_d_r_2
          Start out in "matched first address" state, until  _a_d_d_r_2  is  found.
          This  is  similar  to 1,_a_d_d_r_2, except that if _a_d_d_r_2 matches the very
          first line of input the 0,_a_d_d_r_2 form will  be  at  the  end  of  its
          range,  whereas  the  1,_a_d_d_r_2 form will still be at the beginning of
          its range.

     _a_d_d_r_1,+_N
          Will match _a_d_d_r_1 and the _N lines following _a_d_d_r_1.




                                 1999-09-06                                  4



SED(1)                     Unix Programmer's Manual                     SED(1)


     _a_d_d_r_1,~_N
          Will match _a_d_d_r_1 and the lines following _a_d_d_r_1 until the  next  line
          whose input line number is a multiple of _N.


     Regular expressions POSIX.2 BREs _s_h_o_u_l_d be  supported,  but  they  aren't
     completely  yet.   The  \\\nnn  sequence  in a regular expression matches the
     newline character.  There are also some GNU extensions.  [XXX FIXME: more
     needs  to  be  said.   At the very least, a reference to another document
     which describes what is supported should be given.]


     Miscellaneous notes This version of _s_e_d supports a \<<<nnneeewwwllliiinnneee>>> sequence in
     all  regular  expressions,  the  _r_e_p_l_a_c_e_m_e_n_t  part  of  a  substitute (s)
     command, and in the _s_o_u_r_c_e and _d_e_s_t parts of a transliterate (y) command.
     The \ is stripped, and the newline is kept.


     SEE  ALSO  aaawwwkkk(1),  eeeddd(1),  eeexxxppprrr(1),  eeemmmaaacccsss(1),  pppeeerrrlll(1),  tttrrr(1),  vvviii(1),
     rrreeegggeeexxx(5) [well, one _o_u_g_h_t to be written... XXX], sed.info, any of various
     books on _s_e_d, the _s_e_d FAQ
     (http://www.cornerstonemag.com/sed/sedfaq.html),
     http://seders.icheme.org/.


     BUGS

     E-mail bug reports to bbbuuuggg-gggnnnuuu-uuutttiiilllsss@@@gggnnnuuu...ooorrrggg.  Be sure to include the word
     ``sed'' somewhere in the ``Subject:'' field.  Also, please include the
     output of ``sed --version'' in the body of your report if at all
     possible.



























                                 1999-09-06                                  5

